/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Random;
import org.joone.engine.weights.RandomWeightInitializer;
import org.joone.engine.weights.WeightInitializer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class Matrix
implements Serializable,
Cloneable {
    private static final ILogger log = LoggerFactory.getLogger(Matrix.class);
    public static final double DEFAULT_INITIAL = 0.2;
    private static final long serialVersionUID = -1392966842649908366L;
    public double[][] value;
    public double[][] delta;
    public boolean[][] enabled;
    public boolean[][] fixed;
    protected int m_rows;
    protected int m_cols;
    protected WeightInitializer weightInitializer;

    public Matrix() {
    }

    public Matrix(int aRows, int aColumns) {
        this(aRows, aColumns, 0.2);
    }

    public Matrix(int aRows, int aColumns, double anInitial) {
        this.value = new double[aRows][aColumns];
        this.delta = new double[aRows][aColumns];
        this.enabled = new boolean[aRows][aColumns];
        this.fixed = new boolean[aRows][aColumns];
        this.m_rows = aRows;
        this.m_cols = aColumns;
        if (anInitial == 0.0) {
            this.enableAll();
            this.unfixAll();
            this.clear();
        } else {
            this.enableAll();
            this.unfixAll();
            this.setWeightInitializer(new RandomWeightInitializer(anInitial));
            this.initialize();
        }
    }

    public void initialize() {
        this.getWeightInitializer().initialize(this);
    }

    public void setWeightInitializer(WeightInitializer aWeightInitializer) {
        this.weightInitializer = aWeightInitializer;
    }

    public WeightInitializer getWeightInitializer() {
        if (this.weightInitializer == null) {
            this.weightInitializer = new RandomWeightInitializer(0.2);
        }
        return this.weightInitializer;
    }

    public Object clone() {
        Matrix o = null;
        try {
            o = (Matrix)super.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error("Matrix can't clone", e);
        }
        o.value = (double[][])o.value.clone();
        o.delta = (double[][])o.delta.clone();
        o.enabled = (boolean[][])o.enabled.clone();
        o.fixed = (boolean[][])o.fixed.clone();
        for (int x = 0; x < this.m_rows; ++x) {
            o.value[x] = (double[])o.value[x].clone();
            o.delta[x] = (double[])o.delta[x].clone();
            o.enabled[x] = (boolean[])o.enabled[x].clone();
            o.fixed[x] = (boolean[])o.fixed[x].clone();
        }
        return o;
    }

    public void addNoise(double amplitude) {
        Random random = new Random(2004L);
        for (int x = 0; x < this.m_rows; ++x) {
            for (int y = 0; y < this.m_cols; ++y) {
                if (!this.enabled[x][y] || this.fixed[x][y]) continue;
                double[] dArray = this.value[x];
                int n = y;
                dArray[n] = dArray[n] + (-amplitude + random.nextDouble() * (2.0 * amplitude));
            }
        }
    }

    public void removeRow(int aRow) {
        double[][] myValue = new double[this.m_rows - 1][];
        double[][] myDelta = new double[this.m_rows - 1][];
        boolean[][] myEnabled = new boolean[this.m_rows - 1][];
        boolean[][] myFixed = new boolean[this.m_rows - 1][];
        for (int x = 0; x < this.m_rows; ++x) {
            if (x < aRow) {
                myValue[x] = (double[])this.value[x].clone();
                myDelta[x] = (double[])this.delta[x].clone();
                myEnabled[x] = (boolean[])this.enabled[x].clone();
                myFixed[x] = (boolean[])this.fixed[x].clone();
                continue;
            }
            if (x <= aRow) continue;
            myValue[x - 1] = (double[])this.value[x].clone();
            myDelta[x - 1] = (double[])this.delta[x].clone();
            myEnabled[x - 1] = (boolean[])this.enabled[x].clone();
            myFixed[x - 1] = (boolean[])this.fixed[x].clone();
        }
        this.value = myValue;
        this.delta = myDelta;
        this.enabled = myEnabled;
        this.fixed = myFixed;
        --this.m_rows;
    }

    public void removeColumn(int aColumn) {
        double[][] myValue = new double[this.m_rows][this.m_cols - 1];
        double[][] myDelta = new double[this.m_rows][this.m_cols - 1];
        boolean[][] myEnabled = new boolean[this.m_rows][this.m_cols - 1];
        boolean[][] myFixed = new boolean[this.m_rows][this.m_cols - 1];
        for (int x = 0; x < this.m_rows; ++x) {
            for (int y = 0; y < this.m_cols; ++y) {
                if (y < aColumn) {
                    myValue[x][y] = this.value[x][y];
                    myDelta[x][y] = this.delta[x][y];
                    myEnabled[x][y] = this.enabled[x][y];
                    myFixed[x][y] = this.fixed[x][y];
                    continue;
                }
                if (y <= aColumn) continue;
                myValue[x][y - 1] = this.value[x][y];
                myDelta[x][y - 1] = this.delta[x][y];
                myEnabled[x][y - 1] = this.enabled[x][y];
                myFixed[x][y - 1] = this.fixed[x][y];
            }
        }
        this.value = myValue;
        this.delta = myDelta;
        this.enabled = myEnabled;
        this.fixed = myFixed;
        --this.m_cols;
    }

    public void clear() {
        for (int x = 0; x < this.m_rows; ++x) {
            for (int y = 0; y < this.m_cols; ++y) {
                if (!this.enabled[x][y] && this.fixed[x][y]) continue;
                this.value[x][y] = 0.0;
                this.delta[x][y] = 0.0;
            }
        }
    }

    public void enableAll() {
        for (int x = 0; x < this.m_rows; ++x) {
            for (int y = 0; y < this.m_cols; ++y) {
                this.enabled[x][y] = true;
            }
        }
    }

    public void disableAll() {
        for (int x = 0; x < this.m_rows; ++x) {
            for (int y = 0; y < this.m_cols; ++y) {
                this.enabled[x][y] = false;
            }
        }
    }

    public void fixAll() {
        for (int x = 0; x < this.m_rows; ++x) {
            for (int y = 0; y < this.m_cols; ++y) {
                this.fixed[x][y] = true;
            }
        }
    }

    public void unfixAll() {
        for (int x = 0; x < this.m_rows; ++x) {
            for (int y = 0; y < this.m_cols; ++y) {
                this.fixed[x][y] = false;
            }
        }
    }

    public int getM_rows() {
        return this.m_rows;
    }

    public void setM_rows(int newm_rows) {
        this.m_rows = newm_rows;
    }

    public int getM_cols() {
        return this.m_cols;
    }

    public void setM_cols(int newm_cols) {
        this.m_cols = newm_cols;
    }

    public double[][] getDelta() {
        return this.delta;
    }

    public void setDelta(double[][] newdelta) {
        this.delta = newdelta;
    }

    public double[][] getValue() {
        return this.value;
    }

    public void setValue(double[][] newvalue) {
        this.value = newvalue;
    }

    public boolean[][] getFixed() {
        return this.fixed;
    }

    public void setFixed(boolean[][] newfixed) {
        this.fixed = newfixed;
    }

    public boolean[][] getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean[][] newenabled) {
        this.enabled = newenabled;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.enabled == null) {
            this.enabled = new boolean[this.m_rows][this.m_cols];
            this.enableAll();
        }
        if (this.fixed == null) {
            this.fixed = new boolean[this.m_rows][this.m_cols];
            this.unfixAll();
        }
    }
}

