/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import org.joone.engine.LearnableLayer;
import org.joone.engine.Learner;
import org.joone.engine.SimpleLayer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class LogarithmicLayer
extends SimpleLayer
implements LearnableLayer {
    private static final ILogger log = LoggerFactory.getLogger(LogarithmicLayer.class);
    private static final long serialVersionUID = -4983197905588348060L;

    public LogarithmicLayer() {
        this.learnable = true;
    }

    public LogarithmicLayer(String elemName) {
        this();
        this.setLayerName(elemName);
    }

    protected void forward(double[] pattern) {
        int n = this.getRows();
        for (int x = 0; x < n; ++x) {
            double myNeuronInput = pattern[x] + this.getBias().value[x][0];
            this.outs[x] = myNeuronInput >= 0.0 ? Math.log(1.0 + myNeuronInput) : -Math.log(1.0 - myNeuronInput);
        }
    }

    protected void backward(double[] pattern) {
        super.backward(pattern);
        int n = this.getRows();
        for (int x = 0; x < n; ++x) {
            double deriv = this.outs[x] >= 0.0 ? 1.0 / (1.0 + this.outs[x]) : 1.0 / (1.0 - this.outs[x]);
            this.gradientOuts[x] = pattern[x] * deriv;
        }
        this.myLearner.requestBiasUpdate(this.gradientOuts);
    }

    public Learner getLearner() {
        this.learnable = true;
        return super.getLearner();
    }
}

