/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.InputPatternListener;
import org.joone.engine.LearnableLayer;
import org.joone.engine.Learner;
import org.joone.engine.Matrix;
import org.joone.engine.Monitor;
import org.joone.engine.NetErrorManager;
import org.joone.engine.NeuralElement;
import org.joone.engine.NeuralLayer;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.OutputSwitchSynapse;
import org.joone.engine.Pattern;
import org.joone.engine.Synapse;
import org.joone.engine.learning.TeacherSynapse;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.exception.JooneRuntimeException;
import org.joone.inspection.Inspectable;
import org.joone.inspection.implementations.BiasInspection;
import org.joone.io.InputSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.io.StreamOutputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;
import org.joone.util.NotSerialize;

public abstract class Layer
implements NeuralLayer,
Runnable,
Serializable,
Inspectable,
LearnableLayer,
NeuralNetListener {
    public static final int STOP_FLAG = -1;
    private static final long serialVersionUID = -1572591602454639355L;
    private String LayerName;
    private int rows = 0;
    protected Matrix bias;
    protected Monitor monitor;
    protected int m_batch;
    protected boolean learning;
    protected boolean learnable = false;
    protected Vector inputPatternListeners = null;
    protected Vector outputPatternListeners = null;
    private transient Thread myThread = null;
    private transient Object myThreadMonitor;
    protected transient double[] outs;
    protected transient double[] inps;
    protected transient double[] gradientInps;
    protected transient double[] gradientOuts;
    protected transient int step = 0;
    protected transient boolean running = false;
    protected transient Learner myLearner = null;
    private static final ILogger log = LoggerFactory.getLogger(Layer.class);

    public Layer() {
    }

    public Layer(String ElemName) {
        this.setLayerName(ElemName);
    }

    public void addNoise(double amplitude) {
        this.bias.addNoise(amplitude);
        if (this.inputPatternListeners == null) {
            return;
        }
        int currentSize = this.inputPatternListeners.size();
        for (int index = 0; index < currentSize; ++index) {
            InputPatternListener elem = (InputPatternListener)this.inputPatternListeners.elementAt(index);
            if (elem == null || !(elem instanceof Synapse)) continue;
            ((Synapse)elem).addNoise(amplitude);
        }
    }

    public void randomize(double amplitude) {
        this.bias.initialize();
        if (this.inputPatternListeners == null) {
            return;
        }
        int currentSize = this.inputPatternListeners.size();
        for (int index = 0; index < currentSize; ++index) {
            InputPatternListener elem = (InputPatternListener)this.inputPatternListeners.elementAt(index);
            if (elem == null || !(elem instanceof Synapse)) continue;
            ((Synapse)elem).randomize(amplitude);
        }
    }

    protected abstract void backward(double[] var1) throws JooneRuntimeException;

    public NeuralLayer copyInto(NeuralLayer newLayer) {
        newLayer.setMonitor(this.getMonitor());
        newLayer.setRows(this.getRows());
        newLayer.setBias(this.getBias());
        newLayer.setLayerName(this.getLayerName());
        newLayer.setAllInputs((Vector)this.getAllInputs().clone());
        newLayer.setAllOutputs((Vector)this.getAllOutputs().clone());
        this.removeAllInputs();
        this.removeAllOutputs();
        return newLayer;
    }

    protected void fireFwdGet() {
        InputPatternListener tempListener = null;
        int currentSize = this.inputPatternListeners.size();
        this.step = 0;
        for (int index = 0; index < currentSize && this.running; ++index) {
            Pattern tPatt;
            tempListener = (InputPatternListener)this.inputPatternListeners.elementAt(index);
            if (tempListener == null || (tPatt = tempListener.fwdGet()) == null) continue;
            double[] patt = tPatt.getArray();
            if (patt.length != this.inps.length) {
                this.adjustSizeToFwdPattern(patt);
            }
            this.sumInput(patt);
            if (this.step == -1 || this.step >= tPatt.getCount() && tPatt.getCount() != -1) continue;
            this.step = tPatt.getCount();
        }
    }

    protected void fireFwdPut(Pattern pattern) {
        if (this.outputPatternListeners == null) {
            return;
        }
        int currentSize = this.outputPatternListeners.size();
        OutputPatternListener tempListener = null;
        for (int index = 0; index < currentSize && this.running; ++index) {
            tempListener = (OutputPatternListener)this.outputPatternListeners.elementAt(index);
            if (tempListener == null) continue;
            boolean loop = false;
            if (tempListener instanceof Synapse) {
                loop = ((Synapse)tempListener).isLoopBack();
            }
            if (currentSize == 1 && this.getMonitor().isLearningCicle(pattern.getCount()) && !loop) {
                tempListener.fwdPut(pattern);
                continue;
            }
            tempListener.fwdPut((Pattern)pattern.clone());
        }
    }

    protected void fireRevGet() {
        if (this.outputPatternListeners == null) {
            return;
        }
        int currentSize = this.outputPatternListeners.size();
        OutputPatternListener tempListener = null;
        for (int index = 0; index < currentSize && this.running; ++index) {
            Pattern tPatt;
            tempListener = (OutputPatternListener)this.outputPatternListeners.elementAt(index);
            if (tempListener == null || (tPatt = tempListener.revGet()) == null) continue;
            double[] patt = tPatt.getArray();
            if (patt.length != this.gradientInps.length) {
                this.adjustSizeToRevPattern(patt);
            }
            this.sumBackInput(patt);
        }
    }

    protected void fireRevPut(Pattern pattern) {
        if (this.inputPatternListeners == null) {
            return;
        }
        int currentSize = this.inputPatternListeners.size();
        InputPatternListener tempListener = null;
        for (int index = 0; index < currentSize && this.running; ++index) {
            tempListener = (InputPatternListener)this.inputPatternListeners.elementAt(index);
            if (tempListener == null) continue;
            boolean loop = false;
            if (tempListener instanceof Synapse) {
                loop = ((Synapse)tempListener).isLoopBack();
            }
            if (currentSize == 1 && !loop) {
                tempListener.revPut(pattern);
                continue;
            }
            tempListener.revPut((Pattern)pattern.clone());
        }
    }

    protected void adjustSizeToFwdPattern(double[] aPattern) {
        int myOldSize = this.getRows();
        this.setRows(aPattern.length);
        log.warn("Pattern size mismatches #neurons. #neurons in layer adjusted [fwd pass, " + myOldSize + " -> " + this.getRows() + "].");
    }

    protected void adjustSizeToRevPattern(double[] aPattern) {
        int myOldSize = this.getRows();
        this.setRows(aPattern.length);
        log.warn("Pattern size mismatches #neurons. #neurons in layer adjusted [rev pass, " + myOldSize + " -> " + this.getRows() + "].");
    }

    protected abstract void forward(double[] var1) throws JooneRuntimeException;

    public Vector getAllInputs() {
        return this.inputPatternListeners;
    }

    public Vector getAllOutputs() {
        return this.outputPatternListeners;
    }

    public Matrix getBias() {
        return this.bias;
    }

    public int getDimension() {
        return this.getRows();
    }

    public String getLayerName() {
        return this.LayerName;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public int getRows() {
        return this.rows;
    }

    public void removeAllInputs() {
        if (this.inputPatternListeners != null) {
            Vector tempVect = (Vector)this.inputPatternListeners.clone();
            for (int i = 0; i < tempVect.size(); ++i) {
                this.removeInputSynapse((InputPatternListener)tempVect.elementAt(i));
            }
            this.inputPatternListeners = null;
        }
    }

    public void removeAllOutputs() {
        if (this.outputPatternListeners != null) {
            Vector tempVect = (Vector)this.outputPatternListeners.clone();
            for (int i = 0; i < tempVect.size(); ++i) {
                this.removeOutputSynapse((OutputPatternListener)tempVect.elementAt(i));
            }
            this.outputPatternListeners = null;
        }
    }

    public void removeInputSynapse(InputPatternListener newListener) {
        if (this.inputPatternListeners != null) {
            this.inputPatternListeners.removeElement(newListener);
            newListener.setInputFull(false);
            if (this.inputPatternListeners.size() == 0) {
                this.inputPatternListeners = null;
            }
        }
    }

    public void removeOutputSynapse(OutputPatternListener newListener) {
        if (this.outputPatternListeners != null) {
            this.outputPatternListeners.removeElement(newListener);
            newListener.setOutputFull(false);
            if (this.outputPatternListeners.size() == 0) {
                this.outputPatternListeners = null;
            }
        }
    }

    public double[] getLastOutputs() {
        return (double[])this.outs.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws JooneRuntimeException {
        Pattern patt = new Pattern();
        while (this.running) {
            String msg;
            this.inps = new double[this.getRows()];
            try {
                this.fireFwdGet();
                if (this.running) {
                    this.forward(this.inps);
                    patt.setArray(this.outs);
                    patt.setCount(this.step);
                    this.fireFwdPut(patt);
                }
                if (this.step != -1) {
                    this.learning = this.monitor != null ? this.monitor.isLearningCicle(this.step) : false;
                } else {
                    this.running = false;
                }
            }
            catch (JooneRuntimeException jre) {
                msg = "JooneException thrown in run() method." + jre.getMessage();
                log.error(msg);
                this.running = false;
                new NetErrorManager(this.getMonitor(), msg);
            }
            if (!this.learning || !this.running) continue;
            this.gradientInps = new double[this.getDimension()];
            try {
                this.fireRevGet();
                this.backward(this.gradientInps);
                patt.setArray(this.gradientOuts);
                patt.setOutArray(this.outs);
                patt.setCount(this.step);
                this.fireRevPut(patt);
            }
            catch (JooneRuntimeException jre) {
                msg = "In run() JooneException thrown." + jre.getMessage();
                log.error(msg);
                this.running = false;
                new NetErrorManager(this.getMonitor(), msg);
            }
        }
        this.resetInputListeners();
        Object object = this.getThreadMonitor();
        synchronized (object) {
            this.myThread = null;
        }
    }

    public synchronized void setAllInputs(Vector newInputPatternListeners) {
        this.inputPatternListeners = newInputPatternListeners;
        if (this.inputPatternListeners != null) {
            for (int i = 0; i < this.inputPatternListeners.size(); ++i) {
                this.setInputDimension((InputPatternListener)this.inputPatternListeners.elementAt(i));
            }
        }
        this.notifyAll();
    }

    public void setInputSynapses(ArrayList newInputPatternListeners) {
        this.setAllInputs(new Vector(newInputPatternListeners));
    }

    public void setAllOutputs(Vector newOutputPatternListeners) {
        this.outputPatternListeners = newOutputPatternListeners;
        if (this.outputPatternListeners != null) {
            for (int i = 0; i < this.outputPatternListeners.size(); ++i) {
                this.setOutputDimension((OutputPatternListener)this.outputPatternListeners.elementAt(i));
            }
        }
    }

    public void setOutputSynapses(ArrayList newOutputPatternListeners) {
        this.setAllOutputs(new Vector(newOutputPatternListeners));
    }

    public void setBias(Matrix newBias) {
        this.bias = newBias;
    }

    protected abstract void setDimensions();

    protected void setInputDimension(InputPatternListener syn) {
        if (syn.getOutputDimension() != this.getRows()) {
            syn.setOutputDimension(this.getRows());
        }
    }

    public synchronized boolean addInputSynapse(InputPatternListener newListener) {
        if (this.inputPatternListeners == null) {
            this.inputPatternListeners = new Vector();
        }
        boolean retValue = false;
        if (!this.inputPatternListeners.contains(newListener) && !newListener.isInputFull()) {
            this.inputPatternListeners.addElement(newListener);
            if (newListener.getMonitor() == null) {
                newListener.setMonitor(this.getMonitor());
            }
            newListener.setInputFull(true);
            this.setInputDimension(newListener);
            retValue = true;
        }
        this.notifyAll();
        return retValue;
    }

    public void setLayerName(String newLayerName) {
        this.LayerName = newLayerName;
    }

    public void setMonitor(Monitor mon) {
        this.monitor = mon;
        this.setVectMonitor(this.inputPatternListeners, mon);
        this.setVectMonitor(this.outputPatternListeners, mon);
        if (mon != null) {
            mon.addNeuralNetListener(this, false);
        }
    }

    private void setVectMonitor(Vector vect, Monitor mon) {
        if (vect != null) {
            int currentSize = vect.size();
            Object tempListener = null;
            for (int index = 0; index < currentSize; ++index) {
                tempListener = vect.elementAt(index);
                if (tempListener == null) continue;
                ((NeuralElement)tempListener).setMonitor(mon);
            }
        }
    }

    protected void setOutputDimension(OutputPatternListener syn) {
        if (syn.getInputDimension() != this.getRows()) {
            syn.setInputDimension(this.getRows());
        }
    }

    public boolean addOutputSynapse(OutputPatternListener newListener) {
        if (this.outputPatternListeners == null) {
            this.outputPatternListeners = new Vector();
        }
        boolean retValue = false;
        if (!this.outputPatternListeners.contains(newListener) && !newListener.isOutputFull()) {
            this.outputPatternListeners.addElement(newListener);
            newListener.setMonitor(this.getMonitor());
            newListener.setOutputFull(true);
            this.setOutputDimension(newListener);
            retValue = true;
        }
        return retValue;
    }

    public void setRows(int newRows) {
        if (this.rows != newRows) {
            this.rows = newRows;
            this.setDimensions();
            this.setConnDimensions();
            this.bias = new Matrix(this.getRows(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        Object object = this.getThreadMonitor();
        synchronized (object) {
            if (this.myThread != null) return;
            if (this.inputPatternListeners == null) {
                String msg = "Can't start: '" + this.getLayerName() + "' has not input synapses connected";
                log.error(msg);
                throw new JooneRuntimeException(msg);
            }
            if (!this.checkInputEnabled()) {
                String msg = "Can't start: '" + this.getLayerName() + "' has not input synapses connected and/or enabled";
                log.error(msg);
                throw new JooneRuntimeException(msg);
            }
            this.running = true;
            this.myThread = this.getLayerName() != null ? new Thread((Runnable)this, this.getLayerName()) : new Thread(this);
            if (this.monitor != null) {
                this.monitor.addNeuralNetListener(this, false);
            }
            this.init();
            this.myThread.start();
            return;
        }
    }

    public void init() {
        this.initLearner();
        if (this.outputPatternListeners != null) {
            Vector tempVect = (Vector)this.outputPatternListeners.clone();
            for (int i = 0; i < tempVect.size(); ++i) {
                if (!(tempVect.elementAt(i) instanceof NeuralElement)) continue;
                ((NeuralElement)tempVect.elementAt(i)).init();
            }
        }
    }

    protected boolean checkInputEnabled() {
        for (int i = 0; i < this.inputPatternListeners.size(); ++i) {
            InputPatternListener iPatt = (InputPatternListener)this.inputPatternListeners.elementAt(i);
            if (!iPatt.isEnabled()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.getThreadMonitor();
        synchronized (object) {
            if (this.myThread != null) {
                this.running = false;
                this.myThread.interrupt();
            }
        }
    }

    protected void resetInputListeners() {
        int currentSize = this.inputPatternListeners.size();
        for (int index = 0; index < currentSize; ++index) {
            InputPatternListener tempListener = (InputPatternListener)this.inputPatternListeners.elementAt(index);
            if (tempListener == null) continue;
            tempListener.reset();
        }
    }

    protected void sumBackInput(double[] pattern) {
        int x;
        try {
            for (x = 0; x < this.gradientInps.length; ++x) {
                int n = x;
                this.gradientInps[n] = this.gradientInps[n] + pattern[x];
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            log.warn(this.getLayerName() + " gradInps.size:" + this.gradientInps.length + " pattern.size:" + pattern.length + " x:" + x);
        }
    }

    protected void sumInput(double[] pattern) {
        for (int x = 0; x < this.inps.length; ++x) {
            int n = x;
            this.inps[n] = this.inps[n] + pattern[x];
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (in.getClass().getName().indexOf("xstream") != -1) {
            in.defaultReadObject();
        } else {
            this.LayerName = (String)in.readObject();
            this.rows = in.readInt();
            this.bias = (Matrix)in.readObject();
            this.monitor = (Monitor)in.readObject();
            this.m_batch = in.readInt();
            this.learning = in.readBoolean();
            this.inputPatternListeners = this.readVector(in);
            this.outputPatternListeners = this.readVector(in);
        }
        this.setDimensions();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (out.getClass().getName().indexOf("xstream") != -1) {
            out.defaultWriteObject();
        } else {
            out.writeObject(this.LayerName);
            out.writeInt(this.rows);
            out.writeObject(this.bias);
            out.writeObject(this.monitor);
            out.writeInt(this.m_batch);
            out.writeBoolean(this.learning);
            this.writeVector(out, this.inputPatternListeners);
            this.writeVector(out, this.outputPatternListeners);
        }
    }

    private void writeVector(ObjectOutputStream out, Vector vect) throws IOException {
        if (vect != null) {
            boolean exporting = false;
            if (this.monitor != null && this.monitor.isExporting()) {
                exporting = true;
            }
            for (int i = 0; i < vect.size(); ++i) {
                Object obj = vect.elementAt(i);
                if (obj instanceof NotSerialize && exporting) continue;
                out.writeObject(obj);
            }
        }
        out.writeObject(null);
    }

    private Vector readVector(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Vector<Object> vect = new Vector<Object>();
        Object obj = in.readObject();
        while (obj != null) {
            vect.addElement(obj);
            obj = in.readObject();
        }
        return vect;
    }

    protected void setConnDimensions() {
        int index;
        NeuralElement tempListener;
        int currentSize;
        if (this.inputPatternListeners != null) {
            currentSize = this.inputPatternListeners.size();
            tempListener = null;
            for (index = 0; index < currentSize; ++index) {
                tempListener = (InputPatternListener)this.inputPatternListeners.elementAt(index);
                if (tempListener == null) continue;
                this.setInputDimension((InputPatternListener)tempListener);
            }
        }
        if (this.outputPatternListeners != null) {
            currentSize = this.outputPatternListeners.size();
            tempListener = null;
            for (index = 0; index < currentSize; ++index) {
                tempListener = (OutputPatternListener)this.outputPatternListeners.elementAt(index);
                if (tempListener == null) continue;
                this.setOutputDimension((OutputPatternListener)tempListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.getThreadMonitor();
        synchronized (object) {
            return this.myThread != null && this.myThread.isAlive();
            {
            }
        }
    }

    public TreeSet check() {
        NeuralElement listener;
        int i;
        TreeSet<NetCheck> checks = new TreeSet<NetCheck>();
        if (this.inputPatternListeners == null) {
            checks.add(new NetCheck(0, "Layer has no input synapses attached.", this));
        }
        if (this.inputPatternListeners != null) {
            for (i = 0; i < this.inputPatternListeners.size(); ++i) {
                StreamInputSynapse sis;
                int cols;
                listener = (InputPatternListener)this.inputPatternListeners.elementAt(i);
                checks.addAll(listener.check());
                if (!(listener instanceof StreamInputSynapse) || (cols = (sis = (StreamInputSynapse)listener).numColumns()) == this.rows) continue;
                checks.add(new NetCheck(0, "Rows parameter does not match the number of columns for the attached input stream .", this));
            }
        }
        if (this.outputPatternListeners != null) {
            for (i = 0; i < this.outputPatternListeners.size(); ++i) {
                listener = (OutputPatternListener)this.outputPatternListeners.elementAt(i);
                checks.addAll(listener.check());
            }
        }
        return checks;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Name : ").append(this.LayerName).append(", rows : ").append(this.rows).append(", Bias : ").append(this.bias).append(", Monitor : ").append(this.monitor);
        return buf.toString();
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.LayerName = null;
        this.bias = null;
        this.monitor = null;
        if (this.inputPatternListeners != null) {
            this.inputPatternListeners.clear();
            this.inputPatternListeners = null;
        }
        if (this.outputPatternListeners != null) {
            this.outputPatternListeners.clear();
            this.outputPatternListeners = null;
        }
    }

    public Collection Inspections() {
        ArrayList<BiasInspection> col = new ArrayList<BiasInspection>();
        col.add(new BiasInspection(this.bias));
        return col;
    }

    public String InspectableTitle() {
        return this.getLayerName();
    }

    public boolean hasStepCounter() {
        Vector inps = this.getAllInputs();
        if (inps == null) {
            return false;
        }
        for (int x = 0; x < inps.size(); ++x) {
            InputSynapse inp;
            if (!(inps.elementAt(x) instanceof InputSynapse) || !(inp = (InputSynapse)inps.elementAt(x)).isStepCounter()) continue;
            return true;
        }
        return false;
    }

    public boolean isInputLayer() {
        Vector inputListeners = this.getAllInputs();
        return this.checkInputs(inputListeners);
    }

    protected boolean checkInputs(Vector inputListeners) {
        if (inputListeners == null || inputListeners.size() == 0) {
            return true;
        }
        for (int x = 0; x < inputListeners.size(); ++x) {
            if (!(inputListeners.elementAt(x) instanceof StreamInputSynapse)) continue;
            return true;
        }
        return false;
    }

    public boolean isOutputLayer() {
        Vector outputVectors = this.getAllOutputs();
        return this.checkOutputs(outputVectors);
    }

    protected boolean checkOutputs(Vector outputListeners) {
        boolean lastListener = false;
        if (outputListeners == null || outputListeners.size() == 0) {
            return true;
        }
        for (int x = 0; x < outputListeners.size(); ++x) {
            if (outputListeners.elementAt(x) instanceof StreamOutputSynapse || outputListeners.elementAt(x) instanceof TeachingSynapse || outputListeners.elementAt(x) instanceof TeacherSynapse) {
                lastListener = true;
                continue;
            }
            if (outputListeners.elementAt(x) instanceof OutputSwitchSynapse) {
                OutputSwitchSynapse os = (OutputSwitchSynapse)outputListeners.elementAt(x);
                if (this.checkOutputs(os.getAllOutputs())) {
                    lastListener = true;
                    continue;
                }
                return false;
            }
            if (!(outputListeners.elementAt(x) instanceof Synapse)) continue;
            Synapse syn = (Synapse)outputListeners.elementAt(x);
            if (syn.isLoopBack()) {
                lastListener = true;
                continue;
            }
            return false;
        }
        return lastListener;
    }

    public void netStarted(NeuralNetEvent e) {
    }

    public void cicleTerminated(NeuralNetEvent e) {
    }

    public void netStopped(NeuralNetEvent e) {
    }

    public void errorChanged(NeuralNetEvent e) {
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
        this.stop();
    }

    public Learner getLearner() {
        if (!this.learnable) {
            return null;
        }
        return this.getMonitor().getLearner();
    }

    public void initLearner() {
        this.myLearner = this.getLearner();
        if (this.myLearner != null) {
            this.myLearner.registerLearnable(this);
        }
    }

    protected Object getThreadMonitor() {
        if (this.myThreadMonitor == null) {
            this.myThreadMonitor = new Object();
        }
        return this.myThreadMonitor;
    }

    public void join() {
        try {
            if (this.myThread != null) {
                this.myThread.join();
            }
        }
        catch (InterruptedException doNothing) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

