/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.util.ArrayList;
import java.util.List;
import org.joone.engine.AbstractLearner;
import org.joone.engine.extenders.DeltaRuleExtender;
import org.joone.engine.extenders.GradientExtender;
import org.joone.engine.extenders.UpdateWeightExtender;

public class ExtendableLearner
extends AbstractLearner {
    protected List theDeltaRuleExtenders = new ArrayList();
    protected List theGradientExtenders = new ArrayList();
    protected UpdateWeightExtender theUpdateWeightExtender;

    public final void requestBiasUpdate(double[] currentGradientOuts) {
        this.preBiasUpdate(currentGradientOuts);
        for (int x = 0; x < this.getLayer().getRows(); ++x) {
            double myDelta = this.getDelta(currentGradientOuts, x);
            this.updateBias(x, myDelta);
        }
        this.postBiasUpdate(currentGradientOuts);
    }

    public final void requestWeightUpdate(double[] currentPattern, double[] currentInps) {
        this.preWeightUpdate(currentPattern, currentInps);
        for (int x = 0; x < this.getSynapse().getInputDimension(); ++x) {
            for (int y = 0; y < this.getSynapse().getOutputDimension(); ++y) {
                double myDelta = this.getDelta(currentInps, x, currentPattern, y);
                this.updateWeight(x, y, myDelta);
            }
        }
        this.postWeightUpdate(currentPattern, currentInps);
    }

    protected void updateBias(int j, double aDelta) {
        this.theUpdateWeightExtender.updateBias(j, aDelta);
    }

    protected void updateWeight(int j, int k, double aDelta) {
        this.theUpdateWeightExtender.updateWeight(j, k, aDelta);
    }

    protected double getDelta(double[] currentGradientOuts, int j) {
        double myDelta = this.getDefaultDelta(currentGradientOuts, j);
        for (int i = 0; i < this.theDeltaRuleExtenders.size(); ++i) {
            if (!((DeltaRuleExtender)this.theDeltaRuleExtenders.get(i)).isEnabled()) continue;
            myDelta = ((DeltaRuleExtender)this.theDeltaRuleExtenders.get(i)).getDelta(currentGradientOuts, j, myDelta);
        }
        return myDelta;
    }

    public double getDefaultDelta(double[] currentGradientOuts, int j) {
        return this.getLearningRate(j) * this.getGradientBias(currentGradientOuts, j);
    }

    protected double getDelta(double[] currentInps, int j, double[] currentPattern, int k) {
        double myDelta = this.getDefaultDelta(currentInps, j, currentPattern, k);
        for (int i = 0; i < this.theDeltaRuleExtenders.size(); ++i) {
            if (!((DeltaRuleExtender)this.theDeltaRuleExtenders.get(i)).isEnabled()) continue;
            myDelta = ((DeltaRuleExtender)this.theDeltaRuleExtenders.get(i)).getDelta(currentInps, j, currentPattern, k, myDelta);
        }
        return myDelta;
    }

    public double getDefaultDelta(double[] currentInps, int j, double[] currentPattern, int k) {
        return this.getLearningRate(j, k) * this.getGradientWeight(currentInps, j, currentPattern, k);
    }

    protected double getLearningRate(int j) {
        return this.getMonitor().getLearningRate();
    }

    protected double getLearningRate(int j, int k) {
        return this.getMonitor().getLearningRate();
    }

    public double getGradientBias(double[] currentGradientOuts, int j) {
        double myGradient = this.getDefaultGradientBias(currentGradientOuts, j);
        for (int i = 0; i < this.theGradientExtenders.size(); ++i) {
            if (!((GradientExtender)this.theGradientExtenders.get(i)).isEnabled()) continue;
            myGradient = ((GradientExtender)this.theGradientExtenders.get(i)).getGradientBias(currentGradientOuts, j, myGradient);
        }
        return myGradient;
    }

    public double getDefaultGradientBias(double[] currentGradientOuts, int j) {
        return currentGradientOuts[j];
    }

    public double getGradientWeight(double[] currentInps, int j, double[] currentPattern, int k) {
        double myGradient = this.getDefaultGradientWeight(currentInps, j, currentPattern, k);
        for (int i = 0; i < this.theGradientExtenders.size(); ++i) {
            if (!((GradientExtender)this.theGradientExtenders.get(i)).isEnabled()) continue;
            myGradient = ((GradientExtender)this.theGradientExtenders.get(i)).getGradientWeight(currentInps, j, currentPattern, k, myGradient);
        }
        return myGradient;
    }

    public double getDefaultGradientWeight(double[] currentInps, int j, double[] currentPattern, int k) {
        return currentInps[j] * currentPattern[k];
    }

    protected final void preBiasUpdate(double[] currentGradientOuts) {
        int i;
        this.preBiasUpdateImpl(currentGradientOuts);
        if (this.theUpdateWeightExtender != null && this.theUpdateWeightExtender.isEnabled()) {
            this.theUpdateWeightExtender.preBiasUpdate(currentGradientOuts);
        }
        for (i = 0; i < this.theDeltaRuleExtenders.size(); ++i) {
            if (!((DeltaRuleExtender)this.theDeltaRuleExtenders.get(i)).isEnabled()) continue;
            ((DeltaRuleExtender)this.theDeltaRuleExtenders.get(i)).preBiasUpdate(currentGradientOuts);
        }
        for (i = 0; i < this.theGradientExtenders.size(); ++i) {
            if (!((GradientExtender)this.theGradientExtenders.get(i)).isEnabled()) continue;
            ((GradientExtender)this.theGradientExtenders.get(i)).preBiasUpdate(currentGradientOuts);
        }
    }

    protected void preBiasUpdateImpl(double[] currentGradientOuts) {
    }

    protected final void preWeightUpdate(double[] currentPattern, double[] currentInps) {
        int i;
        this.preWeightUpdateImpl(currentPattern, currentInps);
        if (this.theUpdateWeightExtender != null && this.theUpdateWeightExtender.isEnabled()) {
            this.theUpdateWeightExtender.preWeightUpdate(currentInps, currentPattern);
        }
        for (i = 0; i < this.theDeltaRuleExtenders.size(); ++i) {
            if (!((DeltaRuleExtender)this.theDeltaRuleExtenders.get(i)).isEnabled()) continue;
            ((DeltaRuleExtender)this.theDeltaRuleExtenders.get(i)).preWeightUpdate(currentInps, currentPattern);
        }
        for (i = 0; i < this.theGradientExtenders.size(); ++i) {
            if (!((GradientExtender)this.theGradientExtenders.get(i)).isEnabled()) continue;
            ((GradientExtender)this.theGradientExtenders.get(i)).preWeightUpdate(currentInps, currentPattern);
        }
    }

    protected void preWeightUpdateImpl(double[] currentPattern, double[] currentInps) {
    }

    protected final void postBiasUpdate(double[] currentGradientOuts) {
        int i;
        for (i = 0; i < this.theGradientExtenders.size(); ++i) {
            if (!((GradientExtender)this.theGradientExtenders.get(i)).isEnabled()) continue;
            ((GradientExtender)this.theGradientExtenders.get(i)).postBiasUpdate(currentGradientOuts);
        }
        for (i = 0; i < this.theDeltaRuleExtenders.size(); ++i) {
            if (!((DeltaRuleExtender)this.theDeltaRuleExtenders.get(i)).isEnabled()) continue;
            ((DeltaRuleExtender)this.theDeltaRuleExtenders.get(i)).postBiasUpdate(currentGradientOuts);
        }
        if (this.theUpdateWeightExtender != null && this.theUpdateWeightExtender.isEnabled()) {
            this.theUpdateWeightExtender.postBiasUpdate(currentGradientOuts);
        }
        this.postBiasUpdateImpl(currentGradientOuts);
    }

    protected void postBiasUpdateImpl(double[] currentGradientOuts) {
    }

    protected final void postWeightUpdate(double[] currentPattern, double[] currentInps) {
        int i;
        for (i = 0; i < this.theGradientExtenders.size(); ++i) {
            if (!((GradientExtender)this.theGradientExtenders.get(i)).isEnabled()) continue;
            ((GradientExtender)this.theGradientExtenders.get(i)).postWeightUpdate(currentInps, currentPattern);
        }
        for (i = 0; i < this.theDeltaRuleExtenders.size(); ++i) {
            if (!((DeltaRuleExtender)this.theDeltaRuleExtenders.get(i)).isEnabled()) continue;
            ((DeltaRuleExtender)this.theDeltaRuleExtenders.get(i)).postWeightUpdate(currentInps, currentPattern);
        }
        if (this.theUpdateWeightExtender != null && this.theUpdateWeightExtender.isEnabled()) {
            this.theUpdateWeightExtender.postWeightUpdate(currentInps, currentPattern);
        }
        this.postWeightUpdateImpl(currentInps, currentInps);
    }

    protected void postWeightUpdateImpl(double[] currentPattern, double[] currentInps) {
    }

    public void addDeltaRuleExtender(DeltaRuleExtender aDeltaRuleExtender) {
        this.theDeltaRuleExtenders.add(aDeltaRuleExtender);
        aDeltaRuleExtender.setLearner(this);
    }

    public void addGradientExtender(GradientExtender aGradientExtender) {
        this.theGradientExtenders.add(aGradientExtender);
        aGradientExtender.setLearner(this);
    }

    public void setUpdateWeightExtender(UpdateWeightExtender anUpdateWeightExtender) {
        this.theUpdateWeightExtender = anUpdateWeightExtender;
        this.theUpdateWeightExtender.setLearner(this);
    }

    public UpdateWeightExtender getUpdateWeightExtender() {
        return this.theUpdateWeightExtender;
    }
}

