/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.util.TreeSet;
import org.joone.engine.FIRFilter;
import org.joone.engine.Synapse;
import org.joone.net.NetCheck;

public class DelaySynapse
extends Synapse {
    protected FIRFilter[][] fir;
    private int taps;
    private static final long serialVersionUID = 8268129000639124340L;

    public void addNoise(double amplitude) {
        int m_cols = this.getOutputDimension();
        int m_rows = this.getInputDimension();
        for (int y = 0; y < m_cols; ++y) {
            for (int x = 0; x < m_rows; ++x) {
                this.fir[x][y].addNoise(amplitude);
            }
        }
    }

    protected void backward(double[] pattern) {
        int m_rows = this.getInputDimension();
        int m_cols = this.getOutputDimension();
        this.setLearningRate(this.getMonitor().getLearningRate());
        for (int x = 0; x < m_rows; ++x) {
            double s = 0.0;
            for (int y = 0; y < m_cols; ++y) {
                this.fir[x][y].lrate = this.getLearningRate();
                this.fir[x][y].momentum = this.getMomentum();
                s += this.fir[x][y].backward(pattern[y]);
            }
            this.bouts[x] = s;
        }
    }

    protected void forward(double[] pattern) {
        int m_rows = this.getInputDimension();
        int m_cols = this.getOutputDimension();
        for (int y = 0; y < m_cols; ++y) {
            double s = 0.0;
            for (int x = 0; x < m_rows; ++x) {
                s += this.fir[x][y].forward(pattern[x]);
            }
            this.outs[y] = s;
        }
    }

    public int getTaps() {
        return this.taps;
    }

    protected void setArrays(int rows, int cols) {
        this.inps = new double[rows];
        this.outs = new double[cols];
        this.bouts = new double[rows];
    }

    protected void setDimensions(int rows, int cols) {
        int m_rows = this.getInputDimension();
        int m_cols = this.getOutputDimension();
        int irows = rows == -1 ? m_rows : rows;
        int icols = cols == -1 ? m_cols : cols;
        this.fir = new FIRFilter[irows][icols];
        for (int x = 0; x < irows; ++x) {
            for (int y = 0; y < icols; ++y) {
                this.fir[x][y] = new FIRFilter(this.getTaps());
            }
        }
        this.setArrays(irows, icols);
    }

    public void setTaps(int newTaps) {
        this.taps = newTaps;
        this.setDimensions(-1, -1);
    }

    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.getTaps() == 0) {
            checks.add(new NetCheck(0, "The Taps parameter cannot be equal to zero.", this));
        }
        return checks;
    }
}

