/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import samples.preview_new_graphdraw.VisEdge;
import samples.preview_new_graphdraw.VisVertex;

public abstract class AbstractLayout
implements Cloneable {
    public Dimension screenSize;
    public Map visVertexMap = new HashMap();
    public Map visEdgeMap = new HashMap();

    public VisVertex getVisVertex(Vertex v) {
        return (VisVertex)this.visVertexMap.get(v);
    }

    public VisEdge getVisEdge(Edge e) {
        return (VisEdge)this.visEdgeMap.get(e);
    }

    public void setDimensions(Dimension dimension) {
        Dimension oldScreenSize = this.screenSize;
        this.screenSize = dimension;
        this.repositionLayout(oldScreenSize, this.screenSize);
    }

    protected void repositionLayout(Dimension oldScreenSize, Dimension screenSize2) {
        Iterator iter = this.visVertexMap.values().iterator();
        while (iter.hasNext()) {
            VisVertex v = (VisVertex)iter.next();
            v.offset((screenSize2.width - oldScreenSize.width) / 2, (screenSize2.height - oldScreenSize.height) / 2);
        }
    }

    public Dimension getScreenSize() {
        return this.screenSize;
    }
}

