/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.DefaultToolTipFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.EllipseVertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.PickableVertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexIconAndShapeFunction;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.DirectedSparseVertex;
import edu.uci.ics.jung.visualization.DefaultGraphLabelRenderer;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseWheelEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class UnicodeLabelDemo {
    Graph graph = new DirectedSparseGraph();
    VisualizationViewer vv;
    boolean showLabels;

    public UnicodeLabelDemo() {
        Vertex[] v = this.createVertices(10);
        this.createEdges(v);
        PluggableRenderer pr = new PluggableRenderer();
        pr.setVertexStringer(new UnicodeVertexStringer(v));
        pr.setVertexPaintFunction(new PickableVertexPaintFunction(pr, Color.lightGray, Color.white, Color.yellow));
        pr.setGraphLabelRenderer(new DefaultGraphLabelRenderer(Color.cyan, Color.cyan));
        VertexIconAndShapeFunction dvisf = new VertexIconAndShapeFunction(new EllipseVertexShapeFunction());
        pr.setVertexShapeFunction(dvisf);
        pr.setVertexIconFunction(dvisf);
        this.loadImages(v, dvisf.getIconMap());
        this.vv = new VisualizationViewer(new FRLayout(this.graph), (Renderer)pr);
        this.vv.setPickSupport(new ShapePickSupport());
        pr.setEdgeShapeFunction(new EdgeShape.QuadCurve());
        this.vv.setBackground(Color.white);
        this.vv.setToolTipFunction(new DefaultToolTipFunction());
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add(panel);
        frame.setDefaultCloseOperation(3);
        final DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(gm);
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Dimension d = UnicodeLabelDemo.this.vv.getSize();
                gm.mouseWheelMoved(new MouseWheelEvent((Component)UnicodeLabelDemo.this.vv, 507, System.currentTimeMillis(), 0, d.width / 2, d.height / 2, 1, false, 0, 1, 1));
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Dimension d = UnicodeLabelDemo.this.vv.getSize();
                gm.mouseWheelMoved(new MouseWheelEvent((Component)UnicodeLabelDemo.this.vv, 507, System.currentTimeMillis(), 0, d.width / 2, d.height / 2, 1, false, 0, 1, -1));
            }
        });
        JCheckBox lo = new JCheckBox("Show Labels");
        lo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                UnicodeLabelDemo.this.showLabels = e.getStateChange() == 1;
                UnicodeLabelDemo.this.vv.repaint();
            }
        });
        lo.setSelected(true);
        JPanel controls = new JPanel();
        controls.add(plus);
        controls.add(minus);
        controls.add(lo);
        controls.add(gm.getModeComboBox());
        content.add((Component)controls, "South");
        frame.pack();
        frame.show();
    }

    private Vertex[] createVertices(int count) {
        Vertex[] v = new Vertex[count];
        for (int i = 0; i < count; ++i) {
            v[i] = this.graph.addVertex(new DirectedSparseVertex());
        }
        return v;
    }

    void createEdges(Vertex[] v) {
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[1]));
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[3]));
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[4]));
        this.graph.addEdge(new DirectedSparseEdge(v[4], v[5]));
        this.graph.addEdge(new DirectedSparseEdge(v[3], v[5]));
        this.graph.addEdge(new DirectedSparseEdge(v[1], v[2]));
        this.graph.addEdge(new DirectedSparseEdge(v[1], v[4]));
        this.graph.addEdge(new DirectedSparseEdge(v[8], v[2]));
        this.graph.addEdge(new DirectedSparseEdge(v[3], v[8]));
        this.graph.addEdge(new DirectedSparseEdge(v[6], v[7]));
        this.graph.addEdge(new DirectedSparseEdge(v[7], v[5]));
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[9]));
        this.graph.addEdge(new DirectedSparseEdge(v[9], v[8]));
        this.graph.addEdge(new DirectedSparseEdge(v[7], v[6]));
        this.graph.addEdge(new DirectedSparseEdge(v[6], v[5]));
        this.graph.addEdge(new DirectedSparseEdge(v[4], v[2]));
        this.graph.addEdge(new DirectedSparseEdge(v[5], v[4]));
    }

    protected void loadImages(Vertex[] vertices, Map imageMap) {
        ImageIcon[] icons = null;
        try {
            icons = new ImageIcon[]{new ImageIcon(this.getClass().getResource("/united-states.gif")), new ImageIcon(this.getClass().getResource("/china.gif")), new ImageIcon(this.getClass().getResource("/russia.gif")), new ImageIcon(this.getClass().getResource("/france.gif")), new ImageIcon(this.getClass().getResource("/germany.gif")), new ImageIcon(this.getClass().getResource("/japan.gif")), new ImageIcon(this.getClass().getResource("/spain.gif"))};
        }
        catch (Exception ex) {
            System.err.println("You need flags.jar in your classpath to see the flag icons.");
        }
        for (int i = 0; icons != null && i < vertices.length; ++i) {
            imageMap.put(vertices[i], icons[i % icons.length]);
        }
    }

    public static void main(String[] args) {
        new UnicodeLabelDemo();
    }

    class UnicodeVertexStringer
    implements VertexStringer {
        Map map = new HashMap();
        Map iconMap = new HashMap();
        String[] labels = new String[]{"Welcome to Jung!", "\u6b22\u8fce\u4f7f\u7528  Jung!", "\u0414\u043e\u0431\u0440\u043e \u043f\u043e\u0436\u0430\u043b\u043e\u0432\u0430\u0422\u044a \u0432 Jung!", "Bienvenue au Jung!", "Wilkommen zu Jung!", "Jung\u3078\u3087\u3045\u3053\u305d!", "Bienvenida a Jung!"};

        public UnicodeVertexStringer(Vertex[] vertices) {
            for (int i = 0; i < vertices.length; ++i) {
                this.map.put(vertices[i], this.labels[i % this.labels.length]);
            }
        }

        public String getLabel(ArchetypeVertex v) {
            if (UnicodeLabelDemo.this.showLabels) {
                return (String)this.map.get(v);
            }
            return "";
        }

        public Icon getIcon(Vertex v) {
            return (Icon)this.iconMap.get(v);
        }
    }
}

