/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.decorators.DefaultToolTipFunction;
import edu.uci.ics.jung.graph.decorators.PickableEdgePaintFunction;
import edu.uci.ics.jung.utils.TestGraphs;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.ISOMLayout;
import edu.uci.ics.jung.visualization.MultiPickedState;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TwoModelDemo
extends JApplet {
    Graph graph;
    VisualizationViewer vv1;
    VisualizationViewer vv2;
    MutableTransformer layoutTransformer;
    Dimension preferredSize = new Dimension(300, 300);

    public TwoModelDemo() {
        this.graph = TestGraphs.getOneComponentGraph();
        PluggableRenderer pr = new PluggableRenderer();
        FRLayout layout1 = new FRLayout(this.graph);
        ISOMLayout layout2 = new ISOMLayout(this.graph);
        DefaultVisualizationModel vm1 = new DefaultVisualizationModel(layout1, this.preferredSize);
        DefaultVisualizationModel vm2 = new DefaultVisualizationModel(layout2, this.preferredSize);
        this.vv1 = new VisualizationViewer(vm1, (Renderer)pr, this.preferredSize);
        this.vv2 = new VisualizationViewer(vm2, (Renderer)pr, this.preferredSize);
        this.layoutTransformer = this.vv1.getLayoutTransformer();
        this.vv2.setLayoutTransformer(this.layoutTransformer);
        this.vv2.setViewTransformer(this.vv1.getViewTransformer());
        this.vv1.setBackground(Color.white);
        this.vv2.setBackground(Color.white);
        ShapePickSupport pickSupport1 = new ShapePickSupport();
        this.vv1.setPickSupport(pickSupport1);
        ShapePickSupport pickSupport2 = new ShapePickSupport();
        this.vv2.setPickSupport(pickSupport2);
        MultiPickedState ps = new MultiPickedState();
        this.vv1.setPickedState(ps);
        this.vv2.setPickedState(ps);
        pr.setEdgePaintFunction(new PickableEdgePaintFunction(ps, Color.black, Color.red));
        this.vv1.setToolTipFunction(new DefaultToolTipFunction());
        this.vv2.setToolTipFunction(new DefaultToolTipFunction());
        Container content = this.getContentPane();
        JPanel panel = new JPanel(new GridLayout(1, 0));
        panel.add(new GraphZoomScrollPane(this.vv1));
        panel.add(new GraphZoomScrollPane(this.vv2));
        content.add(panel);
        final DefaultModalGraphMouse gm1 = new DefaultModalGraphMouse();
        DefaultModalGraphMouse gm2 = new DefaultModalGraphMouse();
        this.vv1.setGraphMouse(gm1);
        this.vv2.setGraphMouse(gm2);
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Dimension d = TwoModelDemo.this.vv1.getSize();
                gm1.mouseWheelMoved(new MouseWheelEvent((Component)TwoModelDemo.this.vv1, 507, System.currentTimeMillis(), 0, d.width / 2, d.height / 2, 1, false, 0, 1, 1));
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Dimension d = TwoModelDemo.this.vv1.getSize();
                gm1.mouseWheelMoved(new MouseWheelEvent((Component)TwoModelDemo.this.vv1, 507, System.currentTimeMillis(), 0, d.width / 2, d.height / 2, 1, false, 0, 1, -1));
            }
        });
        JPanel zoomPanel = new JPanel(new GridLayout(1, 2));
        zoomPanel.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel modePanel = new JPanel();
        modePanel.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        gm1.getModeComboBox().addItemListener(gm2.getModeListener());
        modePanel.add(gm1.getModeComboBox());
        JPanel controls = new JPanel();
        zoomPanel.add(plus);
        zoomPanel.add(minus);
        controls.add(zoomPanel);
        controls.add(modePanel);
        content.add((Component)controls, "South");
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new TwoModelDemo());
        f.pack();
        f.show();
    }
}

