/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.TestGraphs;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PickedInfo;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.RadiusPickSupport;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ShowLayouts
extends JApplet {
    static final Class[] constructorArgsWanted = new Class[]{class$edu$uci$ics$jung$graph$Graph == null ? (class$edu$uci$ics$jung$graph$Graph = ShowLayouts.class$("edu.uci.ics.jung.graph.Graph")) : class$edu$uci$ics$jung$graph$Graph};
    static /* synthetic */ Class class$edu$uci$ics$jung$graph$Graph;
    static /* synthetic */ Class class$edu$uci$ics$jung$visualization$FRLayout;
    static /* synthetic */ Class class$edu$uci$ics$jung$visualization$contrib$KKLayout;
    static /* synthetic */ Class class$edu$uci$ics$jung$visualization$contrib$CircleLayout;
    static /* synthetic */ Class class$edu$uci$ics$jung$visualization$SpringLayout;
    static /* synthetic */ Class class$edu$uci$ics$jung$visualization$ISOMLayout;

    public static void main(String[] args) {
        JPanel jp = ShowLayouts.getGraphPanel();
        JFrame jf = new JFrame();
        jf.getContentPane().add(jp);
        jf.setDefaultCloseOperation(3);
        jf.pack();
        jf.show();
    }

    private static JPanel getGraphPanel() {
        Graph g = TestGraphs.getOneComponentGraph();
        VisualizationViewer vv = new VisualizationViewer(new FRLayout(g), (Renderer)new PluggableRenderer());
        vv.setPickSupport(new RadiusPickSupport(10.0));
        JPanel jp = new JPanel();
        jp.setBackground(Color.WHITE);
        jp.setLayout(new BorderLayout());
        jp.add((Component)vv, "Center");
        Class[] combos = ShowLayouts.getCombos();
        JComboBox<Class> jcb = new JComboBox<Class>(combos);
        jcb.addActionListener(new LayoutChooser(jcb, g, vv));
        jcb.setSelectedItem(class$edu$uci$ics$jung$visualization$FRLayout == null ? (class$edu$uci$ics$jung$visualization$FRLayout = ShowLayouts.class$("edu.uci.ics.jung.visualization.FRLayout")) : class$edu$uci$ics$jung$visualization$FRLayout);
        jp.add(jcb, "North");
        return jp;
    }

    public void start() {
        this.getContentPane().add(ShowLayouts.getGraphPanel());
    }

    private static Class[] getCombos() {
        ArrayList<Class> layouts = new ArrayList<Class>();
        layouts.add(class$edu$uci$ics$jung$visualization$contrib$KKLayout == null ? (class$edu$uci$ics$jung$visualization$contrib$KKLayout = ShowLayouts.class$("edu.uci.ics.jung.visualization.contrib.KKLayout")) : class$edu$uci$ics$jung$visualization$contrib$KKLayout);
        layouts.add(class$edu$uci$ics$jung$visualization$FRLayout == null ? (class$edu$uci$ics$jung$visualization$FRLayout = ShowLayouts.class$("edu.uci.ics.jung.visualization.FRLayout")) : class$edu$uci$ics$jung$visualization$FRLayout);
        layouts.add(class$edu$uci$ics$jung$visualization$contrib$CircleLayout == null ? (class$edu$uci$ics$jung$visualization$contrib$CircleLayout = ShowLayouts.class$("edu.uci.ics.jung.visualization.contrib.CircleLayout")) : class$edu$uci$ics$jung$visualization$contrib$CircleLayout);
        layouts.add(class$edu$uci$ics$jung$visualization$SpringLayout == null ? (class$edu$uci$ics$jung$visualization$SpringLayout = ShowLayouts.class$("edu.uci.ics.jung.visualization.SpringLayout")) : class$edu$uci$ics$jung$visualization$SpringLayout);
        layouts.add(class$edu$uci$ics$jung$visualization$ISOMLayout == null ? (class$edu$uci$ics$jung$visualization$ISOMLayout = ShowLayouts.class$("edu.uci.ics.jung.visualization.ISOMLayout")) : class$edu$uci$ics$jung$visualization$ISOMLayout);
        return layouts.toArray(new Class[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MyRenderer
    implements Renderer {
        public void paintVertex(Graphics g, Vertex v, int x, int y) {
            g.setColor(Color.black);
            g.fillOval(x - 3, y - 3, 6, 6);
        }

        public void paintEdge(Graphics g, Edge e, int x1, int y1, int x2, int y2) {
            g.setColor(Color.GRAY);
            g.drawLine(x1, y1, x2, y2);
        }

        public void setPickedKey(PickedInfo pk) {
        }
    }

    private static final class LayoutChooser
    implements ActionListener {
        private final JComboBox jcb;
        private final Graph g;
        private final VisualizationViewer vv;

        private LayoutChooser(JComboBox jcb, Graph g, VisualizationViewer vv) {
            this.jcb = jcb;
            this.g = g;
            this.vv = vv;
        }

        public void actionPerformed(ActionEvent arg0) {
            Class layoutC;
            Object[] constructorArgs = new Object[]{this.g};
            Class lay = layoutC = (Class)this.jcb.getSelectedItem();
            try {
                Constructor constructor = lay.getConstructor(constructorArgsWanted);
                Object o = constructor.newInstance(constructorArgs);
                Layout l = (Layout)o;
                this.vv.stop();
                this.vv.setGraphLayout(l);
                this.vv.restart();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

