/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.DefaultToolTipFunction;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.DirectedSparseVertex;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.PersistentLayout;
import edu.uci.ics.jung.visualization.PersistentLayoutImpl;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PersistentLayoutDemo {
    Graph graph;
    String fileName;
    VisualizationViewer vv;

    public PersistentLayoutDemo(final String fileName) {
        this.fileName = fileName;
        this.graph = new DirectedSparseGraph();
        Vertex[] v = this.createVertices(10);
        this.createEdges(v);
        PersistentLayoutImpl layout = new PersistentLayoutImpl(new FRLayout(this.graph));
        PluggableRenderer pr = new PluggableRenderer();
        this.vv = new VisualizationViewer(layout, (Renderer)pr);
        this.vv.setToolTipFunction(new DefaultToolTipFunction());
        this.vv.setPickSupport(new ShapePickSupport());
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(gm);
        JFrame frame = new JFrame();
        frame.getContentPane().add(new GraphZoomScrollPane(this.vv));
        frame.setDefaultCloseOperation(3);
        JPanel p = new JPanel();
        JButton persist = new JButton("Save Layout");
        persist.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PersistentLayout pl = (PersistentLayout)PersistentLayoutDemo.this.vv.getGraphLayout();
                try {
                    pl.persist(fileName);
                }
                catch (IOException e1) {
                    System.err.println("got " + e1);
                }
            }
        });
        p.add(persist);
        JButton restore = new JButton("Restore Layout");
        restore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PersistentLayout pl = (PersistentLayout)PersistentLayoutDemo.this.vv.getGraphLayout();
                try {
                    pl.restore(fileName);
                    PersistentLayoutDemo.this.vv.repaint();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        p.add(restore);
        p.add(gm.getModeComboBox());
        frame.getContentPane().add((Component)p, "South");
        frame.setSize(600, 600);
        frame.show();
    }

    private Vertex[] createVertices(int count) {
        Vertex[] v = new Vertex[count];
        for (int i = 0; i < count; ++i) {
            v[i] = this.graph.addVertex(new DirectedSparseVertex());
        }
        return v;
    }

    void createEdges(Vertex[] v) {
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[1]));
        this.graph.addEdge(new DirectedSparseEdge(v[2], v[3]));
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[4]));
        this.graph.addEdge(new DirectedSparseEdge(v[4], v[5]));
        this.graph.addEdge(new DirectedSparseEdge(v[3], v[9]));
        this.graph.addEdge(new DirectedSparseEdge(v[6], v[2]));
        this.graph.addEdge(new DirectedSparseEdge(v[7], v[1]));
        this.graph.addEdge(new DirectedSparseEdge(v[8], v[2]));
        this.graph.addEdge(new DirectedSparseEdge(v[3], v[8]));
        this.graph.addEdge(new DirectedSparseEdge(v[6], v[7]));
        this.graph.addEdge(new DirectedSparseEdge(v[7], v[5]));
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[9]));
    }

    public static void main(String[] args) {
        String filename = args.length >= 1 ? args[0] : "PersistentLayoutDemo.out";
        new PersistentLayoutDemo(filename);
    }
}

