/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.DefaultToolTipFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.PickableEdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.PickableVertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.utils.TestGraphs;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.MultiPickedState;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AnimatedPickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.PickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.RotatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ShearingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.TranslatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ViewScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MultiViewDemo
extends JApplet {
    Graph graph;
    VisualizationViewer vv1;
    VisualizationViewer vv2;
    VisualizationViewer vv3;
    MutableTransformer transformer;
    Dimension preferredSize = new Dimension(300, 300);
    final String messageOne = "The mouse wheel will scale the model's layout when activated in View 1. Since all three views share the same layout transformer, all three views will show the same scaling of the layout.";
    final String messageTwo = "The mouse wheel will scale the view when activated in View 2. Since all three views share the same view transformer, all three views will be affected.";
    final String messageThree = "   The mouse wheel uses a 'crossover' feature in View 3. When the combined layout and view scale is greater than '1', the model's layout will be scaled. Since all three views share the same layout transformer, all three views will show the same  scaling of the layout.\n   When the combined scale is less than '1', the scaling function crosses over to the view, and then, since all three views share the same view transformer, all three views will show the same scaling.";
    JTextArea textArea;
    JScrollPane scrollPane;

    public MultiViewDemo() {
        this.graph = TestGraphs.getOneComponentGraph();
        PluggableRenderer pr1 = new PluggableRenderer();
        PluggableRenderer pr2 = new PluggableRenderer();
        PluggableRenderer pr3 = new PluggableRenderer();
        FRLayout layout = new FRLayout(this.graph);
        layout.setMaxIterations(1000);
        DefaultVisualizationModel visualizationModel = new DefaultVisualizationModel(layout, this.preferredSize);
        this.vv1 = new VisualizationViewer(visualizationModel, (Renderer)pr1, this.preferredSize);
        this.vv2 = new VisualizationViewer(visualizationModel, (Renderer)pr2, this.preferredSize);
        this.vv3 = new VisualizationViewer(visualizationModel, (Renderer)pr3, this.preferredSize);
        pr1.setEdgeShapeFunction(new EdgeShape.Line());
        pr2.setVertexShapeFunction(new VertexShapeFunction(){

            public Shape getShape(Vertex v) {
                return new Rectangle2D.Float(-6.0f, -6.0f, 12.0f, 12.0f);
            }
        });
        pr2.setEdgeShapeFunction(new EdgeShape.QuadCurve());
        pr3.setVertexPaintFunction(new PickableVertexPaintFunction(pr3, Color.black, Color.decode("0xe6e8fa"), Color.decode("0xcd7f32")));
        pr3.setEdgeShapeFunction(new EdgeShape.CubicCurve());
        this.transformer = this.vv1.getLayoutTransformer();
        this.vv2.setLayoutTransformer(this.transformer);
        this.vv3.setLayoutTransformer(this.transformer);
        this.vv2.setViewTransformer(this.vv1.getViewTransformer());
        this.vv3.setViewTransformer(this.vv1.getViewTransformer());
        this.vv1.setBackground(Color.white);
        this.vv2.setBackground(Color.white);
        this.vv3.setBackground(Color.white);
        ShapePickSupport pickSupport = new ShapePickSupport();
        this.vv1.setPickSupport(pickSupport);
        this.vv2.setPickSupport(pickSupport);
        this.vv3.setPickSupport(pickSupport);
        MultiPickedState ps = new MultiPickedState();
        this.vv1.setPickedState(ps);
        this.vv2.setPickedState(ps);
        this.vv3.setPickedState(ps);
        pr1.setEdgePaintFunction(new PickableEdgePaintFunction(ps, Color.black, Color.red));
        pr2.setEdgePaintFunction(new PickableEdgePaintFunction(ps, Color.black, Color.red));
        pr3.setEdgePaintFunction(new PickableEdgePaintFunction(ps, Color.black, Color.red));
        this.vv1.setToolTipFunction(new DefaultToolTipFunction());
        this.vv2.setToolTipFunction(new DefaultToolTipFunction());
        this.vv3.setToolTipFunction(new DefaultToolTipFunction());
        Container content = this.getContentPane();
        JPanel panel = new JPanel(new GridLayout(1, 0));
        final JPanel p1 = new JPanel(new BorderLayout());
        final JPanel p2 = new JPanel(new BorderLayout());
        final JPanel p3 = new JPanel(new BorderLayout());
        p1.add(new GraphZoomScrollPane(this.vv1));
        p2.add(new GraphZoomScrollPane(this.vv2));
        p3.add(new GraphZoomScrollPane(this.vv3));
        JButton h1 = new JButton("?");
        h1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiViewDemo.this.textArea.setText("The mouse wheel will scale the model's layout when activated in View 1. Since all three views share the same layout transformer, all three views will show the same scaling of the layout.");
                JOptionPane.showMessageDialog(p1, MultiViewDemo.this.scrollPane, "View 1", -1);
            }
        });
        JButton h2 = new JButton("?");
        h2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiViewDemo.this.textArea.setText("The mouse wheel will scale the view when activated in View 2. Since all three views share the same view transformer, all three views will be affected.");
                JOptionPane.showMessageDialog(p2, MultiViewDemo.this.scrollPane, "View 2", -1);
            }
        });
        JButton h3 = new JButton("?");
        h3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiViewDemo.this.textArea.setText("   The mouse wheel uses a 'crossover' feature in View 3. When the combined layout and view scale is greater than '1', the model's layout will be scaled. Since all three views share the same layout transformer, all three views will show the same  scaling of the layout.\n   When the combined scale is less than '1', the scaling function crosses over to the view, and then, since all three views share the same view transformer, all three views will show the same scaling.");
                MultiViewDemo.this.textArea.setCaretPosition(0);
                JOptionPane.showMessageDialog(p3, MultiViewDemo.this.scrollPane, "View 3", -1);
            }
        });
        DefaultModalGraphMouse gm1 = new DefaultModalGraphMouse(){

            protected void loadPlugins() {
                this.pickingPlugin = new PickingGraphMousePlugin();
                this.animatedPickingPlugin = new AnimatedPickingGraphMousePlugin();
                this.translatingPlugin = new TranslatingGraphMousePlugin(16);
                this.scalingPlugin = new ScalingGraphMousePlugin();
                this.rotatingPlugin = new RotatingGraphMousePlugin();
                this.shearingPlugin = new ShearingGraphMousePlugin();
                this.add(this.scalingPlugin);
                this.setTransformingMode();
            }
        };
        DefaultModalGraphMouse gm2 = new DefaultModalGraphMouse(){

            protected void loadPlugins() {
                this.pickingPlugin = new PickingGraphMousePlugin();
                this.animatedPickingPlugin = new AnimatedPickingGraphMousePlugin();
                this.translatingPlugin = new TranslatingGraphMousePlugin(16);
                this.scalingPlugin = new ViewScalingGraphMousePlugin(0);
                this.rotatingPlugin = new RotatingGraphMousePlugin();
                this.shearingPlugin = new ShearingGraphMousePlugin();
                this.add(this.scalingPlugin);
                this.setTransformingMode();
            }
        };
        DefaultModalGraphMouse gm3 = new DefaultModalGraphMouse(){};
        this.vv1.setGraphMouse(gm1);
        this.vv2.setGraphMouse(gm2);
        this.vv3.setGraphMouse(gm3);
        this.vv1.setToolTipText("<html><center>MouseWheel Scales Layout</center></html>");
        this.vv2.setToolTipText("<html><center>MouseWheel Scales View</center></html>");
        this.vv3.setToolTipText("<html><center>MouseWheel Scales Layout and<p>crosses over to view<p>ctrl+MouseWheel scales view</center></html>");
        this.vv1.addPostRenderPaintable(new BannerLabel(this.vv1, "View 1"));
        this.vv2.addPostRenderPaintable(new BannerLabel(this.vv2, "View 2"));
        this.vv3.addPostRenderPaintable(new BannerLabel(this.vv3, "View 3"));
        this.textArea = new JTextArea(6, 30);
        this.scrollPane = new JScrollPane(this.textArea, 20, 31);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEditable(false);
        JPanel flow = new JPanel();
        flow.add(h1);
        flow.add(gm1.getModeComboBox());
        p1.add((Component)flow, "South");
        flow = new JPanel();
        flow.add(h2);
        flow.add(gm2.getModeComboBox());
        p2.add((Component)flow, "South");
        flow = new JPanel();
        flow.add(h3);
        flow.add(gm3.getModeComboBox());
        p3.add((Component)flow, "South");
        panel.add(p1);
        panel.add(p2);
        panel.add(p3);
        content.add(panel);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new MultiViewDemo());
        f.pack();
        f.show();
    }

    class BannerLabel
    implements VisualizationViewer.Paintable {
        int x;
        int y;
        Font font;
        FontMetrics metrics;
        int swidth;
        int sheight;
        String str;
        VisualizationViewer vv;

        public BannerLabel(VisualizationViewer vv, String label) {
            this.vv = vv;
            this.str = label;
        }

        public void paint(Graphics g) {
            Dimension d = this.vv.getSize();
            if (this.font == null) {
                this.font = new Font(g.getFont().getName(), 1, 30);
                this.metrics = g.getFontMetrics(this.font);
                this.swidth = this.metrics.stringWidth(this.str);
                this.sheight = this.metrics.getMaxAscent() + this.metrics.getMaxDescent();
                this.x = (3 * d.width / 2 - this.swidth) / 2;
                this.y = d.height - this.sheight;
            }
            g.setFont(this.font);
            Color oldColor = g.getColor();
            g.setColor(Color.gray);
            g.drawString(this.str, this.x, this.y);
            g.setColor(oldColor);
        }

        public boolean useTransform() {
            return false;
        }
    }
}

