/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.AbstractEdgeShapeFunction;
import edu.uci.ics.jung.graph.decorators.ConstantDirectionalEdgeValue;
import edu.uci.ics.jung.graph.decorators.DefaultToolTipFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.EdgeStringer;
import edu.uci.ics.jung.graph.decorators.PickableEdgePaintFunction;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.visualization.GraphLabelRenderer;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.SpringLayout;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseWheelEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EdgeLabelDemo
extends JApplet {
    Graph graph = new SparseGraph();
    VisualizationViewer vv;
    PluggableRenderer pr;
    GraphLabelRenderer graphLabelRenderer;

    public EdgeLabelDemo() {
        Vertex[] v = this.createVertices(3);
        this.createEdges(v);
        this.pr = new PluggableRenderer();
        SpringLayout layout = new SpringLayout(this.graph);
        this.vv = new VisualizationViewer(layout, (Renderer)this.pr, new Dimension(600, 400));
        this.vv.setPickSupport(new ShapePickSupport());
        this.pr.setEdgeShapeFunction(new EdgeShape.QuadCurve());
        this.vv.setBackground(Color.white);
        this.graphLabelRenderer = this.pr.getGraphLabelRenderer();
        EdgeStringer stringer = new EdgeStringer(){

            public String getLabel(ArchetypeEdge e) {
                return e.toString();
            }
        };
        this.pr.setEdgeStringer(stringer);
        this.pr.setEdgePaintFunction(new PickableEdgePaintFunction(this.pr, Color.black, Color.cyan));
        this.vv.setToolTipFunction(new DefaultToolTipFunction());
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        Container content = this.getContentPane();
        content.add(panel);
        final DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Dimension d = EdgeLabelDemo.this.vv.getSize();
                graphMouse.mouseWheelMoved(new MouseWheelEvent((Component)EdgeLabelDemo.this.vv, 507, System.currentTimeMillis(), 0, d.width / 2, d.height / 2, 1, false, 0, 1, 1));
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Dimension d = EdgeLabelDemo.this.vv.getSize();
                graphMouse.mouseWheelMoved(new MouseWheelEvent((Component)EdgeLabelDemo.this.vv, 507, System.currentTimeMillis(), 0, d.width / 2, d.height / 2, 1, false, 0, 1, -1));
            }
        });
        ButtonGroup radio = new ButtonGroup();
        JRadioButton lineButton = new JRadioButton("Line");
        lineButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EdgeLabelDemo.this.pr.setEdgeShapeFunction(new EdgeShape.Line());
                    EdgeLabelDemo.this.vv.repaint();
                }
            }
        });
        JRadioButton quadButton = new JRadioButton("QuadCurve");
        quadButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EdgeLabelDemo.this.pr.setEdgeShapeFunction(new EdgeShape.QuadCurve());
                    EdgeLabelDemo.this.vv.repaint();
                }
            }
        });
        JRadioButton cubicButton = new JRadioButton("CubicCurve");
        cubicButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    EdgeLabelDemo.this.pr.setEdgeShapeFunction(new EdgeShape.CubicCurve());
                    EdgeLabelDemo.this.vv.repaint();
                }
            }
        });
        radio.add(lineButton);
        radio.add(quadButton);
        radio.add(cubicButton);
        graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        JCheckBox rotate = new JCheckBox("<html><center>Edge<p>Parallel</center></html>");
        rotate.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AbstractButton b = (AbstractButton)e.getSource();
                EdgeLabelDemo.this.graphLabelRenderer.setRotateEdgeLabels(b.isSelected());
                EdgeLabelDemo.this.vv.repaint();
            }
        });
        rotate.setSelected(true);
        MutableDirectionalEdgeValue mv = new MutableDirectionalEdgeValue(0.5, 0.7);
        this.pr.setEdgeLabelClosenessFunction(mv);
        JSlider directedSlider = new JSlider(mv.getDirectedModel()){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width /= 2;
                return d;
            }
        };
        JSlider undirectedSlider = new JSlider(mv.getUndirectedModel()){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width /= 2;
                return d;
            }
        };
        JSlider edgeOffsetSlider = new JSlider(0, 50){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width /= 2;
                return d;
            }
        };
        edgeOffsetSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider s = (JSlider)e.getSource();
                AbstractEdgeShapeFunction aesf = (AbstractEdgeShapeFunction)EdgeLabelDemo.this.pr.getEdgeShapeFunction();
                aesf.setControlOffsetIncrement(s.getValue());
            }
        });
        Box controls = Box.createHorizontalBox();
        JPanel zoomPanel = new JPanel(new GridLayout(0, 1));
        zoomPanel.setBorder(BorderFactory.createTitledBorder("Scale"));
        zoomPanel.add(plus);
        zoomPanel.add(minus);
        JPanel edgePanel = new JPanel(new GridLayout(0, 1));
        edgePanel.setBorder(BorderFactory.createTitledBorder("Edge Type"));
        edgePanel.add(lineButton);
        edgePanel.add(quadButton);
        edgePanel.add(cubicButton);
        JPanel rotatePanel = new JPanel();
        rotatePanel.setBorder(BorderFactory.createTitledBorder("Alignment"));
        rotatePanel.add(rotate);
        JPanel labelPanel = new JPanel(new BorderLayout());
        JPanel sliderPanel = new JPanel(new GridLayout(3, 1));
        JPanel sliderLabelPanel = new JPanel(new GridLayout(3, 1));
        JPanel offsetPanel = new JPanel(new BorderLayout());
        offsetPanel.setBorder(BorderFactory.createTitledBorder("Offset"));
        sliderPanel.add(directedSlider);
        sliderPanel.add(undirectedSlider);
        sliderPanel.add(edgeOffsetSlider);
        sliderLabelPanel.add(new JLabel("Directed", 4));
        sliderLabelPanel.add(new JLabel("Undirected", 4));
        sliderLabelPanel.add(new JLabel("Edge", 4));
        offsetPanel.add((Component)sliderLabelPanel, "West");
        offsetPanel.add(sliderPanel);
        labelPanel.add(offsetPanel);
        labelPanel.add((Component)rotatePanel, "West");
        JPanel modePanel = new JPanel(new GridLayout(2, 1));
        modePanel.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        modePanel.add(graphMouse.getModeComboBox());
        controls.add(zoomPanel);
        controls.add(edgePanel);
        controls.add(labelPanel);
        controls.add(modePanel);
        content.add((Component)controls, "South");
        quadButton.setSelected(true);
    }

    private Vertex[] createVertices(int count) {
        Vertex[] v = new Vertex[count];
        for (int i = 0; i < count; ++i) {
            v[i] = this.graph.addVertex(new SparseVertex());
        }
        return v;
    }

    void createEdges(Vertex[] v) {
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[1]));
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[1]));
        this.graph.addEdge(new DirectedSparseEdge(v[0], v[1]));
        this.graph.addEdge(new DirectedSparseEdge(v[1], v[0]));
        this.graph.addEdge(new DirectedSparseEdge(v[1], v[0]));
        this.graph.addEdge(new UndirectedSparseEdge(v[1], v[2]));
        this.graph.addEdge(new UndirectedSparseEdge(v[1], v[2]));
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        Container content = frame.getContentPane();
        content.add(new EdgeLabelDemo());
        frame.pack();
        frame.show();
    }

    class MutableDirectionalEdgeValue
    extends ConstantDirectionalEdgeValue {
        BoundedRangeModel undirectedModel = new DefaultBoundedRangeModel(5, 0, 0, 10);
        BoundedRangeModel directedModel = new DefaultBoundedRangeModel(7, 0, 0, 10);

        public MutableDirectionalEdgeValue(double undirected, double directed) {
            super(undirected, directed);
            this.undirectedModel.setValue((int)(undirected * 10.0));
            this.directedModel.setValue((int)(directed * 10.0));
            this.undirectedModel.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ MutableDirectionalEdgeValue this$1;
                {
                    this.this$1 = this$1;
                }

                public void stateChanged(ChangeEvent e) {
                    MutableDirectionalEdgeValue.access$002(this.this$1, new Double((float)this.this$1.undirectedModel.getValue() / 10.0f));
                    MutableDirectionalEdgeValue.access$100((MutableDirectionalEdgeValue)this.this$1).vv.repaint();
                }
            });
            this.directedModel.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ MutableDirectionalEdgeValue this$1;
                {
                    this.this$1 = this$1;
                }

                public void stateChanged(ChangeEvent e) {
                    MutableDirectionalEdgeValue.access$202(this.this$1, new Double((float)this.this$1.directedModel.getValue() / 10.0f));
                    MutableDirectionalEdgeValue.access$100((MutableDirectionalEdgeValue)this.this$1).vv.repaint();
                }
            });
        }

        public BoundedRangeModel getDirectedModel() {
            return this.directedModel;
        }

        public BoundedRangeModel getUndirectedModel() {
            return this.undirectedModel;
        }

        static /* synthetic */ Double access$002(MutableDirectionalEdgeValue x0, Double x1) {
            x0.undirected_closeness = x1;
            return x0.undirected_closeness;
        }

        static /* synthetic */ EdgeLabelDemo access$100(MutableDirectionalEdgeValue x0) {
            return x0.EdgeLabelDemo.this;
        }

        static /* synthetic */ Double access$202(MutableDirectionalEdgeValue x0, Double x1) {
            x0.directed_closeness = x1;
            return x0.directed_closeness;
        }
    }
}

