/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform.shape;

import edu.uci.ics.jung.visualization.transform.HyperbolicTransformer;
import edu.uci.ics.jung.visualization.transform.Transformer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization.transform.shape.HyperbolicShapeTransformer;
import edu.uci.ics.jung.visualization.transform.shape.ShapeTransformer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public class TransformingGraphics
extends GraphicsDecorator {
    protected Transformer transformer;

    public TransformingGraphics(Transformer transformer) {
        this(transformer, null);
    }

    public TransformingGraphics(Transformer transformer, Graphics2D delegate) {
        super(delegate);
        this.transformer = transformer;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public void draw(Shape s) {
        Shape shape = ((ShapeTransformer)this.transformer).transform(s);
        this.delegate.draw(shape);
    }

    public void draw(Shape s, float flatness) {
        Shape shape = null;
        shape = this.transformer instanceof HyperbolicTransformer ? ((HyperbolicShapeTransformer)this.transformer).transform(s, flatness) : ((ShapeTransformer)this.transformer).transform(s);
        this.delegate.draw(shape);
    }

    public void fill(Shape s) {
        Shape shape = ((ShapeTransformer)this.transformer).transform(s);
        this.delegate.fill(shape);
    }

    public void fill(Shape s, float flatness) {
        Shape shape = null;
        shape = this.transformer instanceof HyperbolicTransformer ? ((HyperbolicShapeTransformer)this.transformer).transform(s, flatness) : ((ShapeTransformer)this.transformer).transform(s);
        this.delegate.fill(shape);
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        Shape shape = ((ShapeTransformer)this.transformer).transform(s);
        return this.delegate.hit(rect, shape, onStroke);
    }

    public Graphics create() {
        return this.delegate.create();
    }

    public void dispose() {
        this.delegate.dispose();
    }
}

