/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform.shape;

import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.transform.AbstractHyperbolicLensSupport;
import edu.uci.ics.jung.visualization.transform.HyperbolicLensSupport;
import edu.uci.ics.jung.visualization.transform.shape.HyperbolicShapeTransformer;
import edu.uci.ics.jung.visualization.transform.shape.TransformingPluggableRenderer;
import java.awt.Dimension;

public class HyperbolicViewLensSupport
extends AbstractHyperbolicLensSupport
implements HyperbolicLensSupport {
    protected PluggableRenderer pluggableRenderer;
    protected TransformingPluggableRenderer transformingPluggableRenderer;
    protected Renderer renderer;

    public HyperbolicViewLensSupport(VisualizationViewer vv) {
        super(vv);
        this.renderer = vv.getRenderer();
        this.hyperbolicTransformer = new HyperbolicShapeTransformer(vv);
        Dimension d = vv.getSize();
        if (d.width == 0 || d.height == 0) {
            d = vv.getPreferredSize();
        }
        this.hyperbolicTransformer.setViewRadius(d.width / 5);
        this.pluggableRenderer = this.renderer instanceof PluggableRenderer ? (PluggableRenderer)this.renderer : new PluggableRenderer();
    }

    public void activate() {
        this.lens = new AbstractHyperbolicLensSupport.Lens(this.hyperbolicTransformer);
        this.vv.setViewTransformer(this.hyperbolicTransformer);
        if (this.transformingPluggableRenderer == null) {
            this.transformingPluggableRenderer = new TransformingPluggableRenderer(this.pluggableRenderer);
        }
        this.transformingPluggableRenderer.setTransformer(this.hyperbolicTransformer);
        this.vv.setRenderer(this.transformingPluggableRenderer);
        this.vv.addPreRenderPaintable(this.lens);
        this.vv.setGraphMouse(this.hyperbolicGraphMouse);
        this.vv.setToolTipText("<html><center>Mouse-Drag the Lens center to move it<p>Mouse-Drag the Lens edge to resize it<p>Ctrl+MouseWheel to change magnification</center></html>");
        this.vv.repaint();
    }

    public void deactivate() {
        this.vv.setViewTransformer(this.savedViewTransformer);
        this.vv.removePreRenderPaintable(this.lens);
        this.vv.setRenderer(this.renderer);
        this.vv.setToolTipText(this.defaultToolTipText);
        this.vv.setGraphMouse(this.graphMouse);
        this.vv.repaint();
    }
}

