/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;

public class ViewScalingGraphMousePlugin
extends ScalingGraphMousePlugin {
    public ViewScalingGraphMousePlugin() {
        this(2, 1.1f, 0.9f);
    }

    public ViewScalingGraphMousePlugin(int modifiers) {
        this(modifiers, 1.1f, 0.9f);
    }

    public ViewScalingGraphMousePlugin(float in, float out) {
        this(2, in, out);
    }

    public ViewScalingGraphMousePlugin(int modifiers, float in, float out) {
        super(modifiers);
        this.in = in;
        this.out = out;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            Point mouse = e.getPoint();
            Point2D center = vv.getCenter();
            MutableTransformer viewTransformer = vv.getViewTransformer();
            int amount = e.getWheelRotation();
            if (this.zoomAtMouse) {
                if (amount > 0) {
                    viewTransformer.scale(this.in, this.in, mouse);
                } else if (amount < 0) {
                    viewTransformer.scale(this.out, this.out, mouse);
                }
            } else if (amount > 0) {
                viewTransformer.scale(this.in, this.in, center);
            } else if (amount < 0) {
                viewTransformer.scale(this.out, this.out, center);
            }
            e.consume();
            vv.repaint();
        }
    }
}

