/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;

public class TranslatingGraphMousePlugin
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    public TranslatingGraphMousePlugin() {
        this(16);
    }

    public TranslatingGraphMousePlugin(int modifiers) {
        super(modifiers);
        this.cursor = Cursor.getPredefinedCursor(13);
    }

    public void mousePressed(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        this.down = e.getPoint();
        if (accepted) {
            vv.setCursor(this.cursor);
        }
    }

    public void mouseReleased(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        this.down = null;
        vv.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void mouseDragged(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            MutableTransformer modelTransformer = vv.getLayoutTransformer();
            vv.setCursor(this.cursor);
            try {
                Point2D q = modelTransformer.inverseTransform(this.down);
                Point2D p = modelTransformer.inverseTransform(e.getPoint());
                float dx = (float)(p.getX() - q.getX());
                float dy = (float)(p.getY() - q.getY());
                modelTransformer.translate(dx, dy);
                this.down.x = e.getX();
                this.down.y = e.getY();
            }
            catch (RuntimeException ex) {
                System.err.println("down = " + this.down + ", e = " + e);
                throw ex;
            }
        }
        if (accepted) {
            e.consume();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }
}

