/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;

public class ScalingGraphMousePlugin
extends AbstractGraphMousePlugin
implements MouseWheelListener {
    protected float in = 1.1f;
    protected float out = 0.9f;
    protected boolean zoomAtMouse = true;

    public ScalingGraphMousePlugin() {
        this(0, 1.1f, 0.9f);
    }

    public ScalingGraphMousePlugin(int modifiers) {
        this(modifiers, 1.1f, 0.9f);
    }

    public ScalingGraphMousePlugin(float in, float out) {
        this(0, in, out);
    }

    public ScalingGraphMousePlugin(int modifiers, float in, float out) {
        super(modifiers);
        this.in = in;
        this.out = out;
    }

    public void setZoomAtMouse(boolean zoomAtMouse) {
        this.zoomAtMouse = zoomAtMouse;
    }

    public boolean checkModifiers(MouseEvent e) {
        return e.getModifiers() == this.modifiers || (e.getModifiers() & this.modifiers) != 0;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            Point mouse = e.getPoint();
            Point2D center = vv.getCenter();
            Point2D ivtmouse = vv.inverseViewTransform(mouse);
            Point2D ivtcenter = vv.inverseViewTransform(center);
            MutableTransformer modelTransformer = vv.getLayoutTransformer();
            int amount = e.getWheelRotation();
            if (this.zoomAtMouse) {
                if (amount > 0) {
                    modelTransformer.scale(this.in, this.in, ivtmouse);
                } else if (amount < 0) {
                    modelTransformer.scale(this.out, this.out, ivtmouse);
                }
            } else if (amount > 0) {
                modelTransformer.scale(this.in, this.in, ivtcenter);
            } else if (amount < 0) {
                modelTransformer.scale(this.out, this.out, ivtcenter);
            }
            e.consume();
            vv.repaint();
        }
    }

    public float getIn() {
        return this.in;
    }

    public void setIn(float in) {
        this.in = in;
    }

    public float getOut() {
        return this.out;
    }

    public void setOut(float out) {
        this.out = out;
    }
}

