/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.SatelliteVisualizationViewer;
import edu.uci.ics.jung.visualization.control.TranslatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class SatelliteTranslatingGraphMousePlugin
extends TranslatingGraphMousePlugin {
    public SatelliteTranslatingGraphMousePlugin() {
    }

    public SatelliteTranslatingGraphMousePlugin(int modifiers) {
        super(modifiers);
    }

    public void mouseDragged(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            if (vv instanceof SatelliteVisualizationViewer) {
                VisualizationViewer vvMaster = ((SatelliteVisualizationViewer)vv).getMaster();
                MutableTransformer modelTransformerMaster = vvMaster.getLayoutTransformer();
                vv.setCursor(Cursor.getPredefinedCursor(13));
                try {
                    Point2D q = vv.inverseTransform(this.down);
                    Point2D p = vv.inverseTransform(e.getPoint());
                    float dx = (float)(p.getX() - q.getX());
                    float dy = (float)(p.getY() - q.getY());
                    modelTransformerMaster.translate(-dx, -dy);
                    this.down.x = e.getX();
                    this.down.y = e.getY();
                }
                catch (RuntimeException ex) {
                    System.err.println("down = " + this.down + ", e = " + e);
                    throw ex;
                }
            }
            if (accepted) {
                e.consume();
            }
        }
    }
}

