/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.SatelliteVisualizationViewer;
import edu.uci.ics.jung.visualization.control.ShearingGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class SatelliteShearingGraphMousePlugin
extends ShearingGraphMousePlugin {
    public SatelliteShearingGraphMousePlugin() {
    }

    public SatelliteShearingGraphMousePlugin(int modifiers) {
        super(modifiers);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.down == null) {
            return;
        }
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            if (vv instanceof SatelliteVisualizationViewer) {
                VisualizationViewer vvMaster = ((SatelliteVisualizationViewer)vv).getMaster();
                MutableTransformer modelTransformerMaster = vvMaster.getLayoutTransformer();
                vv.setCursor(this.cursor);
                Point q = this.down;
                Point p = e.getPoint();
                float dx = (float)(((Point2D)p).getX() - ((Point2D)q).getX());
                float dy = (float)(((Point2D)p).getY() - ((Point2D)q).getY());
                Dimension d = vv.getSize();
                float shx = 2.0f * dx / (float)d.height;
                float shy = 2.0f * dy / (float)d.width;
                Point2D center = vv.getCenter();
                if (((Point2D)p).getX() < center.getX()) {
                    shy = -shy;
                }
                if (((Point2D)p).getY() < center.getY()) {
                    shx = -shx;
                }
                modelTransformerMaster.shear(-shx, -shy, vvMaster.getCenter());
                this.down.x = e.getX();
                this.down.y = e.getY();
            }
            if (accepted) {
                e.consume();
            }
        }
    }
}

