/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.SatelliteVisualizationViewer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;

public class SatelliteCrossoverScalingGraphMousePlugin
extends CrossoverScalingGraphMousePlugin {
    public SatelliteCrossoverScalingGraphMousePlugin() {
    }

    public SatelliteCrossoverScalingGraphMousePlugin(float in, float out) {
        super(in, out);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        if (vv instanceof SatelliteVisualizationViewer) {
            VisualizationViewer vvMaster = ((SatelliteVisualizationViewer)vv).getMaster();
            MutableTransformer viewTransformerMaster = vvMaster.getViewTransformer();
            MutableTransformer modelTransformerMaster = vvMaster.getLayoutTransformer();
            int amount = e.getWheelRotation();
            double scale = vv.getLayoutTransformer().getScale() * vv.getViewTransformer().getScale();
            Point2D center = vvMaster.getCenter();
            Point2D ivtcenter = vv.inverseViewTransform(center);
            if (amount > 0) {
                if (scale * (double)this.in < this.crossover || scale * (double)this.in < this.crossover) {
                    viewTransformerMaster.scale(this.in, this.in, center);
                } else {
                    modelTransformerMaster.scale(this.in, this.in, ivtcenter);
                }
            } else if (amount < 0) {
                if (scale * (double)this.out < this.crossover || scale * (double)this.out < this.crossover) {
                    viewTransformerMaster.scale(this.out, this.out, center);
                } else {
                    modelTransformerMaster.scale(this.out, this.out, ivtcenter);
                }
            }
            e.consume();
            vv.repaint();
        }
    }
}

