/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.control.AnimatedPickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.CrossoverScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.PickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.PluggableGraphMouse;
import edu.uci.ics.jung.visualization.control.RotatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ShearingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.TranslatingGraphMousePlugin;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicIconFactory;

public class DefaultModalGraphMouse
extends PluggableGraphMouse
implements ModalGraphMouse,
ItemSelectable {
    protected float in;
    protected float out;
    protected ItemListener modeListener;
    protected JComboBox modeBox;
    protected JMenu modeMenu;
    protected ModalGraphMouse.Mode mode;
    protected EventListenerList listenerList = new EventListenerList();
    private static int scalingMask = 1;
    protected PickingGraphMousePlugin pickingPlugin;
    protected TranslatingGraphMousePlugin translatingPlugin;
    protected AnimatedPickingGraphMousePlugin animatedPickingPlugin;
    protected ScalingGraphMousePlugin scalingPlugin;
    protected RotatingGraphMousePlugin rotatingPlugin;
    protected ShearingGraphMousePlugin shearingPlugin;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public DefaultModalGraphMouse() {
        this(1.1f, 0.9f);
    }

    public DefaultModalGraphMouse(float in, float out) {
        this.in = in;
        this.out = out;
        this.loadPlugins();
    }

    protected void loadPlugins() {
        this.pickingPlugin = new PickingGraphMousePlugin();
        this.animatedPickingPlugin = new AnimatedPickingGraphMousePlugin();
        this.translatingPlugin = new TranslatingGraphMousePlugin(16);
        this.scalingPlugin = new CrossoverScalingGraphMousePlugin(this.in, this.out);
        this.rotatingPlugin = new RotatingGraphMousePlugin();
        this.shearingPlugin = new ShearingGraphMousePlugin();
        this.add(this.scalingPlugin);
        this.setTransformingMode();
    }

    public void setMode(ModalGraphMouse.Mode mode) {
        if (this.mode != mode) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.mode, 2));
            this.mode = mode;
            if (mode == ModalGraphMouse.Mode.TRANSFORMING) {
                this.setTransformingMode();
            } else if (mode == ModalGraphMouse.Mode.PICKING) {
                this.setPickingMode();
            }
            if (this.modeBox != null) {
                this.modeBox.setSelectedItem(mode);
            }
            this.fireItemStateChanged(new ItemEvent(this, 701, mode, 1));
        }
    }

    protected void setPickingMode() {
        this.remove(this.translatingPlugin);
        this.remove(this.rotatingPlugin);
        this.remove(this.shearingPlugin);
        this.add(this.pickingPlugin);
        this.add(this.animatedPickingPlugin);
    }

    protected void setTransformingMode() {
        this.remove(this.pickingPlugin);
        this.remove(this.animatedPickingPlugin);
        this.add(this.translatingPlugin);
        this.add(this.rotatingPlugin);
        this.add(this.shearingPlugin);
    }

    public void setZoomAtMouse(boolean zoomAtMouse) {
        this.scalingPlugin.setZoomAtMouse(zoomAtMouse);
    }

    public ItemListener getModeListener() {
        if (this.modeListener == null) {
            this.modeListener = new ModeListener();
        }
        return this.modeListener;
    }

    public JComboBox getModeComboBox() {
        if (this.modeBox == null) {
            this.modeBox = new JComboBox<ModalGraphMouse.Mode>(new ModalGraphMouse.Mode[]{ModalGraphMouse.Mode.TRANSFORMING, ModalGraphMouse.Mode.PICKING});
            this.modeBox.addItemListener(this.getModeListener());
        }
        return this.modeBox;
    }

    public JMenu getModeMenu() {
        if (this.modeMenu == null) {
            this.modeMenu = new JMenu();
            Icon icon = BasicIconFactory.getMenuArrowIcon();
            this.modeMenu.setIcon(BasicIconFactory.getMenuArrowIcon());
            this.modeMenu.setPreferredSize(new Dimension(icon.getIconWidth() + 10, icon.getIconHeight() + 10));
            final JRadioButtonMenuItem transformingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.TRANSFORMING.toString());
            transformingButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DefaultModalGraphMouse.this.setMode(ModalGraphMouse.Mode.TRANSFORMING);
                    }
                }
            });
            final JRadioButtonMenuItem pickingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.PICKING.toString());
            pickingButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        DefaultModalGraphMouse.this.setMode(ModalGraphMouse.Mode.PICKING);
                    }
                }
            });
            ButtonGroup radio = new ButtonGroup();
            radio.add(transformingButton);
            radio.add(pickingButton);
            transformingButton.setSelected(true);
            this.modeMenu.add(transformingButton);
            this.modeMenu.add(pickingButton);
            this.modeMenu.setToolTipText("Menu for setting Mouse Mode");
            this.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        if (e.getItem() == ModalGraphMouse.Mode.TRANSFORMING) {
                            transformingButton.setSelected(true);
                        } else if (e.getItem() == ModalGraphMouse.Mode.PICKING) {
                            pickingButton.setSelected(true);
                        }
                    }
                }
            });
        }
        return this.modeMenu;
    }

    public void addItemListener(ItemListener aListener) {
        this.listenerList.add(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = DefaultModalGraphMouse.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, aListener);
    }

    public void removeItemListener(ItemListener aListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = DefaultModalGraphMouse.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, aListener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = DefaultModalGraphMouse.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener);
    }

    public Object[] getSelectedObjects() {
        if (this.mode == null) {
            return new Object[0];
        }
        Object[] result = new Object[]{this.mode};
        return result;
    }

    protected void fireItemStateChanged(ItemEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$ItemListener == null ? DefaultModalGraphMouse.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener)) continue;
            ((ItemListener)listeners[i + 1]).itemStateChanged(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (System.getProperty("os.name").startsWith("Mac")) {
            scalingMask = 4;
        }
    }

    class ModeListener
    implements ItemListener {
        ModeListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            DefaultModalGraphMouse.this.setMode((ModalGraphMouse.Mode)e.getItem());
        }
    }
}

