/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;

public class CrossoverScalingGraphMousePlugin
extends ScalingGraphMousePlugin {
    protected double crossover = 1.0;

    public CrossoverScalingGraphMousePlugin() {
        this(1.1f, 0.9f);
    }

    public CrossoverScalingGraphMousePlugin(float in, float out) {
        super(0);
        this.in = in;
        this.out = out;
    }

    public void setCrossover(double crossover) {
        this.crossover = crossover;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        int amount = e.getWheelRotation();
        MutableTransformer modelTransformer = vv.getLayoutTransformer();
        MutableTransformer viewTransformer = vv.getViewTransformer();
        double modelScale = modelTransformer.getScale();
        double viewScale = viewTransformer.getScale();
        double inverseModelScale = Math.sqrt(this.crossover) / modelScale;
        double inverseViewScale = Math.sqrt(this.crossover) / viewScale;
        double scale = modelScale * viewScale;
        Point mouse = e.getPoint();
        Point2D center = vv.getCenter();
        Point2D ivtmouse = vv.inverseViewTransform(mouse);
        Point2D ivtcenter = vv.inverseViewTransform(center);
        if (this.zoomAtMouse) {
            if (amount > 0) {
                if (scale * (double)this.in < this.crossover) {
                    viewTransformer.scale(this.in, this.in, mouse);
                    modelTransformer.scale(inverseModelScale, inverseModelScale, ivtmouse);
                } else {
                    modelTransformer.scale(this.in, this.in, ivtmouse);
                    viewTransformer.scale(inverseViewScale, inverseViewScale, mouse);
                }
            } else if (amount < 0) {
                if (scale * (double)this.out < this.crossover) {
                    viewTransformer.scale(this.out, this.out, mouse);
                    modelTransformer.scale(inverseModelScale, inverseModelScale, ivtmouse);
                } else {
                    modelTransformer.scale(this.out, this.out, ivtmouse);
                    viewTransformer.scale(inverseViewScale, inverseViewScale, mouse);
                }
            }
        } else if (amount > 0) {
            if (scale * (double)this.in < this.crossover) {
                viewTransformer.scale(this.in, this.in, center);
                modelTransformer.scale(inverseModelScale, inverseModelScale, ivtcenter);
            } else {
                modelTransformer.scale(this.in, this.in, ivtcenter);
                viewTransformer.scale(inverseViewScale, inverseViewScale, center);
            }
        } else if (amount < 0) {
            if (scale * (double)this.out < this.crossover) {
                viewTransformer.scale(this.out, this.out, center);
                modelTransformer.scale(inverseModelScale, inverseModelScale, ivtcenter);
            } else {
                modelTransformer.scale(this.out, this.out, ivtcenter);
                viewTransformer.scale(inverseViewScale, inverseViewScale, center);
            }
        }
        e.consume();
        vv.repaint();
    }
}

