/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.PickedState;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class AnimatedPickingGraphMousePlugin
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    protected Vertex vertex;

    public AnimatedPickingGraphMousePlugin() {
        this(18);
    }

    public AnimatedPickingGraphMousePlugin(int selectionModifiers) {
        super(selectionModifiers);
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    public void mousePressed(MouseEvent e) {
        if (e.getModifiers() == this.modifiers) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            PickSupport pickSupport = vv.getPickSupport();
            PickedState pickedState = vv.getPickedState();
            if (pickSupport != null && pickedState != null) {
                Point p = e.getPoint();
                Point2D ip = vv.inverseViewTransform(p);
                this.vertex = pickSupport.getVertex(ip.getX(), ip.getY());
                if (this.vertex != null && !pickedState.isPicked(this.vertex)) {
                    pickedState.clearPickedVertices();
                    pickedState.pick(this.vertex, true);
                }
            }
        }
        e.consume();
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getModifiers() == this.modifiers) {
            final VisualizationViewer vv = (VisualizationViewer)e.getSource();
            if (this.vertex != null) {
                Layout layout = vv.getGraphLayout();
                Point2D q = layout.getLocation(this.vertex);
                Point2D lvc = vv.inverseLayoutTransform(vv.getCenter());
                final double dx = (lvc.getX() - q.getX()) / 10.0;
                final double dy = (lvc.getY() - q.getY()) / 10.0;
                Runnable animator = new Runnable(){

                    public void run() {
                        for (int i = 0; i < 10; ++i) {
                            vv.getLayoutTransformer().translate(dx, dy);
                            try {
                                Thread.sleep(100L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                };
                Thread thread = new Thread(animator);
                thread.start();
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(this.cursor);
    }

    public void mouseExited(MouseEvent e) {
        JComponent c = (JComponent)e.getSource();
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent arg0) {
    }
}

