/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.contrib;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.SparseTree;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import edu.uci.ics.jung.visualization.Layout;
import java.awt.Dimension;
import java.awt.Point;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class TreeLayout
extends AbstractLayout
implements Layout {
    private static final String C_DIMENSION_X_BASE_KEY = "DimsionX";
    public static int DEFAULT_DISTX = 50;
    public static int DEFAULT_DISTY = 50;
    private transient Set allreadyDone = new HashSet();
    private int distX = DEFAULT_DISTX;
    private int distY = DEFAULT_DISTY;
    private transient Point m_currentPoint = new Point();
    private transient Vertex m_currentVertex;
    private Pair m_dimensionKey;
    private Vertex m_rootVertex;

    public static Vector getAtomics(Vertex p) {
        Vector v = new Vector();
        TreeLayout.getAtomics(p, v);
        return v;
    }

    private static void getAtomics(Vertex p, Vector v) {
        Iterator i = p.getSuccessors().iterator();
        while (i.hasNext()) {
            Vertex c = (Vertex)i.next();
            if (c.getSuccessors().isEmpty()) {
                v.add(c);
                continue;
            }
            TreeLayout.getAtomics(c, v);
        }
    }

    public TreeLayout(SparseTree g) {
        super(g);
        this.m_rootVertex = g.getRoot();
    }

    public TreeLayout(SparseTree g, int distx) {
        super(g);
        this.m_rootVertex = g.getRoot();
        this.distX = distx;
    }

    public TreeLayout(SparseTree g, int distx, int disty) {
        super(g);
        this.m_rootVertex = g.getRoot();
        this.distX = distx;
        this.distY = disty;
    }

    public void advancePositions() {
    }

    public void applyFilter(Graph g) {
        super.applyFilter(g);
    }

    void buildTree() {
        this.m_currentPoint = new Point(this.getCurrentSize().width / 2, 20);
        if (this.m_rootVertex != null && this.getGraph() != null) {
            this.calculateDimensionX(this.m_rootVertex);
            this.buildTree(this.m_rootVertex, this.m_currentPoint.x);
        }
    }

    void buildTree(Vertex v, int x) {
        if (!this.allreadyDone.contains(v)) {
            this.allreadyDone.add(v);
            this.m_currentPoint.y += this.distY;
            this.m_currentPoint.x = x;
            this.setCurrentPositionFor(v);
            int sizeXofCurrent = (Integer)v.getUserDatum(this.getDimensionBaseKey());
            int lastX = x - sizeXofCurrent / 2;
            Iterator j = v.getSuccessors().iterator();
            while (j.hasNext()) {
                Vertex element = (Vertex)j.next();
                int sizeXofChild = (Integer)element.getUserDatum(this.getDimensionBaseKey());
                int startXofChild = lastX + sizeXofChild / 2;
                this.buildTree(element, startXofChild);
                lastX = lastX + sizeXofChild + this.distX;
            }
            this.m_currentPoint.y -= this.distY;
        }
    }

    private int calculateDimensionX(Vertex v) {
        int size = 0;
        int childrenNum = v.getSuccessors().size();
        if (childrenNum != 0) {
            Iterator iter = v.getSuccessors().iterator();
            while (iter.hasNext()) {
                Vertex element = (Vertex)iter.next();
                size += this.calculateDimensionX(element) + this.distX;
            }
        }
        size = Math.max(0, size - this.distX);
        v.setUserDatum(this.getDimensionBaseKey(), new Integer(size), UserData.REMOVE);
        return size;
    }

    public int getDepth(Vertex v) {
        int depth = 0;
        Iterator i = v.getSuccessors().iterator();
        while (i.hasNext()) {
            Vertex c = (Vertex)i.next();
            if (c.getSuccessors().isEmpty()) {
                depth = 0;
                continue;
            }
            depth = Math.max(depth, this.getDepth(c));
        }
        return depth + 1;
    }

    private Object getDimensionBaseKey() {
        if (this.m_dimensionKey == null) {
            this.m_dimensionKey = new Pair(this, C_DIMENSION_X_BASE_KEY);
        }
        return this.m_dimensionKey;
    }

    public Vertex getRootVertex() {
        return this.m_rootVertex;
    }

    public boolean incrementsAreDone() {
        return true;
    }

    public void initialize(Dimension size) {
        super.initialize(size);
        this.buildTree();
    }

    protected void initialize_local() {
    }

    protected void initialize_local_vertex(Vertex v) {
    }

    protected void initializeLocations() {
        Iterator iter = this.getGraph().getVertices().iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            Coordinates coord = (Coordinates)v.getUserDatum(this.getBaseKey());
            if (coord == null) {
                coord = new Coordinates();
                v.addUserDatum(this.getBaseKey(), coord, UserData.REMOVE);
            }
            this.initialize_local_vertex(v);
        }
    }

    public boolean isIncremental() {
        return false;
    }

    private void setCurrentPositionFor(Vertex vertex) {
        Coordinates coord = this.getCoordinates(vertex);
        coord.setX(this.m_currentPoint.x);
        coord.setY(this.m_currentPoint.y);
    }

    public void setRootVertex(Vertex rootVertex_) {
        this.m_rootVertex = rootVertex_;
        this.m_currentVertex = rootVertex_;
    }
}

