/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.contrib;

import edu.uci.ics.jung.algorithms.shortestpath.UnweightedShortestPath;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.awt.Dimension;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class KKLayoutInt
extends AbstractLayout {
    private float EPSILON = 0.1f;
    private int currentIteration;
    private int maxIterations = 2000;
    private String status = "KKLayoutInt";
    private int L;
    private static final double K = 10000.0;
    private int[] dm;
    private boolean adjustForGravity = true;
    private boolean exchangeVertices = true;
    private Vertex[] vertices;
    private Coordinates[] xydata;
    protected UnweightedShortestPath unweightedShortestPaths;
    protected int diameter;

    public KKLayoutInt(Graph g) {
        super(g);
    }

    public String getStatus() {
        return this.status + this.getCurrentSize();
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean incrementsAreDone() {
        return this.currentIteration > this.maxIterations;
    }

    protected void initialize_local() {
    }

    protected void initializeLocations() {
        super.initializeLocations();
        Dimension d = this.getCurrentSize();
        int height = d.height;
        int width = d.width;
        int n = this.getVisibleVertices().size();
        this.dm = new int[n * n];
        this.vertices = new Vertex[n];
        this.xydata = new Coordinates[n];
        this.unweightedShortestPaths = new UnweightedShortestPath(this.getVisibleGraph());
        while (true) {
            try {
                int index = 0;
                Iterator iter = this.getVisibleVertices().iterator();
                while (iter.hasNext()) {
                    Vertex v = (Vertex)iter.next();
                    Coordinates xyd = this.getCoordinates(v);
                    this.vertices[index] = v;
                    this.xydata[index] = xyd;
                    ++index;
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
        this.diameter = 0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                int dist = this.unweightedShortestPaths.getDistance(this.vertices[i], this.vertices[j]).intValue();
                if (dist <= this.diameter) continue;
                this.diameter = dist;
            }
        }
        int L0 = height > width ? width : height;
        this.L = L0 / this.diameter;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                int dist;
                this.dm[i * n + j] = dist = this.getDistance(this.vertices[i], this.vertices[j]);
                this.dm[j * n + i] = dist;
            }
        }
    }

    protected int getDistance(Vertex v1, Vertex v2) {
        int dist = this.unweightedShortestPaths.getDistance(v1, v2).intValue();
        if (dist < 0) {
            return this.diameter + 1;
        }
        return dist;
    }

    protected void initialize_local_vertex(Vertex v) {
    }

    public void advancePositions() {
        int i;
        ++this.currentIteration;
        double energy = this.calcEnergy();
        this.status = "Kamada-Kawai V=" + this.getVisibleVertices().size() + "(" + this.getGraph().numVertices() + ")" + " IT: " + this.currentIteration + " E=" + energy;
        int n = this.getVisibleGraph().numVertices();
        if (n == 0) {
            return;
        }
        double maxDeltaM = 0.0;
        int pm = -1;
        for (i = 0; i < n; ++i) {
            double deltam;
            if (this.dontMove(this.vertices[i]) || !(maxDeltaM < (deltam = this.calcDeltaM(i)))) continue;
            maxDeltaM = deltam;
            pm = i;
        }
        if (pm == -1) {
            return;
        }
        for (i = 0; i < 100; ++i) {
            double[] dxy = this.calcDeltaXY(pm);
            this.xydata[pm].add(dxy[0], dxy[1]);
            double deltam = this.calcDeltaM(pm);
            if (deltam < (double)this.EPSILON) break;
        }
        if (this.adjustForGravity) {
            this.adjustForGravity();
        }
        if (this.exchangeVertices && maxDeltaM < (double)this.EPSILON) {
            energy = this.calcEnergy();
            for (i = 0; i < n - 1; ++i) {
                if (this.dontMove(this.vertices[i])) continue;
                for (int j = i + 1; j < n; ++j) {
                    double xenergy;
                    if (this.dontMove(this.vertices[j]) || !(energy > (xenergy = this.calcEnergyIfExchanged(i, j)))) continue;
                    double sx = this.xydata[i].getX();
                    double sy = this.xydata[i].getY();
                    this.xydata[i].setX(this.xydata[j].getX());
                    this.xydata[i].setY(this.xydata[j].getY());
                    this.xydata[j].setX(sx);
                    this.xydata[j].setY(sy);
                    return;
                }
            }
        }
    }

    public void adjustForGravity() {
        Dimension d = this.getCurrentSize();
        double height = d.getHeight();
        double width = d.getWidth();
        double gx = 0.0;
        double gy = 0.0;
        for (int i = 0; i < this.xydata.length; ++i) {
            gx += this.xydata[i].getX();
            gy += this.xydata[i].getY();
        }
        double diffx = width / 2.0 - (gx /= (double)this.xydata.length);
        double diffy = height / 2.0 - (gy /= (double)this.xydata.length);
        for (int i = 0; i < this.xydata.length; ++i) {
            this.xydata[i].add(diffx, diffy);
        }
    }

    public void setAdjustForGravity(boolean on) {
        this.adjustForGravity = on;
    }

    public boolean getAdjustForGravity() {
        return this.adjustForGravity;
    }

    public void setExchangeVertices(boolean on) {
        this.exchangeVertices = on;
    }

    public boolean getExchangeVertices() {
        return this.exchangeVertices;
    }

    private double[] calcDeltaXY(int m) {
        double dE_dxm = 0.0;
        double dE_dym = 0.0;
        double d2E_d2xm = 0.0;
        double d2E_dxmdym = 0.0;
        double d2E_dymdxm = 0.0;
        double d2E_d2ym = 0.0;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (i == m) continue;
            int dist = this.dm[m * this.vertices.length + i];
            int l_mi = this.L * dist;
            double k_mi = 10000.0 / (double)(dist * dist);
            double dx = this.xydata[m].getX() - this.xydata[i].getX();
            double dy = this.xydata[m].getY() - this.xydata[i].getY();
            double d = Math.sqrt(dx * dx + dy * dy);
            double ddd = d * d * d;
            dE_dxm += k_mi * (1.0 - (double)l_mi / d) * dx;
            dE_dym += k_mi * (1.0 - (double)l_mi / d) * dy;
            d2E_d2xm += k_mi * (1.0 - (double)l_mi * dy * dy / ddd);
            d2E_dxmdym += k_mi * (double)l_mi * dx * dy / ddd;
            d2E_d2ym += k_mi * (1.0 - (double)l_mi * dx * dx / ddd);
        }
        d2E_dymdxm = d2E_dxmdym;
        double denomi = d2E_d2xm * d2E_d2ym - d2E_dxmdym * d2E_dymdxm;
        double deltaX = (d2E_dxmdym * dE_dym - d2E_d2ym * dE_dxm) / denomi;
        double deltaY = (d2E_dymdxm * dE_dxm - d2E_d2xm * dE_dym) / denomi;
        return new double[]{deltaX, deltaY};
    }

    private double calcDeltaM(int m) {
        double dEdxm = 0.0;
        double dEdym = 0.0;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (i == m) continue;
            double dist = this.dm[m * this.vertices.length + i];
            double l_mi = (double)this.L * dist;
            double k_mi = 10000.0 / (dist * dist);
            double dx = this.xydata[m].getX() - this.xydata[i].getX();
            double dy = this.xydata[m].getY() - this.xydata[i].getY();
            double d = Math.sqrt(dx * dx + dy * dy);
            double common = k_mi * (1.0 - l_mi / d);
            dEdxm += common * dx;
            dEdym += common * dy;
        }
        return Math.sqrt(dEdxm * dEdxm + dEdym * dEdym);
    }

    private double calcEnergy() {
        double energy = 0.0;
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            for (int j = i + 1; j < this.vertices.length; ++j) {
                double dist = this.dm[i * this.vertices.length + i];
                double l_ij = (double)this.L * dist;
                double k_ij = 10000.0 / (dist * dist);
                double dx = this.xydata[i].getX() - this.xydata[j].getX();
                double dy = this.xydata[i].getY() - this.xydata[j].getY();
                double d = Math.sqrt(dx * dx + dy * dy);
                energy += k_ij / 2.0 * (dx * dx + dy * dy + l_ij * l_ij - 2.0 * l_ij * d);
            }
        }
        return energy;
    }

    private double calcEnergyIfExchanged(int p, int q) {
        if (p >= q) {
            throw new RuntimeException("p should be < q");
        }
        double energy = 0.0;
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            for (int j = i + 1; j < this.vertices.length; ++j) {
                int ii = i;
                int jj = j;
                if (i == p) {
                    ii = q;
                }
                if (j == q) {
                    jj = p;
                }
                double dist = this.dm[j * this.vertices.length + i];
                double l_ij = (double)this.L * dist;
                double k_ij = 10000.0 / (dist * dist);
                double dx = this.xydata[ii].getX() - this.xydata[jj].getX();
                double dy = this.xydata[ii].getY() - this.xydata[jj].getY();
                double d = Math.sqrt(dx * dx + dy * dy);
                energy += k_ij / 2.0 * (dx * dx + dy * dy + l_ij * l_ij - 2.0 * l_ij * d);
            }
        }
        return energy;
    }
}

