/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.contrib;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.Coordinates;
import edu.uci.ics.jung.visualization.SpringLayout;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.Set;

public class DAGLayout
extends SpringLayout {
    protected static final String MINIMUMLEVELKEY = "DAGLayout.minimumLevel";
    static int graphHeight;
    static int numRoots;
    final double SPACEFACTOR = 1.3;
    final double LEVELATTRACTIONRATE = 0.8;
    final double MSV_THRESHOLD = 10.0;
    static double meanSquareVel;
    static boolean stoppingIncrements;
    static int incrementsLeft;
    final int COOL_DOWN_INCREMENTS = 200;

    public DAGLayout(Graph g) {
        super(g);
    }

    public static void setRoot(Graph g) {
        numRoots = 0;
        Set verts = g.getVertices();
        Iterator iter = verts.iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            Set successors = v.getSuccessors();
            if (successors.size() != 0) continue;
            DAGLayout.setRoot(v);
            ++numRoots;
        }
    }

    public static void setRoot(Vertex v) {
        v.setUserDatum(MINIMUMLEVELKEY, new Integer(0), UserData.REMOVE);
        DAGLayout.propagateMinimumLevel(v);
    }

    public static void propagateMinimumLevel(Vertex v) {
        int level = (Integer)v.getUserDatum(MINIMUMLEVELKEY);
        Set predecessors = v.getPredecessors();
        Iterator iter = predecessors.iterator();
        while (iter.hasNext()) {
            Vertex child = (Vertex)iter.next();
            Object o = child.getUserDatum(MINIMUMLEVELKEY);
            int oldLevel = o != null ? (Integer)o : 0;
            int newLevel = Math.max(oldLevel, level + 1);
            child.setUserDatum(MINIMUMLEVELKEY, new Integer(newLevel), UserData.REMOVE);
            if (newLevel > graphHeight) {
                graphHeight = newLevel;
            }
            DAGLayout.propagateMinimumLevel(child);
        }
    }

    protected void initializeLocation(Vertex v, Coordinates coord, Dimension d) {
        int level = (Integer)v.getUserDatum(MINIMUMLEVELKEY);
        int minY = (int)((double)level * d.getHeight() / ((double)graphHeight * 1.3));
        double x = Math.random() * d.getWidth();
        double y = Math.random() * (d.getHeight() - (double)minY) + (double)minY;
        coord.setX(x);
        coord.setY(y);
    }

    protected void initialize_local() {
        Iterator iter = this.getGraph().getEdges().iterator();
        while (iter.hasNext()) {
            Edge e = (Edge)iter.next();
            SpringLayout.SpringEdgeData sed = this.getSpringData(e);
            if (sed == null) {
                sed = new SpringLayout.SpringEdgeData(e);
                e.addUserDatum(this.getSpringKey(), sed, UserData.REMOVE);
            }
            this.calcEdgeLength(sed, this.lengthFunction);
        }
        DAGLayout.setRoot(this.getGraph());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveNodes() {
        double oldMSV = meanSquareVel;
        meanSquareVel = 0.0;
        Dimension dimension = this.getCurrentSize();
        synchronized (dimension) {
            Iterator i = this.getVisibleVertices().iterator();
            while (i.hasNext()) {
                Vertex v = (Vertex)i.next();
                if (this.dontMove(v)) continue;
                SpringLayout.SpringVertexData vd = this.getSpringData(v);
                Coordinates xyd = this.getCoordinates(v);
                int width = this.getCurrentSize().width;
                int height = this.getCurrentSize().height;
                int level = (Integer)v.getUserDatum(MINIMUMLEVELKEY);
                int minY = (int)((double)(level * height) / ((double)graphHeight * 1.3));
                int maxY = level == 0 ? (int)((double)height / ((double)graphHeight * 1.3 * 2.0)) : height;
                vd.dx += 2.0 * vd.repulsiondx + vd.edgedx;
                vd.dy += vd.repulsiondy + vd.edgedy;
                double delta = xyd.getY() - (double)minY;
                vd.dy -= delta * 0.8;
                if (level == 0) {
                    vd.dy -= delta * 0.8;
                }
                meanSquareVel += vd.dx * vd.dx + vd.dy * vd.dy;
                xyd.addX(Math.max(-5.0, Math.min(5.0, vd.dx)));
                xyd.addY(Math.max(-5.0, Math.min(5.0, vd.dy)));
                if (xyd.getX() < 0.0) {
                    xyd.setX(0.0);
                } else if (xyd.getX() > (double)width) {
                    xyd.setX(width);
                }
                if (xyd.getY() < (double)minY) {
                    xyd.setY(minY);
                } else if (xyd.getY() > (double)maxY) {
                    xyd.setY(maxY);
                }
                if (numRoots != 1 || level != 0) continue;
                xyd.setX(width / 2);
            }
        }
        if (!stoppingIncrements && Math.abs(meanSquareVel - oldMSV) < 10.0) {
            stoppingIncrements = true;
            incrementsLeft = 200;
        } else if (stoppingIncrements && Math.abs(meanSquareVel - oldMSV) <= 10.0 && --incrementsLeft <= 0) {
            incrementsLeft = 0;
        }
    }

    public boolean incrementsAreDone() {
        return stoppingIncrements && incrementsLeft == 0;
    }

    public void forceMove(Vertex picked, int x, int y) {
        Coordinates coord = this.getCoordinates(picked);
        coord.setX(x);
        coord.setY(y);
        stoppingIncrements = false;
    }

    protected void relaxEdges() {
        Iterator i = this.getVisibleEdges().iterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            Vertex v1 = this.getAVertex(e);
            Vertex v2 = e.getOpposite(v1);
            Point2D p1 = this.getLocation(v1);
            Point2D p2 = this.getLocation(v2);
            double vx = p1.getX() - p2.getX();
            double vy = p1.getY() - p2.getY();
            double len = Math.sqrt(vx * vx + vy * vy);
            int level1 = (Integer)v1.getUserDatum(MINIMUMLEVELKEY);
            int level2 = (Integer)v2.getUserDatum(MINIMUMLEVELKEY);
            double desiredLen = this.getLength(e);
            len = len == 0.0 ? 1.0E-4 : len;
            double f = this.force_multiplier * (desiredLen - len) / len;
            f *= Math.pow(this.stretch / 100.0, v1.degree() + v2.degree() - 2);
            if (level1 != level2) {
                f /= Math.pow(Math.abs(level2 - level1), 1.5);
            }
            double dx = f * vx;
            double dy = f * vy;
            SpringLayout.SpringVertexData v1D = this.getSpringData(v1);
            SpringLayout.SpringVertexData v2D = this.getSpringData(v2);
            SpringLayout.SpringEdgeData sed = this.getSpringData(e);
            sed.f = f;
            v1D.edgedx += dx;
            v1D.edgedy += dy;
            v2D.edgedx += -dx;
            v2D.edgedy += -dy;
        }
    }

    static {
        stoppingIncrements = false;
    }
}

