/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.PickEventListener;
import edu.uci.ics.jung.visualization.PickedState;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class MultiPickedState
implements PickedState {
    protected Set pickedVertices = new LinkedHashSet();
    protected Set pickedEdges = new LinkedHashSet();
    protected List pick_event_listeners = new LinkedList();

    public boolean pick(ArchetypeVertex v, boolean picked) {
        boolean prior_state = this.pickedVertices.contains(v);
        if (picked) {
            this.pickedVertices.add(v);
        } else {
            this.pickedVertices.remove(v);
        }
        Iterator iter = this.pick_event_listeners.iterator();
        while (iter.hasNext()) {
            PickEventListener pel = (PickEventListener)iter.next();
            if (picked) {
                pel.vertexPicked(v);
                continue;
            }
            pel.vertexUnpicked(v);
        }
        return prior_state;
    }

    public boolean pick(ArchetypeEdge e, boolean picked) {
        boolean prior_state = this.pickedEdges.contains(e);
        if (picked) {
            this.pickedEdges.add(e);
        } else {
            this.pickedEdges.remove(e);
        }
        Iterator iter = this.pick_event_listeners.iterator();
        while (iter.hasNext()) {
            PickEventListener pel = (PickEventListener)iter.next();
            if (picked) {
                pel.edgePicked(e);
                continue;
            }
            pel.edgeUnpicked(e);
        }
        return prior_state;
    }

    public void clearPickedVertices() {
        LinkedList iterable_set = new LinkedList(this.pickedVertices);
        Iterator it = iterable_set.iterator();
        while (it.hasNext()) {
            this.pick((ArchetypeVertex)it.next(), false);
        }
    }

    public void clearPickedEdges() {
        LinkedList iterable_set = new LinkedList(this.pickedEdges);
        Iterator it = iterable_set.iterator();
        while (it.hasNext()) {
            this.pick((ArchetypeEdge)it.next(), false);
        }
    }

    public Set getPickedEdges() {
        return Collections.unmodifiableSet(this.pickedEdges);
    }

    public boolean isPicked(ArchetypeEdge e) {
        return this.pickedEdges.contains(e);
    }

    public Set getPickedVertices() {
        return Collections.unmodifiableSet(this.pickedVertices);
    }

    public boolean isPicked(ArchetypeVertex v) {
        return this.pickedVertices.contains(v);
    }

    public void addListener(PickEventListener pel) {
        if (pel != null && !this.pick_event_listeners.contains(pel)) {
            this.pick_event_listeners.add(pel);
        }
    }

    public void removeListener(PickEventListener pel) {
        this.pick_event_listeners.remove(pel);
    }

    public boolean isPicked(Vertex v) {
        return this.pickedVertices.contains(v);
    }

    public boolean isPicked(Edge e) {
        return this.pickedEdges.contains(e);
    }
}

