/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.statistics;

import cern.colt.list.DoubleArrayList;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import edu.uci.ics.jung.algorithms.shortestpath.UnweightedShortestPath;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.statistics.Histogram;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GraphStatistics {
    public static Map clusteringCoefficients(ArchetypeGraph graph) {
        HashMap<ArchetypeVertex, Double> coefficients = new HashMap<ArchetypeVertex, Double>();
        Iterator v_iter = graph.getVertices().iterator();
        while (v_iter.hasNext()) {
            ArchetypeVertex v = (ArchetypeVertex)v_iter.next();
            int n = v.numNeighbors();
            if (n == 0) {
                coefficients.put(v, new Double(0.0));
                continue;
            }
            if (n == 1) {
                coefficients.put(v, new Double(1.0));
                continue;
            }
            ArrayList neighbors = new ArrayList(v.getNeighbors());
            double edge_count = 0.0;
            for (int i = 0; i < neighbors.size(); ++i) {
                ArchetypeVertex w = (ArchetypeVertex)neighbors.get(i);
                for (int j = i + 1; j < neighbors.size(); ++j) {
                    ArchetypeVertex x = (ArchetypeVertex)neighbors.get(j);
                    edge_count += w.isNeighborOf(x) ? 1.0 : 0.0;
                }
            }
            double possible_edges = (double)(n * (n - 1)) / 2.0;
            coefficients.put(v, new Double(edge_count / possible_edges));
        }
        return coefficients;
    }

    public static Map averageDistances(ArchetypeGraph graph, Distance d) {
        HashMap<ArchetypeVertex, Double> avg_dist = new HashMap<ArchetypeVertex, Double>();
        Set vertices = graph.getVertices();
        int n = graph.numVertices();
        Iterator outer = vertices.iterator();
        while (outer.hasNext()) {
            ArchetypeVertex v = (ArchetypeVertex)outer.next();
            double avgPathLength = 0.0;
            Iterator inner = vertices.iterator();
            while (inner.hasNext()) {
                ArchetypeVertex w = (ArchetypeVertex)inner.next();
                if (v == w) continue;
                Number dist = d.getDistance(v, w);
                if (dist == null) {
                    avgPathLength = Double.POSITIVE_INFINITY;
                    break;
                }
                avgPathLength += dist.doubleValue();
            }
            avg_dist.put(v, new Double(avgPathLength /= (double)(n - 1)));
        }
        return avg_dist;
    }

    public static Map averageDistances(ArchetypeGraph g) {
        return GraphStatistics.averageDistances(g, new UnweightedShortestPath((Graph)g));
    }

    public static double diameter(ArchetypeGraph g, Distance d) {
        double diameter = 0.0;
        Set vertices = g.getVertices();
        Iterator outer = vertices.iterator();
        while (outer.hasNext()) {
            ArchetypeVertex v = (ArchetypeVertex)outer.next();
            Iterator inner = vertices.iterator();
            while (inner.hasNext()) {
                ArchetypeVertex w = (ArchetypeVertex)inner.next();
                if (v == w) continue;
                Number dist = d.getDistance(v, w);
                if (dist == null) {
                    return Double.POSITIVE_INFINITY;
                }
                diameter = Math.max(diameter, dist.doubleValue());
            }
        }
        return diameter;
    }

    public static double diameter(ArchetypeGraph g) {
        return GraphStatistics.diameter(g, new UnweightedShortestPath((Graph)g));
    }

    public static Histogram createHistogram(DoubleArrayList values, double min, int numBins, double binWidth) {
        Histogram histogram = new Histogram(numBins, min, binWidth);
        for (int idx = 0; idx < values.size(); ++idx) {
            histogram.fill(values.get(idx));
        }
        return histogram;
    }
}

