/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.statistics;

import cern.colt.list.DoubleArrayList;
import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.statistics.Histogram;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.Set;

public class DegreeDistributions {
    public static DoubleArrayList getOutdegreeValues(Set vertices) {
        DoubleArrayList outDegreeValues = new DoubleArrayList();
        Vertex currentVertex = null;
        Iterator i = vertices.iterator();
        while (i.hasNext()) {
            currentVertex = (Vertex)i.next();
            outDegreeValues.add((double)currentVertex.outDegree());
        }
        return outDegreeValues;
    }

    public static DoubleArrayList getIndegreeValues(Set vertices) {
        DoubleArrayList list = new DoubleArrayList();
        Vertex currentVertex = null;
        Iterator i = vertices.iterator();
        while (i.hasNext()) {
            currentVertex = (Vertex)i.next();
            list.add((double)currentVertex.inDegree());
        }
        return list;
    }

    public static Histogram getOutdegreeHistogram(Set vertices, double min, double max, int numBins) {
        Histogram histogram = new Histogram(min, max, numBins);
        Iterator i = vertices.iterator();
        while (i.hasNext()) {
            Vertex currentVertex = (Vertex)i.next();
            int currentOutdegree = currentVertex.outDegree();
            histogram.fill(currentOutdegree);
        }
        return histogram;
    }

    public static Histogram getIndegreeHistogram(Set vertices, double min, double max, int numBins) {
        Histogram histogram = new Histogram(min, max, numBins);
        Iterator i = vertices.iterator();
        while (i.hasNext()) {
            Vertex currentVertex = (Vertex)i.next();
            int currentIndegree = currentVertex.inDegree();
            histogram.fill(currentIndegree);
        }
        return histogram;
    }

    public static void saveDistribution(Histogram histogram, String file) {
        try {
            BufferedWriter degreeWriter = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < histogram.size(); ++i) {
                int currentDegree = (int)((double)i + histogram.getMinimum());
                degreeWriter.write(currentDegree + " " + histogram.yValueAt(i) + "\n");
            }
            degreeWriter.close();
        }
        catch (Exception e) {
            throw new FatalException("Error saving binned data to " + file, e);
        }
    }
}

