/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.graph.decorators.NumberEdgeValue;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.impl.AbstractSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.graph.predicates.ParallelEdgePredicate;
import edu.uci.ics.jung.utils.GeneralUtils;
import edu.uci.ics.jung.utils.PredicateUtils;
import edu.uci.ics.jung.utils.TypedVertexGenerator;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.utils.VertexGenerator;
import edu.uci.ics.jung.visualization.DefaultSettableVertexLocationFunction;
import edu.uci.ics.jung.visualization.SettableVertexLocationFunction;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.OrPredicate;

public class PajekNetReader {
    protected boolean unique_labels;
    public static final String LABEL = "jung.io.PajekNetReader.LABEL";
    public static final String LOCATIONS = "jung.io.PajekNetReader.LOCATIONS";
    protected SettableVertexLocationFunction v_locations;
    protected boolean get_locations = false;
    private static final Predicate v_pred = new TagPred("*vertices");
    private static final Predicate a_pred = new TagPred("*arcs");
    private static final Predicate e_pred = new TagPred("*edges");
    private static final Predicate t_pred = new TagPred("*");
    private static final Predicate c_pred = OrPredicate.getInstance((Predicate)a_pred, (Predicate)e_pred);
    protected static final Predicate l_pred = ListTagPred.getInstance();
    protected static final Predicate p_pred = ParallelEdgePredicate.getInstance();

    public PajekNetReader(boolean unique_labels) {
        this(unique_labels, false);
    }

    public PajekNetReader(boolean unique_labels, boolean get_locations) {
        this.unique_labels = unique_labels;
        this.get_locations = get_locations;
        if (get_locations) {
            this.v_locations = new DefaultSettableVertexLocationFunction();
        }
    }

    public PajekNetReader(boolean unique_labels, SettableVertexLocationFunction v_locations) {
        this.unique_labels = unique_labels;
        this.get_locations = true;
        this.v_locations = v_locations;
    }

    public PajekNetReader() {
        this(false, false);
    }

    public Graph load(String filename) throws IOException {
        return this.load(filename, (Graph)new SparseGraph(), null);
    }

    public Graph load(String filename, NumberEdgeValue nev) throws IOException {
        return this.load(filename, (Graph)new SparseGraph(), nev);
    }

    public Graph load(String filename, Graph g) throws IOException {
        return this.load(filename, g, null);
    }

    public Graph load(String filename, Graph g, NumberEdgeValue nev) throws IOException {
        FileReader reader = new FileReader(filename);
        Graph graph = this.load(reader, g, nev);
        ((Reader)reader).close();
        return graph;
    }

    public Graph load(Reader reader, Graph g) throws IOException {
        return this.load(reader, g, null);
    }

    public Graph load(Reader reader, NumberEdgeValue nev) throws IOException {
        return this.load(reader, (Graph)new SparseGraph(), nev);
    }

    public Graph load(Reader reader) throws IOException {
        return this.load(reader, (Graph)new SparseGraph(), null);
    }

    public Graph load(Reader reader, Graph g, NumberEdgeValue nev) throws IOException {
        return this.load(reader, g, nev, new TypedVertexGenerator(g));
    }

    public Graph load(Reader reader, Graph g, NumberEdgeValue nev, VertexGenerator vg) throws IOException {
        BufferedReader br = new BufferedReader(reader);
        String curLine = this.skip(br, v_pred);
        if (curLine == null) {
            return g;
        }
        if (this.get_locations) {
            g.addUserDatum(LOCATIONS, this.v_locations, UserData.SHARED);
        }
        StringTokenizer st = new StringTokenizer(curLine);
        st.nextToken();
        int num_vertices = Integer.parseInt(st.nextToken());
        for (int i = 1; i <= num_vertices; ++i) {
            g.addVertex(vg.create());
        }
        Indexer id = Indexer.getIndexer(g);
        curLine = null;
        while (br.ready() && (curLine = br.readLine()) != null && !t_pred.evaluate((Object)curLine)) {
            if (curLine == "") continue;
            try {
                this.readVertex(curLine, id, num_vertices);
            }
            catch (IllegalArgumentException iae) {
                br.close();
                reader.close();
                throw iae;
            }
        }
        curLine = this.readArcsOrEdges(curLine, br, g, nev);
        this.readArcsOrEdges(curLine, br, g, nev);
        br.close();
        reader.close();
        return g;
    }

    private void readVertex(String curLine, Indexer id, int num_vertices) throws IOException {
        int i;
        String index;
        String[] parts = null;
        String label = null;
        if (curLine.indexOf(34) != -1) {
            String[] initial_split = curLine.trim().split("\"");
            if (initial_split.length < 2 || initial_split.length > 3) {
                throw new IllegalArgumentException("Unbalanced (or too many) quote marks in " + curLine);
            }
            index = initial_split[0].trim();
            label = initial_split[1].trim();
            if (initial_split.length == 3) {
                parts = initial_split[2].trim().split("\\s+", -1);
            }
            i = 0;
        } else {
            parts = curLine.trim().split("\\s+", -1);
            index = parts[0];
            if (GeneralUtils.isNumeric(parts[1])) {
                label = parts[1];
                i = 2;
            } else {
                i = 1;
            }
        }
        int v_id = Integer.parseInt(index) - 1;
        if (v_id >= num_vertices || v_id < 0) {
            throw new IllegalArgumentException("Vertex number " + v_id + "is not in the range [1," + num_vertices + "]");
        }
        Vertex v = (Vertex)id.getVertex(v_id);
        this.attachLabel(v, label);
        if (this.get_locations) {
            if (parts == null || parts.length < i + 2) {
                throw new IllegalArgumentException("Coordinates requested, but" + curLine + " does not include coordinates");
            }
            double x = Double.parseDouble(parts[i]);
            double y = Double.parseDouble(parts[i + 1]);
            this.v_locations.setLocation(v, new Point2D.Double(x, y));
        }
    }

    private String readArcsOrEdges(String curLine, BufferedReader br, Graph g, NumberEdgeValue nev) throws IOException {
        boolean parallel_ok;
        boolean reading_edges;
        String nextLine = curLine;
        Indexer id = Indexer.getIndexer(g);
        if (!c_pred.evaluate((Object)curLine)) {
            nextLine = this.skip(br, c_pred);
        }
        boolean reading_arcs = a_pred.evaluate((Object)nextLine) && !PredicateUtils.enforcesUndirected(g);
        boolean bl = reading_edges = e_pred.evaluate((Object)nextLine) && !PredicateUtils.enforcesDirected(g);
        if (!reading_arcs && !reading_edges) {
            return nextLine;
        }
        boolean is_list = l_pred.evaluate((Object)nextLine);
        boolean bl2 = parallel_ok = !PredicateUtils.enforcesNotParallel(g);
        while (br.ready() && (nextLine = br.readLine()) != null && !t_pred.evaluate((Object)nextLine)) {
            if (curLine == "") continue;
            StringTokenizer st = new StringTokenizer(nextLine.trim());
            int vid1 = Integer.parseInt(st.nextToken()) - 1;
            Vertex v1 = (Vertex)id.getVertex(vid1);
            if (is_list) {
                do {
                    this.createAddEdge(st, v1, reading_arcs, g, id, parallel_ok);
                } while (st.hasMoreTokens());
                continue;
            }
            Edge e = this.createAddEdge(st, v1, reading_arcs, g, id, parallel_ok);
            if (nev == null) continue;
            nev.setNumber(e, new Float(st.nextToken()));
        }
        return nextLine;
    }

    protected Edge createAddEdge(StringTokenizer st, Vertex v1, boolean directed, Graph g, Indexer id, boolean parallel_ok) {
        int vid2 = Integer.parseInt(st.nextToken()) - 1;
        Vertex v2 = (Vertex)id.getVertex(vid2);
        AbstractSparseEdge e = null;
        e = directed ? new DirectedSparseEdge(v1, v2) : new UndirectedSparseEdge(v1, v2);
        if (parallel_ok || !p_pred.evaluate((Object)e)) {
            g.addEdge(e);
        }
        return e;
    }

    protected String skip(BufferedReader br, Predicate p) throws IOException {
        String curLine;
        while (br.ready() && (curLine = br.readLine().trim()) != null) {
            if (!p.evaluate((Object)curLine)) continue;
            return curLine;
        }
        return null;
    }

    private void attachLabel(Vertex v, String string) throws IOException {
        if (string == null || string.length() == 0) {
            return;
        }
        String label = string.trim();
        if (this.unique_labels) {
            try {
                StringLabeller sl = StringLabeller.getLabeller((Graph)v.getGraph(), LABEL);
                sl.setLabel(v, label);
            }
            catch (StringLabeller.UniqueLabelException slule) {
                throw new FatalException("Non-unique label found: " + slule);
            }
        } else {
            v.addUserDatum(LABEL, label, UserData.SHARED);
        }
    }

    public void setUniqueLabels(boolean unique_labels) {
        this.unique_labels = unique_labels;
    }

    public void setGetLocations(boolean get_locations) {
        this.get_locations = get_locations;
    }

    protected static class ListTagPred
    implements Predicate {
        protected static ListTagPred instance;

        protected ListTagPred() {
        }

        public static ListTagPred getInstance() {
            if (instance == null) {
                instance = new ListTagPred();
            }
            return instance;
        }

        public boolean evaluate(Object arg0) {
            String s = (String)arg0;
            return s != null && s.toLowerCase().endsWith("list");
        }
    }

    protected static class TagPred
    implements Predicate {
        private String tag;

        public TagPred(String s) {
            this.tag = s;
        }

        public boolean evaluate(Object arg0) {
            String s = (String)arg0;
            return s != null && s.toLowerCase().startsWith(this.tag);
        }
    }
}

