/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.decorators;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.UndirectedEdge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.AbstractEdgePaintFunction;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.visualization.HasGraphLayout;
import edu.uci.ics.jung.visualization.Layout;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;

public class GradientEdgePaintFunction
extends AbstractEdgePaintFunction {
    protected Color c1;
    protected Color c2;
    HasGraphLayout vv;

    public GradientEdgePaintFunction(Color c1, Color c2, HasGraphLayout vv) {
        this.c1 = c1;
        this.c2 = c2;
        this.vv = vv;
    }

    public Paint getDrawPaint(Edge e) {
        Layout layout = this.vv.getGraphLayout();
        Pair p = e.getEndpoints();
        Vertex b = (Vertex)p.getFirst();
        Vertex f = (Vertex)p.getSecond();
        Point2D pb = layout.getLocation(b);
        Point2D pf = layout.getLocation(f);
        float xB = (float)pb.getX();
        float yB = (float)pb.getY();
        float xF = (float)pf.getX();
        float yF = (float)pf.getY();
        if (e instanceof UndirectedEdge) {
            xF = (xF + xB) / 2.0f;
            yF = (yF + yB) / 2.0f;
        }
        return new GradientPaint(xB, yB, this.getColor1(e), xF, yF, this.getColor2(e), true);
    }

    protected Color getColor1(Edge e) {
        return this.c1;
    }

    protected Color getColor2(Edge e) {
        return this.c2;
    }
}

