/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Hypervertex;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.ConstantEdgeValue;
import edu.uci.ics.jung.graph.decorators.NumberEdgeValue;
import edu.uci.ics.jung.utils.MapBinaryHeap;
import edu.uci.ics.jung.utils.Pair;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DijkstraDistance
implements Distance {
    protected ArchetypeGraph g;
    protected NumberEdgeValue nev;
    protected Map sourceMap;
    protected boolean cached;
    protected static final NumberEdgeValue dev = new ConstantEdgeValue(new Integer(1));
    protected double max_distance;
    protected int max_targets;

    public DijkstraDistance(ArchetypeGraph g, NumberEdgeValue nev, boolean cached) {
        this.g = g;
        this.nev = nev;
        this.sourceMap = new HashMap();
        this.cached = cached;
        this.max_distance = Double.POSITIVE_INFINITY;
        this.max_targets = Integer.MAX_VALUE;
    }

    public DijkstraDistance(ArchetypeGraph g, NumberEdgeValue nev) {
        this(g, nev, true);
    }

    public DijkstraDistance(ArchetypeGraph g) {
        this(g, dev, true);
    }

    public DijkstraDistance(ArchetypeGraph g, boolean cached) {
        this(g, dev, cached);
    }

    protected LinkedHashMap singleSourceShortestPath(ArchetypeVertex source, Set targets, int numDests) {
        SourceData sd = this.getSourceData(source);
        HashSet to_get = new HashSet();
        if (targets != null) {
            to_get.addAll(targets);
            Set existing_dists = sd.distances.keySet();
            Iterator iter = targets.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!existing_dists.contains(o)) continue;
                to_get.remove(o);
            }
        }
        if (sd.reached_max || targets != null && to_get.isEmpty() || sd.distances.size() >= numDests) {
            return sd.distances;
        }
        while (!(sd.unknownVertices.isEmpty() || sd.distances.size() >= numDests && to_get.isEmpty())) {
            double v_dist;
            Pair p = sd.getNextVertex();
            ArchetypeVertex v = (ArchetypeVertex)p.getFirst();
            sd.dist_reached = v_dist = ((Double)p.getSecond()).doubleValue();
            to_get.remove(v);
            if (sd.dist_reached >= this.max_distance || sd.distances.size() >= this.max_targets) {
                sd.reached_max = true;
                break;
            }
            Iterator out_iter = this.getIncidentEdges(v).iterator();
            while (out_iter.hasNext()) {
                ArchetypeEdge e = (ArchetypeEdge)out_iter.next();
                Iterator e_iter = e.getIncidentVertices().iterator();
                while (e_iter.hasNext()) {
                    ArchetypeVertex w = (ArchetypeVertex)e_iter.next();
                    if (sd.distances.containsKey(w)) continue;
                    double edge_weight = this.nev.getNumber(e).doubleValue();
                    if (edge_weight < 0.0) {
                        throw new IllegalArgumentException("Edge weights must be non-negative");
                    }
                    double new_dist = v_dist + edge_weight;
                    if (!sd.estimatedDistances.containsKey(w)) {
                        sd.createRecord(w, e, new_dist);
                        continue;
                    }
                    double w_dist = (Double)sd.estimatedDistances.get(w);
                    if (!(new_dist < w_dist)) continue;
                    sd.update(w, e, new_dist);
                }
            }
        }
        return sd.distances;
    }

    protected SourceData getSourceData(ArchetypeVertex source) {
        SourceData sd = (SourceData)this.sourceMap.get(source);
        if (sd == null) {
            sd = new SourceData(source);
        }
        return sd;
    }

    protected Set getIncidentEdges(ArchetypeVertex v) {
        if (v instanceof Vertex) {
            return ((Vertex)v).getOutEdges();
        }
        if (v instanceof Hypervertex) {
            return v.getIncidentEdges();
        }
        throw new IllegalArgumentException("Unrecognized vertex type: " + v.getClass().getName());
    }

    public Number getDistance(ArchetypeVertex source, ArchetypeVertex target) {
        if (target.getGraph() != this.g) {
            throw new IllegalArgumentException("Specified target vertex " + target + " is not part of graph " + this.g);
        }
        HashSet<ArchetypeVertex> targets = new HashSet<ArchetypeVertex>();
        targets.add(target);
        Map distanceMap = this.getDistanceMap(source, targets);
        return (Double)distanceMap.get(target);
    }

    public Map getDistanceMap(ArchetypeVertex source, Set targets) {
        if (source.getGraph() != this.g) {
            throw new IllegalArgumentException("Specified source vertex " + source + " is not part of graph " + this.g);
        }
        if (targets.size() > this.max_targets) {
            throw new IllegalArgumentException("size of target set exceeds maximum number of targets allowed: " + this.max_targets);
        }
        LinkedHashMap distanceMap = this.singleSourceShortestPath(source, targets, Math.min(this.g.numVertices(), this.max_targets));
        if (!this.cached) {
            this.reset(source);
        }
        return distanceMap;
    }

    public Map getDistanceMap(ArchetypeVertex source) {
        return this.getDistanceMap(source, Math.min(this.g.numVertices(), this.max_targets));
    }

    public LinkedHashMap getDistanceMap(ArchetypeVertex source, int numDests) {
        if (source.getGraph() != this.g) {
            throw new IllegalArgumentException("Specified source vertex " + source + " is not part of graph " + this.g);
        }
        if (numDests < 1 || numDests > this.g.numVertices()) {
            throw new IllegalArgumentException("numDests must be >= 1 and <= g.numVertices()");
        }
        if (numDests > this.max_targets) {
            throw new IllegalArgumentException("numDests must be <= the maximum number of targets allowed: " + this.max_targets);
        }
        LinkedHashMap distanceMap = this.singleSourceShortestPath(source, null, numDests);
        if (!this.cached) {
            this.reset(source);
        }
        return distanceMap;
    }

    public void setMaxDistance(double max_dist) {
        this.max_distance = max_dist;
        Iterator iter = this.sourceMap.keySet().iterator();
        while (iter.hasNext()) {
            SourceData sd = (SourceData)this.sourceMap.get(iter.next());
            sd.reached_max = this.max_distance <= sd.dist_reached || sd.distances.size() >= this.max_targets;
        }
    }

    public void setMaxTargets(int max_targets) {
        this.max_targets = max_targets;
        Iterator iter = this.sourceMap.keySet().iterator();
        while (iter.hasNext()) {
            SourceData sd = (SourceData)this.sourceMap.get(iter.next());
            sd.reached_max = this.max_distance <= sd.dist_reached || sd.distances.size() >= max_targets;
        }
    }

    public void reset() {
        this.sourceMap = new HashMap();
    }

    public void enableCaching(boolean enable) {
        this.cached = enable;
    }

    public void reset(ArchetypeVertex source) {
        this.sourceMap.put(source, null);
    }

    protected class SourceData {
        public LinkedHashMap distances = new LinkedHashMap();
        public Map estimatedDistances = new HashMap();
        public MapBinaryHeap unknownVertices;
        public boolean reached_max = false;
        public double dist_reached = 0.0;

        public SourceData(ArchetypeVertex source) {
            this.unknownVertices = new MapBinaryHeap(new VertexComparator(this.estimatedDistances));
            DijkstraDistance.this.sourceMap.put(source, this);
            this.estimatedDistances.put(source, new Double(0.0));
            this.unknownVertices.insert(source);
            this.reached_max = false;
            this.dist_reached = 0.0;
        }

        public Pair getNextVertex() {
            ArchetypeVertex v = (ArchetypeVertex)this.unknownVertices.pop();
            Double dist = (Double)this.estimatedDistances.remove(v);
            this.distances.put(v, dist);
            return new Pair(v, dist);
        }

        public void update(ArchetypeVertex dest, ArchetypeEdge tentative_edge, double new_dist) {
            this.estimatedDistances.put(dest, new Double(new_dist));
            this.unknownVertices.update(dest);
        }

        public void createRecord(ArchetypeVertex w, ArchetypeEdge e, double new_dist) {
            this.estimatedDistances.put(w, new Double(new_dist));
            this.unknownVertices.insert(w);
        }
    }

    protected class VertexComparator
    implements Comparator {
        private Map distances;

        public VertexComparator(Map distances) {
            this.distances = distances;
        }

        public int compare(Object o1, Object o2) {
            return ((Comparable)this.distances.get(o1)).compareTo(this.distances.get(o2));
        }
    }
}

