/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.metrics;

import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.NumberEdgeValue;
import java.util.Iterator;

public class StructuralHoles {
    protected NumberEdgeValue nev;

    public StructuralHoles(NumberEdgeValue nev) {
        this.nev = nev;
    }

    public double effectiveSize(Vertex v) {
        double result = v.degree();
        Iterator v_iter = v.getNeighbors().iterator();
        while (v_iter.hasNext()) {
            Vertex u = (Vertex)v_iter.next();
            Iterator u_iter = u.getNeighbors().iterator();
            while (u_iter.hasNext()) {
                Vertex w = (Vertex)u_iter.next();
                if (w == v || w == u) continue;
                result -= this.normalizedMutualEdgeWeight(v, w) * this.maxScaledMutualEdgeWeight(u, w);
            }
        }
        return result;
    }

    public double efficiency(Vertex v) {
        double degree = v.degree();
        if (degree == 0.0) {
            return 0.0;
        }
        return this.effectiveSize(v) / degree;
    }

    public double constraint(Vertex v) {
        double result = 0.0;
        Iterator v_iter = v.getNeighbors().iterator();
        while (v_iter.hasNext()) {
            Vertex w = (Vertex)v_iter.next();
            if (v == w || !w.isPredecessorOf(v) || !v.isPredecessorOf(w)) continue;
            result += this.localConstraint(v, w);
        }
        return result;
    }

    public double hierarchy(Vertex v) {
        double v_degree = v.degree();
        if (v_degree == 0.0) {
            return Double.NaN;
        }
        if (v_degree == 1.0) {
            return 1.0;
        }
        double v_constraint = this.aggregateConstraint(v);
        double numerator = 0.0;
        Iterator iter = v.getNeighbors().iterator();
        while (iter.hasNext()) {
            Vertex w = (Vertex)iter.next();
            if (v == w) continue;
            double sl_constraint = this.localConstraint(v, w) / (v_constraint / v_degree);
            numerator += sl_constraint * Math.log(sl_constraint);
        }
        return numerator / (v_degree * Math.log(v_degree));
    }

    protected double localConstraint(Vertex v1, Vertex v2) {
        double nmew_vw = this.normalizedMutualEdgeWeight(v1, v2);
        double inner_result = 0.0;
        Iterator v_iter = v1.getNeighbors().iterator();
        while (v_iter.hasNext()) {
            Vertex w = (Vertex)v_iter.next();
            inner_result += this.normalizedMutualEdgeWeight(v1, w) * this.normalizedMutualEdgeWeight(w, v2);
        }
        return (nmew_vw + inner_result) * (nmew_vw + inner_result);
    }

    protected double aggregateConstraint(Vertex v) {
        double result = 0.0;
        Iterator v_iter = v.getNeighbors().iterator();
        while (v_iter.hasNext()) {
            Vertex w = (Vertex)v_iter.next();
            result += this.localConstraint(v, w) * this.organizationalMeasure(w);
        }
        return result;
    }

    protected double organizationalMeasure(Vertex v) {
        return 1.0;
    }

    protected double normalizedMutualEdgeWeight(Vertex v1, Vertex v2) {
        if (v1 == v2) {
            throw new IllegalArgumentException("parameters must be distinct vertices");
        }
        double numerator = this.mutualWeight(v1, v2);
        if (numerator == 0.0) {
            return 0.0;
        }
        double denominator = 0.0;
        Iterator iter = v1.getNeighbors().iterator();
        while (iter.hasNext()) {
            denominator += this.mutualWeight(v1, (Vertex)iter.next());
        }
        if (denominator == 0.0) {
            return 0.0;
        }
        return numerator / denominator;
    }

    protected double mutualWeight(Vertex v1, Vertex v2) {
        return this.nev.getNumber(v1.findEdge(v2)).doubleValue() + this.nev.getNumber(v2.findEdge(v1)).doubleValue();
    }

    protected double maxScaledMutualEdgeWeight(Vertex v1, Vertex v2) {
        if (v1 == v2) {
            throw new IllegalArgumentException("parameters must be distinct vertices");
        }
        double numerator = this.mutualWeight(v1, v2);
        if (numerator == 0.0) {
            return 0.0;
        }
        double denominator = 0.0;
        Iterator iter = v1.getNeighbors().iterator();
        while (iter.hasNext()) {
            Vertex w = (Vertex)iter.next();
            if (v2 == w) continue;
            denominator = Math.max(numerator, this.mutualWeight(v1, w));
        }
        if (denominator == 0.0) {
            return 0.0;
        }
        return numerator / denominator;
    }
}

