/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.RelativeAuthorityRanker;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.MutableDouble;
import edu.uci.ics.jung.utils.NumericalPrecision;
import edu.uci.ics.jung.utils.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PageRank
extends RelativeAuthorityRanker {
    public static final String KEY = "jung.algorithms.importance.PageRank.RankScore";
    private double mAlpha;
    private HashMap mPreviousRankingsMap;
    private Set mUnreachableVertices;
    private Set mReachableVertices;
    private Set mLeafNodes;

    public PageRank(DirectedGraph graph, double bias) {
        this.initialize(graph, bias, null);
        this.initializeRankings(graph.getVertices(), new HashSet());
    }

    public PageRank(DirectedGraph graph, double bias, String edgeWeightKeyName) {
        this.initialize(graph, bias, edgeWeightKeyName);
        this.initializeRankings(graph.getVertices(), new HashSet());
    }

    protected PageRank(DirectedGraph graph, double bias, String edgeWeightKeyName, Pair reachables) {
        this.initialize(graph, bias, edgeWeightKeyName);
        this.initializeRankings((Set)reachables.getFirst(), (Set)reachables.getSecond());
    }

    protected void initialize(DirectedGraph graph, double bias, String edgeWeightKeyName) {
        super.initialize(graph, true, false);
        if (bias < 0.0 || bias > 1.0) {
            throw new IllegalArgumentException("Bias " + bias + " must be between 0 and 1.");
        }
        this.mAlpha = bias;
        if (edgeWeightKeyName == null) {
            this.assignDefaultEdgeTransitionWeights();
        } else {
            this.setUserDefinedEdgeWeightKey(edgeWeightKeyName);
            this.normalizeEdgeTransitionWeights();
        }
    }

    protected void initializeRankings(Set reachableVertices, Set unreachableVertices) {
        Vertex currentVertex;
        this.mReachableVertices = reachableVertices;
        double numVertices = reachableVertices.size();
        this.mPreviousRankingsMap = new HashMap();
        this.mLeafNodes = new HashSet();
        Iterator vIt = this.mReachableVertices.iterator();
        while (vIt.hasNext()) {
            currentVertex = (Vertex)vIt.next();
            this.setRankScore(currentVertex, 1.0 / numVertices);
            this.setPriorRankScore(currentVertex, 1.0 / numVertices);
            this.mPreviousRankingsMap.put(currentVertex, new MutableDouble(1.0 / numVertices));
            if (currentVertex.outDegree() != 0) continue;
            this.mLeafNodes.add(currentVertex);
        }
        this.mUnreachableVertices = unreachableVertices;
        vIt = this.mUnreachableVertices.iterator();
        while (vIt.hasNext()) {
            currentVertex = (Vertex)vIt.next();
            this.setRankScore(currentVertex, 0.0);
            this.setPriorRankScore(currentVertex, 0.0);
            this.mPreviousRankingsMap.put(currentVertex, new MutableDouble(0.0));
        }
    }

    protected void reinitialize() {
        this.initializeRankings(this.mReachableVertices, this.mUnreachableVertices);
    }

    protected void updateRankings() {
        double totalSum = 0.0;
        Iterator vIt = this.mReachableVertices.iterator();
        while (vIt.hasNext()) {
            double currentWeight;
            Vertex currentVertex = (Vertex)vIt.next();
            Set incomingEdges = currentVertex.getInEdges();
            double currentPageRankSum = 0.0;
            Iterator edgeIt = incomingEdges.iterator();
            while (edgeIt.hasNext()) {
                Edge incomingEdge = (Edge)edgeIt.next();
                if (this.mUnreachableVertices.contains(incomingEdge.getOpposite(currentVertex))) continue;
                currentWeight = this.getEdgeWeight(incomingEdge);
                currentPageRankSum += ((MutableDouble)this.mPreviousRankingsMap.get(incomingEdge.getOpposite(currentVertex))).doubleValue() * currentWeight;
            }
            if (this.getPriorRankScore(currentVertex) > 0.0) {
                Iterator leafIt = this.mLeafNodes.iterator();
                while (leafIt.hasNext()) {
                    Vertex leafNode = (Vertex)leafIt.next();
                    currentWeight = this.getPriorRankScore(currentVertex);
                    currentPageRankSum += ((MutableDouble)this.mPreviousRankingsMap.get(leafNode)).doubleValue() * currentWeight;
                }
            }
            totalSum += currentPageRankSum * (1.0 - this.mAlpha) + this.mAlpha * this.getPriorRankScore(currentVertex);
            this.setRankScore(currentVertex, currentPageRankSum * (1.0 - this.mAlpha) + this.mAlpha * this.getPriorRankScore(currentVertex));
        }
        if (!NumericalPrecision.equal(totalSum, 1.0, 0.05)) {
            System.err.println("Page rank scores can not be generated because the specified graph is not connected.");
            System.out.println(totalSum);
        }
    }

    protected double evaluateIteration() {
        this.updateRankings();
        double rankingMSE = 0.0;
        Iterator vIt = this.mReachableVertices.iterator();
        while (vIt.hasNext()) {
            Vertex currentVertex = (Vertex)vIt.next();
            MutableDouble previousRankScore = (MutableDouble)this.mPreviousRankingsMap.get(currentVertex);
            rankingMSE += Math.pow(this.getRankScore(currentVertex) - previousRankScore.doubleValue(), 2.0);
            previousRankScore.setDoubleValue(this.getRankScore(currentVertex));
        }
        rankingMSE = Math.pow(rankingMSE / (double)this.getVertices().size(), 0.5);
        return rankingMSE;
    }

    public String getRankScoreKey() {
        return KEY;
    }
}

