/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import cern.colt.list.DoubleArrayList;
import corejava.Format;
import edu.uci.ics.jung.algorithms.IterativeProcess;
import edu.uci.ics.jung.algorithms.importance.EdgeRanking;
import edu.uci.ics.jung.algorithms.importance.NodeRanking;
import edu.uci.ics.jung.algorithms.importance.Ranking;
import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Element;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.utils.MutableDouble;
import edu.uci.ics.jung.utils.UserData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractRanker
extends IterativeProcess {
    private Graph mGraph;
    private List mRankings;
    public static final String DEFAULT_EDGE_WEIGHT_KEY = "jung.algorithms.importance.AbstractRanker.EdgeWeight";
    private String mUserDefinedEdgeWeightKey;
    private boolean mRemoveRankScoresOnFinalize;
    private boolean mRankNodes;
    private boolean mRankEdges;
    private boolean mNormalizeRankings;

    protected void initialize(Graph graph, boolean isNodeRanker, boolean isEdgeRanker) {
        if (!isNodeRanker && !isEdgeRanker) {
            throw new IllegalArgumentException("Must rank edges, vertices, or both");
        }
        this.mGraph = graph;
        this.mRemoveRankScoresOnFinalize = true;
        this.mNormalizeRankings = true;
        this.mUserDefinedEdgeWeightKey = null;
        this.mRankNodes = isNodeRanker;
        this.mRankEdges = isEdgeRanker;
    }

    protected Set getVertices() {
        return this.mGraph.getVertices();
    }

    protected Graph getGraph() {
        return this.mGraph;
    }

    protected void reinitialize() {
    }

    public boolean isRankingNodes() {
        return this.mRankNodes;
    }

    public boolean isRankingEdges() {
        return this.mRankEdges;
    }

    public void setRemoveRankScoresOnFinalize(boolean removeRankScoresOnFinalize) {
        this.mRemoveRankScoresOnFinalize = removeRankScoresOnFinalize;
    }

    protected void onFinalize(Element e) {
    }

    protected void finalizeIterations() {
        Ranking ranking;
        Iterator it;
        ArrayList<NodeRanking> sortedRankings = new ArrayList<NodeRanking>();
        int id = 1;
        if (this.mRankNodes) {
            it = this.getVertices().iterator();
            while (it.hasNext()) {
                Vertex currentVertex = (Vertex)it.next();
                ranking = new NodeRanking(id, this.getRankScore(currentVertex), currentVertex);
                sortedRankings.add((NodeRanking)ranking);
                if (this.mRemoveRankScoresOnFinalize) {
                    currentVertex.removeUserDatum(this.getRankScoreKey());
                }
                ++id;
                this.onFinalize(currentVertex);
            }
        }
        if (this.mRankEdges) {
            it = this.mGraph.getEdges().iterator();
            while (it.hasNext()) {
                Edge currentEdge = (Edge)it.next();
                ranking = new EdgeRanking(id, this.getRankScore(currentEdge), currentEdge);
                sortedRankings.add((NodeRanking)ranking);
                if (this.mRemoveRankScoresOnFinalize) {
                    currentEdge.removeUserDatum(this.getRankScoreKey());
                }
                ++id;
                this.onFinalize(currentEdge);
            }
        }
        this.mRankings = sortedRankings;
        Collections.sort(this.mRankings);
    }

    public List getRankings() {
        return this.mRankings;
    }

    public DoubleArrayList getRankScores(int topKRankings) {
        DoubleArrayList scores = new DoubleArrayList();
        int count = 1;
        Iterator rIt = this.getRankings().iterator();
        while (rIt.hasNext()) {
            if (count > topKRankings) {
                return scores;
            }
            NodeRanking currentRanking = (NodeRanking)rIt.next();
            scores.add(currentRanking.rankScore);
            ++count;
        }
        return scores;
    }

    public abstract String getRankScoreKey();

    public double getRankScore(Element e) {
        MutableDouble rankScore = (MutableDouble)e.getUserDatum(this.getRankScoreKey());
        if (rankScore != null) {
            return rankScore.doubleValue();
        }
        throw new FatalException("setRemoveRankScoresOnFinalize(false) must be called before evaluate().");
    }

    protected void setRankScore(Element e, double rankValue) {
        MutableDouble value = (MutableDouble)e.getUserDatum(this.getRankScoreKey());
        if (value == null) {
            e.setUserDatum(this.getRankScoreKey(), new MutableDouble(rankValue), UserData.SHARED);
        } else {
            value.setDoubleValue(rankValue);
        }
    }

    protected double getEdgeWeight(Edge e) {
        String edgeWeightKey = this.getEdgeWeightKeyName();
        return ((MutableDouble)e.getUserDatum(edgeWeightKey)).doubleValue();
    }

    public String getEdgeWeightKeyName() {
        if (this.mUserDefinedEdgeWeightKey == null) {
            return DEFAULT_EDGE_WEIGHT_KEY;
        }
        return this.mUserDefinedEdgeWeightKey;
    }

    protected void setEdgeWeight(Edge e, double weight) {
        String edgeWeightKey = this.getEdgeWeightKeyName();
        MutableDouble value = (MutableDouble)e.getUserDatum(edgeWeightKey);
        if (value == null) {
            e.setUserDatum(edgeWeightKey, new MutableDouble(weight), UserData.SHARED);
        } else {
            value.setDoubleValue(weight);
        }
    }

    protected void assignDefaultEdgeTransitionWeights() {
        Iterator vIt = this.getVertices().iterator();
        while (vIt.hasNext()) {
            Vertex currentVertex = (Vertex)vIt.next();
            Set outgoingEdges = currentVertex.getOutEdges();
            double numOutEdges = outgoingEdges.size();
            Iterator edgeIt = outgoingEdges.iterator();
            while (edgeIt.hasNext()) {
                Edge currentEdge = (Edge)edgeIt.next();
                this.setEdgeWeight(currentEdge, 1.0 / numOutEdges);
            }
        }
    }

    protected void normalizeEdgeTransitionWeights() {
        Iterator vIt = this.getVertices().iterator();
        while (vIt.hasNext()) {
            Edge currentEdge;
            Vertex currentVertex = (Vertex)vIt.next();
            Set outgoingEdges = currentVertex.getOutEdges();
            double totalEdgeWeight = 0.0;
            Iterator edgeIt = outgoingEdges.iterator();
            while (edgeIt.hasNext()) {
                currentEdge = (Edge)edgeIt.next();
                totalEdgeWeight += this.getEdgeWeight(currentEdge);
            }
            edgeIt = outgoingEdges.iterator();
            while (edgeIt.hasNext()) {
                currentEdge = (Edge)edgeIt.next();
                this.setEdgeWeight(currentEdge, this.getEdgeWeight(currentEdge) / totalEdgeWeight);
            }
        }
    }

    protected void normalizeRankings() {
        if (!this.mNormalizeRankings) {
            return;
        }
        double totalWeight = 0.0;
        Vertex currentVertex = null;
        Iterator it = this.getVertices().iterator();
        while (it.hasNext()) {
            currentVertex = (Vertex)it.next();
            totalWeight += this.getRankScore(currentVertex);
        }
        it = this.getVertices().iterator();
        while (it.hasNext()) {
            currentVertex = (Vertex)it.next();
            this.setRankScore(currentVertex, this.getRankScore(currentVertex) / totalWeight);
        }
    }

    public void printRankings(boolean verbose, boolean printScore) {
        double total = 0.0;
        Format formatter = new Format("%7.6f");
        int rank = 1;
        boolean hasLabels = StringLabeller.hasStringLabeller(this.getGraph());
        StringLabeller labeller = StringLabeller.getLabeller(this.getGraph());
        Iterator it = this.getRankings().iterator();
        while (it.hasNext()) {
            Ranking currentRanking = (Ranking)it.next();
            double rankScore = currentRanking.rankScore;
            if (verbose) {
                System.out.print("Rank " + rank + ": ");
                if (printScore) {
                    System.out.print(formatter.format(rankScore));
                }
                System.out.print("\tVertex Id: " + currentRanking.originalPos);
                if (hasLabels && currentRanking instanceof NodeRanking) {
                    Vertex v = ((NodeRanking)currentRanking).vertex;
                    System.out.print(" (" + labeller.getLabel(v) + ")");
                }
                System.out.println();
            } else {
                System.out.print(rank + "\t");
                if (printScore) {
                    System.out.print(formatter.format(rankScore));
                }
                System.out.println("\t" + currentRanking.originalPos);
            }
            total += rankScore;
            ++rank;
        }
        if (verbose) {
            System.out.println("Total: " + formatter.format(total));
        }
    }

    public void setNormalizeRankings(boolean normalizeRankings) {
        this.mNormalizeRankings = normalizeRankings;
    }

    public void setUserDefinedEdgeWeightKey(String keyName) {
        this.mUserDefinedEdgeWeightKey = keyName;
    }
}

