/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.blockmodel;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class EquivalenceRelation {
    private Set equivalenceSets;
    private Graph graph;

    public EquivalenceRelation(Set rv, Graph g) {
        this.equivalenceSets = Collections.unmodifiableSet(rv);
        this.graph = g;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Set getSingletonVertices() {
        HashSet allVerticesInEquivalence = new HashSet();
        Iterator iter = this.equivalenceSets.iterator();
        while (iter.hasNext()) {
            Set s = (Set)iter.next();
            allVerticesInEquivalence.addAll(s);
        }
        HashSet allVertices = new HashSet(this.graph.getVertices());
        allVertices.removeAll(allVerticesInEquivalence);
        return allVertices;
    }

    public Iterator getAllEquivalences() {
        return this.equivalenceSets.iterator();
    }

    public Set getEquivalenceRelationContaining(Vertex v) {
        Iterator iter = this.equivalenceSets.iterator();
        while (iter.hasNext()) {
            Set s = (Set)iter.next();
            if (!s.contains(v)) continue;
            return s;
        }
        return null;
    }

    public int numRelations() {
        return this.equivalenceSets.size();
    }

    public String toString() {
        return "Equivalence: " + this.equivalenceSets;
    }
}

