/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import weka.classifiers.EnsembleLibrary;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.core.Instances;
import weka.core.Memory;
import weka.core.SystemInfo;
import weka.core.Utils;
import weka.core.Version;
import weka.gui.BrowserHelper;
import weka.gui.EnsembleLibraryEditor;
import weka.gui.ExtensionFileFilter;
import weka.gui.LogWindow;
import weka.gui.LookAndFeel;
import weka.gui.SimpleCLIPanel;
import weka.gui.SplashWindow;
import weka.gui.arffviewer.ArffViewerMainPanel;
import weka.gui.beans.KnowledgeFlow;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.StartUpListener;
import weka.gui.boundaryvisualizer.BoundaryVisualizer;
import weka.gui.experiment.Experimenter;
import weka.gui.explorer.Explorer;
import weka.gui.graphvisualizer.GraphVisualizer;
import weka.gui.sql.SqlViewer;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;
import weka.gui.visualize.VisualizePanel;

public class Main
extends JFrame {
    private static final long serialVersionUID = 1453813254824253849L;
    protected Main m_Self;
    protected static Main m_MainCommandline;
    protected static Main m_MainSingleton;
    protected static Vector m_StartupListeners;
    protected static Memory m_Memory;
    protected HashSet<ChildFrame> m_ChildFrames = new HashSet();
    protected static LogWindow m_LogWindow;
    protected JFileChooser m_FileChooserTreeVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserGraphVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserPlot = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserROC = new JFileChooser(new File(System.getProperty("user.dir")));
    private JMenu jMenuHelp;
    private JMenu jMenuVisualization;
    private JMenu jMenuTools;
    private JDesktopPane jDesktopPane;
    private JMenu jMenuApplications;
    private JSeparator jSeparatorProgram1;
    private JMenuItem jMenuItemHelpSystemInfo;
    private JSeparator jSeparatorHelp1;
    private JSeparator jSeparatorHelp2;
    private JMenuItem jMenuItemHelpAbout;
    private JMenuItem jMenuItemHelpHomepage;
    private JMenuItem jMenuItemVisualizationBoundaryVisualizer;
    private JMenuItem jMenuItemVisualizationGraphVisualizer;
    private JMenuItem jMenuItemVisualizationTreeVisualizer;
    private JMenuItem jMenuItemVisualizationROC;
    private JMenuItem jMenuItemVisualizationPlot;
    private JMenuItem jMenuItemToolsEnsembleLibrary;
    private JMenuItem jMenuItemToolsSqlViewer;
    private JMenuItem jMenuItemToolsArffViewer;
    private JMenuItem jMenuItemApplicationsSimpleCLI;
    private JMenuItem jMenuItemApplicationsKnowledgeFlow;
    private JMenuItem jMenuItemApplicationsExperimenter;
    private JMenuItem jMenuItemApplicationsExplorer;
    private JMenuItem jMenuItemProgramExit;
    private JMenuItem jMenuItemProgramLogWindow;
    private JMenuItem jMenuItemProgramPreferences;
    private JMenu jMenuProgram;
    private JMenu jMenuWindows;
    private JMenuBar jMenuBar;

    public Main() {
        this.initGUI();
    }

    private void initGUI() {
        this.m_Self = this;
        try {
            this.setSize(1000, 800);
            int n = this.getGraphicsConfiguration().getBounds().height;
            int n2 = this.getGraphicsConfiguration().getBounds().width;
            this.setLocation((n2 - this.getBounds().width) / 2, (n - this.getBounds().height) / 2);
            this.createTitle("");
            this.setDefaultCloseOperation(3);
            this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("weka/gui/weka_icon.gif")).getImage());
            this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".bif", "BIF Files (*.bif)"));
            this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".xml", "XML Files (*.xml)"));
            this.m_FileChooserPlot.addChoosableFileFilter(new ExtensionFileFilter(Instances.FILE_EXTENSION, "ARFF Files (*" + Instances.FILE_EXTENSION + ")"));
            this.m_FileChooserPlot.setMultiSelectionEnabled(true);
            this.m_FileChooserROC.addChoosableFileFilter(new ExtensionFileFilter(Instances.FILE_EXTENSION, "ARFF Files (*" + Instances.FILE_EXTENSION + ")"));
            this.jDesktopPane = new BackgroundDesktopPane("weka/gui/images/weka_background.gif");
            this.jDesktopPane.setDragMode(1);
            this.setContentPane(this.jDesktopPane);
            this.jMenuBar = new JMenuBar();
            this.setJMenuBar(this.jMenuBar);
            this.jMenuProgram = new JMenu();
            this.jMenuBar.add(this.jMenuProgram);
            this.jMenuProgram.setText("Program");
            this.jMenuProgram.setMnemonic('P');
            this.jMenuItemProgramLogWindow = new JMenuItem();
            this.jMenuProgram.add(this.jMenuItemProgramLogWindow);
            this.jMenuItemProgramLogWindow.setText("LogWindow");
            this.jMenuItemProgramLogWindow.setMnemonic('L');
            this.jMenuItemProgramLogWindow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    m_LogWindow.setVisible(true);
                }
            });
            this.jSeparatorProgram1 = new JSeparator();
            this.jMenuProgram.add(this.jSeparatorProgram1);
            this.jMenuItemProgramExit = new JMenuItem();
            this.jMenuProgram.add(this.jMenuItemProgramExit);
            this.jMenuItemProgramExit.setText("Exit");
            this.jMenuItemProgramExit.setMnemonic('E');
            this.jMenuItemProgramExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Iterator iterator = Main.this.getWindowList();
                    Vector<ChildFrame> vector = new Vector<ChildFrame>();
                    while (iterator.hasNext()) {
                        vector.add((ChildFrame)iterator.next());
                    }
                    for (int i = 0; i < vector.size(); ++i) {
                        ((ChildFrame)vector.get(i)).dispose();
                    }
                    m_LogWindow.dispose();
                    Main.this.m_Self.dispose();
                    System.exit(0);
                }
            });
            this.jMenuApplications = new JMenu();
            this.jMenuBar.add(this.jMenuApplications);
            this.jMenuApplications.setText("Applications");
            this.jMenuApplications.setMnemonic('A');
            this.jMenuItemApplicationsExplorer = new JMenuItem();
            this.jMenuApplications.add(this.jMenuItemApplicationsExplorer);
            this.jMenuItemApplicationsExplorer.setText("Explorer");
            this.jMenuItemApplicationsExplorer.setMnemonic('E');
            this.jMenuItemApplicationsExplorer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemApplicationsExplorer.getText();
                    if (!Main.this.containsWindow(string)) {
                        final ChildFrame childFrame = new ChildFrame(Main.this.m_Self, string);
                        childFrame.getContentPane().setLayout(new BorderLayout());
                        childFrame.getContentPane().add((Component)new Explorer(), "Center");
                        childFrame.addInternalFrameListener(new InternalFrameAdapter(){

                            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                                childFrame.dispose();
                            }
                        });
                        childFrame.pack();
                        childFrame.setSize(800, 600);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jMenuItemApplicationsExperimenter = new JMenuItem();
            this.jMenuApplications.add(this.jMenuItemApplicationsExperimenter);
            this.jMenuItemApplicationsExperimenter.setText("Experimenter");
            this.jMenuItemApplicationsExperimenter.setMnemonic('X');
            this.jMenuItemApplicationsExperimenter.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemApplicationsExperimenter.getText();
                    if (!Main.this.containsWindow(string)) {
                        final ChildFrame childFrame = new ChildFrame(Main.this.m_Self, string);
                        childFrame.getContentPane().setLayout(new BorderLayout());
                        childFrame.getContentPane().add((Component)new Experimenter(false), "Center");
                        childFrame.addInternalFrameListener(new InternalFrameAdapter(){

                            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                                childFrame.dispose();
                            }
                        });
                        childFrame.pack();
                        childFrame.setSize(800, 600);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jMenuItemApplicationsKnowledgeFlow = new JMenuItem();
            this.jMenuApplications.add(this.jMenuItemApplicationsKnowledgeFlow);
            this.jMenuItemApplicationsKnowledgeFlow.setText("KnowledgeFlow");
            this.jMenuItemApplicationsKnowledgeFlow.setMnemonic('K');
            this.jMenuItemApplicationsKnowledgeFlow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KnowledgeFlow.startApp();
                }
            });
            KnowledgeFlowApp.addStartupListener(new StartUpListener(){

                public void startUpComplete() {
                    String string = Main.this.jMenuItemApplicationsKnowledgeFlow.getText();
                    if (!Main.this.containsWindow(string)) {
                        final ChildFrame childFrame = new ChildFrame(Main.this.m_Self, string);
                        childFrame.getContentPane().setLayout(new BorderLayout());
                        childFrame.getContentPane().add((Component)KnowledgeFlowApp.getSingleton(), "Center");
                        childFrame.addInternalFrameListener(new InternalFrameAdapter(){

                            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                                childFrame.dispose();
                            }
                        });
                        childFrame.pack();
                        childFrame.setSize(900, 600);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jMenuItemApplicationsSimpleCLI = new JMenuItem();
            this.jMenuApplications.add(this.jMenuItemApplicationsSimpleCLI);
            this.jMenuItemApplicationsSimpleCLI.setText("SimpleCLI");
            this.jMenuItemApplicationsSimpleCLI.setMnemonic('S');
            this.jMenuItemApplicationsSimpleCLI.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemApplicationsSimpleCLI.getText();
                    if (!Main.this.containsWindow(string)) {
                        final ChildFrame childFrame = new ChildFrame(Main.this.m_Self, string);
                        childFrame.getContentPane().setLayout(new BorderLayout());
                        try {
                            childFrame.getContentPane().add((Component)new SimpleCLIPanel(), "Center");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            JOptionPane.showMessageDialog(Main.this.m_Self, "Error instantiating SimpleCLI:\n" + exception.getMessage());
                            return;
                        }
                        childFrame.addInternalFrameListener(new InternalFrameAdapter(){

                            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                                childFrame.dispose();
                            }
                        });
                        childFrame.pack();
                        childFrame.setSize(600, 500);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jMenuTools = new JMenu();
            this.jMenuBar.add(this.jMenuTools);
            this.jMenuTools.setText("Tools");
            this.jMenuTools.setMnemonic('T');
            this.jMenuItemToolsArffViewer = new JMenuItem();
            this.jMenuTools.add(this.jMenuItemToolsArffViewer);
            this.jMenuItemToolsArffViewer.setText("ArffViewer");
            this.jMenuItemToolsArffViewer.setMnemonic('A');
            this.jMenuItemToolsArffViewer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemToolsArffViewer.getText();
                    if (!Main.this.containsWindow(string)) {
                        final ChildFrame childFrame = new ChildFrame(Main.this.m_Self, string);
                        childFrame.getContentPane().setLayout(new BorderLayout());
                        ArffViewerMainPanel arffViewerMainPanel = new ArffViewerMainPanel(childFrame);
                        arffViewerMainPanel.setConfirmExit(false);
                        childFrame.getContentPane().add((Component)arffViewerMainPanel, "Center");
                        childFrame.setJMenuBar(arffViewerMainPanel.getMenu());
                        childFrame.addInternalFrameListener(new InternalFrameAdapter(){

                            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                                childFrame.dispose();
                            }
                        });
                        childFrame.pack();
                        childFrame.setSize(800, 600);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jMenuItemToolsSqlViewer = new JMenuItem();
            this.jMenuTools.add(this.jMenuItemToolsSqlViewer);
            this.jMenuItemToolsSqlViewer.setText("SqlViewer");
            this.jMenuItemToolsSqlViewer.setMnemonic('S');
            this.jMenuItemToolsSqlViewer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemToolsSqlViewer.getText();
                    if (!Main.this.containsWindow(string)) {
                        final ChildFrame childFrame = new ChildFrame(Main.this.m_Self, string);
                        childFrame.getContentPane().setLayout(new BorderLayout());
                        childFrame.getContentPane().add((Component)new SqlViewer(null), "Center");
                        childFrame.addInternalFrameListener(new InternalFrameAdapter(){

                            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                                childFrame.dispose();
                            }
                        });
                        childFrame.pack();
                        childFrame.setSize(800, 600);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jMenuItemToolsEnsembleLibrary = new JMenuItem();
            this.jMenuTools.add(this.jMenuItemToolsEnsembleLibrary);
            this.jMenuItemToolsEnsembleLibrary.setText("EnsembleLibrary");
            this.jMenuItemToolsEnsembleLibrary.setMnemonic('E');
            this.jMenuItemToolsEnsembleLibrary.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemToolsEnsembleLibrary.getText();
                    if (!Main.this.containsWindow(string)) {
                        final ChildFrame childFrame = new ChildFrame(Main.this.m_Self, string);
                        childFrame.getContentPane().setLayout(new BorderLayout());
                        EnsembleLibrary ensembleLibrary = new EnsembleLibrary();
                        EnsembleLibraryEditor ensembleLibraryEditor = new EnsembleLibraryEditor();
                        ensembleLibraryEditor.setValue(ensembleLibrary);
                        childFrame.getContentPane().add(ensembleLibraryEditor.getCustomEditor(), "Center");
                        childFrame.addInternalFrameListener(new InternalFrameAdapter(){

                            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                                childFrame.dispose();
                            }
                        });
                        childFrame.pack();
                        childFrame.setSize(800, 600);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jMenuVisualization = new JMenu();
            this.jMenuBar.add(this.jMenuVisualization);
            this.jMenuVisualization.setText("Visualization");
            this.jMenuVisualization.setMnemonic('V');
            this.jMenuItemVisualizationPlot = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationPlot);
            this.jMenuItemVisualizationPlot.setText("Plot");
            this.jMenuItemVisualizationPlot.setMnemonic('P');
            this.jMenuItemVisualizationPlot.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Main.this.m_FileChooserPlot.showOpenDialog(Main.this.m_Self);
                    if (n != 0) {
                        return;
                    }
                    VisualizePanel visualizePanel = new VisualizePanel();
                    String string = "";
                    File[] fileArray = Main.this.m_FileChooserPlot.getSelectedFiles();
                    for (int i = 0; i < fileArray.length; ++i) {
                        String string2 = fileArray[i].getAbsolutePath();
                        if (i > 0) {
                            string = string + ", ";
                        }
                        string = string + string2;
                        System.err.println("Loading instances from " + string2);
                        try {
                            BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
                            Instances instances = new Instances(bufferedReader);
                            instances.setClassIndex(instances.numAttributes() - 1);
                            PlotData2D plotData2D = new PlotData2D(instances);
                            if (i == 0) {
                                plotData2D.setPlotName("Master plot");
                                visualizePanel.setMasterPlot(plotData2D);
                                continue;
                            }
                            plotData2D.setPlotName("Plot " + (i + 1));
                            plotData2D.m_useCustomColour = true;
                            plotData2D.m_customColour = i % 2 == 0 ? Color.red : Color.blue;
                            visualizePanel.addPlot(plotData2D);
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            JOptionPane.showMessageDialog(Main.this.m_Self, "Error loading file '" + fileArray[i] + "':\n" + exception.getMessage());
                            return;
                        }
                    }
                    final ChildFrame childFrame = new ChildFrame(Main.this.m_Self, Main.this.jMenuItemVisualizationPlot.getText() + " - " + string);
                    childFrame.getContentPane().setLayout(new BorderLayout());
                    childFrame.getContentPane().add((Component)visualizePanel, "Center");
                    childFrame.addInternalFrameListener(new InternalFrameAdapter(){

                        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                            childFrame.dispose();
                        }
                    });
                    childFrame.pack();
                    childFrame.setSize(800, 600);
                }
            });
            this.jMenuItemVisualizationROC = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationROC);
            this.jMenuItemVisualizationROC.setText("ROC");
            this.jMenuItemVisualizationROC.setMnemonic('R');
            this.jMenuItemVisualizationROC.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Main.this.m_FileChooserROC.showOpenDialog(Main.this.m_Self);
                    if (n != 0) {
                        return;
                    }
                    String string = Main.this.m_FileChooserROC.getSelectedFile().getAbsolutePath();
                    Instances instances = null;
                    try {
                        instances = new Instances(new BufferedReader(new FileReader(string)));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(Main.this.m_Self, "Error loading file '" + string + "':\n" + exception.getMessage());
                        return;
                    }
                    instances.setClassIndex(instances.numAttributes() - 1);
                    ThresholdVisualizePanel thresholdVisualizePanel = new ThresholdVisualizePanel();
                    thresholdVisualizePanel.setROCString("(Area under ROC = " + Utils.doubleToString(ThresholdCurve.getROCArea(instances), 4) + ")");
                    thresholdVisualizePanel.setName(instances.relationName());
                    PlotData2D plotData2D = new PlotData2D(instances);
                    plotData2D.setPlotName(instances.relationName());
                    plotData2D.addInstanceNumberAttribute();
                    try {
                        thresholdVisualizePanel.addPlot(plotData2D);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(Main.this.m_Self, "Error adding plot:\n" + exception.getMessage());
                        return;
                    }
                    final ChildFrame childFrame = new ChildFrame(Main.this.m_Self, Main.this.jMenuItemVisualizationROC.getText() + " - " + string);
                    childFrame.getContentPane().setLayout(new BorderLayout());
                    childFrame.getContentPane().add((Component)thresholdVisualizePanel, "Center");
                    childFrame.addInternalFrameListener(new InternalFrameAdapter(){

                        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                            childFrame.dispose();
                        }
                    });
                    childFrame.pack();
                    childFrame.setSize(800, 600);
                }
            });
            this.jMenuItemVisualizationTreeVisualizer = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationTreeVisualizer);
            this.jMenuItemVisualizationTreeVisualizer.setText("TreeVisualizer");
            this.jMenuItemVisualizationTreeVisualizer.setMnemonic('T');
            this.jMenuItemVisualizationTreeVisualizer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Main.this.m_FileChooserTreeVisualizer.showOpenDialog(Main.this.m_Self);
                    if (n != 0) {
                        return;
                    }
                    String string = Main.this.m_FileChooserTreeVisualizer.getSelectedFile().getAbsolutePath();
                    TreeBuild treeBuild = new TreeBuild();
                    Node node = null;
                    PlaceNode2 placeNode2 = new PlaceNode2();
                    try {
                        node = treeBuild.create(new FileReader(string));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(Main.this.m_Self, "Error loading file '" + string + "':\n" + exception.getMessage());
                        return;
                    }
                    final ChildFrame childFrame = new ChildFrame(Main.this.m_Self, Main.this.jMenuItemVisualizationTreeVisualizer.getText() + " - " + string);
                    childFrame.getContentPane().setLayout(new BorderLayout());
                    childFrame.getContentPane().add((Component)new TreeVisualizer(null, node, (NodePlace)placeNode2), "Center");
                    childFrame.addInternalFrameListener(new InternalFrameAdapter(){

                        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                            childFrame.dispose();
                        }
                    });
                    childFrame.pack();
                    childFrame.setSize(800, 600);
                }
            });
            this.jMenuItemVisualizationGraphVisualizer = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationGraphVisualizer);
            this.jMenuItemVisualizationGraphVisualizer.setText("GraphVisualizer");
            this.jMenuItemVisualizationGraphVisualizer.setMnemonic('G');
            this.jMenuItemVisualizationGraphVisualizer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Main.this.m_FileChooserGraphVisualizer.showOpenDialog(Main.this.m_Self);
                    if (n != 0) {
                        return;
                    }
                    String string = Main.this.m_FileChooserGraphVisualizer.getSelectedFile().getAbsolutePath();
                    GraphVisualizer graphVisualizer = new GraphVisualizer();
                    try {
                        if (string.toLowerCase().endsWith(".xml") || string.toLowerCase().endsWith(".bif")) {
                            graphVisualizer.readBIF(new FileInputStream(string));
                        } else {
                            graphVisualizer.readDOT(new FileReader(string));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(Main.this.m_Self, "Error loading file '" + string + "':\n" + exception.getMessage());
                        return;
                    }
                    final ChildFrame childFrame = new ChildFrame(Main.this.m_Self, Main.this.jMenuItemVisualizationGraphVisualizer.getText() + " - " + string);
                    childFrame.getContentPane().setLayout(new BorderLayout());
                    childFrame.getContentPane().add((Component)graphVisualizer, "Center");
                    childFrame.addInternalFrameListener(new InternalFrameAdapter(){

                        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                            childFrame.dispose();
                        }
                    });
                    childFrame.pack();
                    childFrame.setSize(800, 600);
                }
            });
            this.jMenuItemVisualizationBoundaryVisualizer = new JMenuItem();
            this.jMenuVisualization.add(this.jMenuItemVisualizationBoundaryVisualizer);
            this.jMenuItemVisualizationBoundaryVisualizer.setText("BoundaryVisualizer");
            this.jMenuItemVisualizationBoundaryVisualizer.setMnemonic('B');
            this.jMenuItemVisualizationBoundaryVisualizer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemVisualizationBoundaryVisualizer.getText();
                    if (!Main.this.containsWindow(string)) {
                        final ChildFrame childFrame = new ChildFrame(Main.this.m_Self, string);
                        childFrame.getContentPane().setLayout(new BorderLayout());
                        childFrame.getContentPane().add((Component)new BoundaryVisualizer(), "Center");
                        childFrame.addInternalFrameListener(new InternalFrameAdapter(){

                            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                                childFrame.dispose();
                            }
                        });
                        childFrame.pack();
                        childFrame.setSize(800, 600);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jMenuHelp = new JMenu();
            this.jMenuBar.add(this.jMenuHelp);
            this.jMenuHelp.setText("Help");
            this.jMenuHelp.setMnemonic('H');
            this.jMenuItemHelpHomepage = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpHomepage);
            this.jMenuItemHelpHomepage.setText("Weka homepage");
            this.jMenuItemHelpHomepage.setMnemonic('H');
            this.jMenuItemHelpHomepage.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BrowserHelper.openURL(Main.this.m_Self, "http://www.cs.waikato.ac.nz/~ml/weka/");
                }
            });
            this.jSeparatorHelp1 = new JSeparator();
            this.jMenuHelp.add(this.jSeparatorHelp1);
            this.jMenuItemHelpSystemInfo = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpSystemInfo);
            this.jMenuItemHelpSystemInfo.setText("SystemInfo");
            this.jMenuItemHelpHomepage.setMnemonic('S');
            this.jMenuItemHelpSystemInfo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemHelpSystemInfo.getText();
                    if (!Main.this.containsWindow(string)) {
                        final ChildFrame childFrame = new ChildFrame(Main.this.m_Self, string);
                        childFrame.getContentPane().setLayout(new BorderLayout());
                        Hashtable hashtable = new SystemInfo().getSystemInfo();
                        Vector vector = new Vector();
                        Enumeration enumeration = hashtable.keys();
                        while (enumeration.hasMoreElements()) {
                            vector.add(enumeration.nextElement());
                        }
                        Collections.sort(vector);
                        Object[][] objectArray = new String[hashtable.size()][2];
                        for (int i = 0; i < vector.size(); ++i) {
                            objectArray[i][0] = vector.get(i).toString();
                            objectArray[i][1] = hashtable.get(objectArray[i][0]).toString();
                        }
                        Object[] objectArray2 = new String[]{"Key", "Value"};
                        JTable jTable = new JTable(objectArray, objectArray2);
                        childFrame.getContentPane().add((Component)new JScrollPane(jTable), "Center");
                        childFrame.addInternalFrameListener(new InternalFrameAdapter(){

                            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                                childFrame.dispose();
                            }
                        });
                        childFrame.pack();
                        childFrame.setSize(800, 600);
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
            this.jSeparatorHelp2 = new JSeparator();
            this.jMenuHelp.add(this.jSeparatorHelp2);
            this.jMenuItemHelpAbout = new JMenuItem();
            this.jMenuHelp.add(this.jMenuItemHelpAbout);
            this.jMenuItemHelpAbout.setText("About");
            this.jMenuItemHelpAbout.setMnemonic('A');
            this.jMenuItemHelpAbout.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = Main.this.jMenuItemHelpAbout.getText();
                    if (!Main.this.containsWindow(string)) {
                        final ChildFrame childFrame = new ChildFrame(Main.this.m_Self, string);
                        childFrame.getContentPane().setLayout(new BorderLayout());
                        JPanel jPanel = new JPanel();
                        jPanel.setToolTipText("Weka, a native bird of New Zealand");
                        ImageIcon imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/weka3.gif")));
                        JLabel jLabel = new JLabel(imageIcon);
                        jPanel.add(jLabel);
                        childFrame.getContentPane().add((Component)jPanel, "Center");
                        JPanel jPanel2 = new JPanel();
                        jPanel2.setLayout(new GridLayout(8, 1));
                        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
                        jPanel2.add(new JLabel("Waikato Environment for", 0));
                        jPanel2.add(new JLabel("Knowledge Analysis", 0));
                        jPanel2.add(new JLabel(""));
                        jPanel2.add(new JLabel("Version " + Version.VERSION, 0));
                        jPanel2.add(new JLabel(""));
                        jPanel2.add(new JLabel("(c) 1999 - 2005", 0));
                        jPanel2.add(new JLabel("University of Waikato", 0));
                        jPanel2.add(new JLabel("New Zealand", 0));
                        childFrame.getContentPane().add((Component)jPanel2, "North");
                        childFrame.addInternalFrameListener(new InternalFrameAdapter(){

                            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                                childFrame.dispose();
                            }
                        });
                        childFrame.pack();
                    } else {
                        Main.this.showWindow(Main.this.getWindow(string));
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void createTitle(String string) {
        String string2 = "Weka " + new Version();
        if (string.length() != 0) {
            string2 = string2 + " - " + string;
        }
        this.setTitle(string2);
    }

    public void addChildFrame(ChildFrame childFrame) {
        this.m_ChildFrames.add(childFrame);
        this.windowListChanged();
    }

    public boolean removeChildFrame(ChildFrame childFrame) {
        boolean bl = this.m_ChildFrames.remove(childFrame);
        this.windowListChanged();
        return bl;
    }

    public boolean showWindow(ChildFrame childFrame) {
        boolean bl;
        if (childFrame != null) {
            try {
                childFrame.setIcon(false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            childFrame.toFront();
            this.createTitle(childFrame.getTitle());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean showWindow(Class clazz) {
        return this.showWindow(this.getWindow(clazz));
    }

    public Iterator getWindowList() {
        return this.m_ChildFrames.iterator();
    }

    public ChildFrame getWindow(Class clazz) {
        ChildFrame childFrame = null;
        Iterator iterator = this.getWindowList();
        while (iterator.hasNext()) {
            ChildFrame childFrame2 = (ChildFrame)iterator.next();
            if (childFrame2.getClass() != clazz) continue;
            childFrame = childFrame2;
            break;
        }
        return childFrame;
    }

    public ChildFrame getWindow(String string) {
        ChildFrame childFrame = null;
        Iterator iterator = this.getWindowList();
        while (iterator.hasNext()) {
            ChildFrame childFrame2 = (ChildFrame)iterator.next();
            if (!childFrame2.getTitle().equals(string)) continue;
            childFrame = childFrame2;
            break;
        }
        return childFrame;
    }

    public boolean containsWindow(Class clazz) {
        return this.getWindow(clazz) != null;
    }

    public boolean containsWindow(String string) {
        return this.getWindow(string) != null;
    }

    public void minimizeWindows() {
        Iterator iterator = this.getWindowList();
        while (iterator.hasNext()) {
            ChildFrame childFrame = (ChildFrame)iterator.next();
            try {
                childFrame.setIcon(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void restoreWindows() {
        Iterator iterator = this.getWindowList();
        while (iterator.hasNext()) {
            ChildFrame childFrame = (ChildFrame)iterator.next();
            try {
                childFrame.setIcon(false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void windowListChanged() {
        this.createWindowMenu();
    }

    private void createWindowMenu() {
        if (this.jMenuWindows == null) {
            this.jMenuWindows = new JMenu("Windows");
            this.jMenuWindows.setMnemonic(87);
            this.jMenuBar.remove(this.jMenuHelp);
            this.jMenuBar.add(this.jMenuWindows);
            this.jMenuBar.add(this.jMenuHelp);
        }
        this.jMenuWindows.removeAll();
        JMenuItem jMenuItem = new JMenuItem("Minimize");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.minimizeWindows();
            }
        });
        this.jMenuWindows.add(jMenuItem);
        jMenuItem = new JMenuItem("Restore");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.restoreWindows();
            }
        });
        this.jMenuWindows.add(jMenuItem);
        this.jMenuWindows.addSeparator();
        Iterator iterator = this.getWindowList();
        this.jMenuWindows.setVisible(iterator.hasNext());
        while (iterator.hasNext()) {
            ChildFrame childFrame = (ChildFrame)iterator.next();
            jMenuItem = new JMenuItem(childFrame.getTitle());
            this.jMenuWindows.add(jMenuItem);
            jMenuItem.setActionCommand(Integer.toString(childFrame.hashCode()));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ChildFrame childFrame = null;
                    Iterator iterator = Main.this.getWindowList();
                    while (iterator.hasNext()) {
                        childFrame = (ChildFrame)iterator.next();
                        String string = Integer.toString(childFrame.hashCode());
                        if (!string.equals(actionEvent.getActionCommand())) continue;
                        Main.this.showWindow(childFrame);
                        break;
                    }
                    Main.this.showWindow(childFrame);
                }
            });
            this.jMenuWindows.add(jMenuItem);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.paint(this.getGraphics());
        }
    }

    public static void createSingleton(String[] stringArray) {
        if (m_MainSingleton == null) {
            m_MainSingleton = new Main();
        }
        for (int i = 0; i < m_StartupListeners.size(); ++i) {
            ((StartUpListener)m_StartupListeners.elementAt(i)).startUpComplete();
        }
    }

    public static Main getSingleton() {
        return m_MainSingleton;
    }

    public static void addStartupListener(StartUpListener startUpListener) {
        m_StartupListeners.add(startUpListener);
    }

    public static void main(String[] stringArray) {
        LookAndFeel.setLookAndFeel();
        try {
            Main.addStartupListener(new StartUpListener(){

                public void startUpComplete() {
                    m_MainCommandline = Main.getSingleton();
                    m_MainCommandline.setVisible(true);
                }
            });
            Main.addStartupListener(new StartUpListener(){

                public void startUpComplete() {
                    SplashWindow.disposeSplash();
                }
            });
            SplashWindow.splash(ClassLoader.getSystemResource("weka/gui/images/weka_splash.gif"));
            Thread thread = new Thread(){

                public void run() {
                    SplashWindow.invokeMethod("weka.gui.Main", "createSingleton", new String[1]);
                }
            };
            thread.start();
            Thread thread2 = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(4000L);
                                System.gc();
                                if (!m_Memory.isOutOfMemory()) continue;
                                m_MainCommandline = null;
                                System.gc();
                                m_Memory.stopThreads();
                                System.err.println("\ndisplayed message:");
                                m_Memory.showOutOfMemory();
                                System.err.println("\nexiting");
                                System.exit(-1);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            thread2.setPriority(10);
            thread2.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static {
        m_StartupListeners = new Vector();
        m_Memory = new Memory(true);
        m_LogWindow = new LogWindow();
    }

    public static class ChildFrame
    extends JInternalFrame {
        private static final long serialVersionUID = 3772573515346899959L;
        protected Main m_Parent;

        public ChildFrame(Main main, String string) {
            super(string, true, true, true, true);
            this.m_Parent = main;
            this.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                    if (ChildFrame.this.getParentFrame() != null) {
                        ChildFrame.this.getParentFrame().createTitle(ChildFrame.this.getTitle());
                    }
                }
            });
            if (this.getParentFrame() != null) {
                this.getParentFrame().addChildFrame(this);
                this.getParentFrame().jDesktopPane.add(this);
            }
            this.setVisible(true);
            try {
                this.setSelected(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public Main getParentFrame() {
            return this.m_Parent;
        }

        public void dispose() {
            if (this.getParentFrame() != null) {
                this.getParentFrame().removeChildFrame(this);
                this.getParentFrame().createTitle("");
            }
            super.dispose();
        }
    }

    public static class BackgroundDesktopPane
    extends JDesktopPane {
        private static final long serialVersionUID = 2046713123452402745L;
        protected Image m_Background;

        public BackgroundDesktopPane(String string) {
            try {
                this.m_Background = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.m_Background != null) {
                graphics.setColor(Color.WHITE);
                graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                int n = this.m_Background.getWidth(null);
                int n2 = this.m_Background.getHeight(null);
                int n3 = (this.getWidth() - n) / 2;
                int n4 = (this.getHeight() - n2) / 2;
                graphics.drawImage(this.m_Background, n3, n4, n, n2, this);
            }
        }
    }
}

