/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.SingleClassifierEnhancer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;

public class SimpleMI
extends SingleClassifierEnhancer
implements OptionHandler,
MultiInstanceCapabilitiesHandler {
    static final long serialVersionUID = 9137795893666592662L;
    public static final int TRANSFORMMETHOD_ARITHMETIC = 1;
    public static final int TRANSFORMMETHOD_GEOMETRIC = 2;
    public static final int TRANSFORMMETHOD_MINIMAX = 3;
    public static final Tag[] TAGS_TRANSFORMMETHOD = new Tag[]{new Tag(1, "arithmetic average"), new Tag(2, "geometric average"), new Tag(3, "using minimax combined features of a bag")};
    protected int m_TransformMethod = 1;

    public String globalInfo() {
        return "Reduces MI data into mono-instance data.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe method used in transformation:\n\t1.arithmatic average; 2.geometric centor;\n\t3.using minimax combined features of a bag (default: 1)\n\n\tMethod 3:\n\tDefine s to be the vector of the coordinate-wise maxima\n\tand minima of X, ie., \n\ts(X)=(minx1, ..., minxm, maxx1, ...,maxxm), transform\n\tthe exemplars into mono-instance which contains attributes\n\ts(X)", "M", 1, "-M [1|2|3]"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag('D', stringArray));
        String string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setTransformMethod(new SelectedTag(Integer.parseInt(string), TAGS_TRANSFORMMETHOD));
        } else {
            this.setTransformMethod(new SelectedTag(1, TAGS_TRANSFORMMETHOD));
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-M");
        vector.add("" + this.m_TransformMethod);
        return vector.toArray(new String[vector.size()]);
    }

    public String transformMethodTipText() {
        return "The method used in transformation.";
    }

    public void setTransformMethod(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_TRANSFORMMETHOD) {
            this.m_TransformMethod = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getTransformMethod() {
        return new SelectedTag(this.m_TransformMethod, TAGS_TRANSFORMMETHOD);
    }

    public Instances transform(Instances instances) throws Exception {
        Attribute attribute = (Attribute)instances.classAttribute().copy();
        Attribute attribute2 = instances.attribute(0);
        Instances instances2 = instances.attribute(1).relation().stringFreeStructure();
        instances2.insertAttributeAt(attribute2, 0);
        instances2.insertAttributeAt(attribute, instances2.numAttributes());
        instances2.setClassIndex(instances2.numAttributes() - 1);
        Instances instances3 = instances2.stringFreeStructure();
        Instances instances4 = instances2.stringFreeStructure();
        Instance instance = new Instance(instances2.numAttributes());
        Instance instance2 = new Instance(instances3.numAttributes());
        Instance instance3 = new Instance(instances4.numAttributes());
        instance.setDataset(instances2);
        instance2.setDataset(instances3);
        instance3.setDataset(instances4);
        double d = instances.numInstances();
        int n = 0;
        while ((double)n < d) {
            int n2 = 1;
            Instance instance4 = instances.instance(n);
            double d2 = instance4.value(0);
            if (this.m_TransformMethod != 3) {
                instance.setValue(0, d2);
            } else {
                instance2.setValue(0, d2);
                instance3.setValue(0, d2);
            }
            Instances instances5 = instance4.relationalValue(1);
            for (int i = 0; i < instances5.numAttributes(); ++i) {
                double[] dArray;
                double d3;
                if (this.m_TransformMethod == 1) {
                    d3 = instances5.meanOrMode(i);
                    instance.setValue(n2++, d3);
                    continue;
                }
                if (this.m_TransformMethod == 2) {
                    dArray = SimpleMI.minimax(instances5, i);
                    d3 = (dArray[0] + dArray[1]) / 2.0;
                    instance.setValue(n2++, d3);
                    continue;
                }
                dArray = SimpleMI.minimax(instances5, i);
                instance2.setValue(n2, dArray[0]);
                instance3.setValue(n2, dArray[1]);
                ++n2;
            }
            if (this.m_TransformMethod == 3) {
                if (!instance4.classIsMissing()) {
                    instance3.setClassValue(instance4.classValue());
                }
                instances3.add(instance2);
                instances4.add(instance3);
            } else {
                if (!instance4.classIsMissing()) {
                    instance.setClassValue(instance4.classValue());
                }
                instances2.add(instance);
            }
            ++n;
        }
        if (this.m_TransformMethod == 3) {
            instances3.setClassIndex(-1);
            instances3.deleteAttributeAt(instances3.numAttributes() - 1);
            instances4.deleteAttributeAt(0);
            instances2 = Instances.mergeInstances(instances3, instances4);
            instances2.setClassIndex(instances2.numAttributes() - 1);
        }
        return instances2;
    }

    public static double[] minimax(Instances instances, int n) {
        int n2;
        double[] dArray = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
            double d = instances.instance(n2).value(n);
            if (d > dArray[1]) {
                dArray[1] = d;
            }
            if (!(d < dArray[0])) continue;
            dArray[0] = d;
        }
        for (n2 = 0; n2 < 2; ++n2) {
            if (!Double.isInfinite(dArray[n2])) continue;
            dArray[n2] = Double.NaN;
        }
        return dArray;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.disableAllClasses();
        capabilities.disableAllClassDependencies();
        if (super.getCapabilities().handles(Capabilities.Capability.NOMINAL_CLASS)) {
            capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        }
        if (super.getCapabilities().handles(Capabilities.Capability.BINARY_CLASS)) {
            capabilities.enable(Capabilities.Capability.BINARY_CLASS);
        }
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return capabilities;
    }

    public Capabilities getMultiInstanceCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.disableAllClasses();
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (this.m_Classifier == null) {
            throw new Exception("A base classifier has not been specified!");
        }
        if (this.getDebug()) {
            System.out.println("Start training ...");
        }
        Instances instances2 = this.transform(instances);
        instances2.deleteAttributeAt(0);
        this.m_Classifier.buildClassifier(instances2);
        if (this.getDebug()) {
            System.out.println("Finish building model");
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[2];
        Instances instances = new Instances(instance.dataset(), 0);
        instances.add(instance);
        instances = this.transform(instances);
        instances.deleteAttributeAt(0);
        Instance instance2 = instances.firstInstance();
        dArray = this.m_Classifier.distributionForInstance(instance2);
        return dArray;
    }

    public String toString() {
        return "SimpleMI with base classifier: \n" + this.m_Classifier.toString();
    }

    public static void main(String[] stringArray) {
        SimpleMI.runClassifier(new SimpleMI(), stringArray);
    }
}

