/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import weka.classifiers.Classifier;
import weka.classifiers.CostMatrix;
import weka.classifiers.Sourcable;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.classifiers.xml.XMLClassifier;
import weka.core.Drawable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.Summarizable;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;
import weka.core.xml.KOML;
import weka.core.xml.XMLOptions;
import weka.estimators.Estimator;
import weka.estimators.KernelEstimator;

public class Evaluation
implements Summarizable {
    protected int m_NumClasses;
    protected int m_NumFolds;
    protected double m_Incorrect;
    protected double m_Correct;
    protected double m_Unclassified;
    protected double m_MissingClass;
    protected double m_WithClass;
    protected double[][] m_ConfusionMatrix;
    protected String[] m_ClassNames;
    protected boolean m_ClassIsNominal;
    protected double[] m_ClassPriors;
    protected double m_ClassPriorsSum;
    protected CostMatrix m_CostMatrix;
    protected double m_TotalCost;
    protected double m_SumErr;
    protected double m_SumAbsErr;
    protected double m_SumSqrErr;
    protected double m_SumClass;
    protected double m_SumSqrClass;
    protected double m_SumPredicted;
    protected double m_SumSqrPredicted;
    protected double m_SumClassPredicted;
    protected double m_SumPriorAbsErr;
    protected double m_SumPriorSqrErr;
    protected double m_SumKBInfo;
    protected static int k_MarginResolution = 500;
    protected double[] m_MarginCounts;
    protected int m_NumTrainClassVals;
    protected double[] m_TrainClassVals;
    protected double[] m_TrainClassWeights;
    protected Estimator m_PriorErrorEstimator;
    protected Estimator m_ErrorEstimator;
    protected static final double MIN_SF_PROB = Double.MIN_VALUE;
    protected double m_SumPriorEntropy;
    protected double m_SumSchemeEntropy;
    private FastVector m_Predictions;
    protected boolean m_NoPriors = false;

    public Evaluation(Instances instances) throws Exception {
        this(instances, null);
    }

    public Evaluation(Instances instances, CostMatrix costMatrix) throws Exception {
        this.m_NumClasses = instances.numClasses();
        this.m_NumFolds = 1;
        this.m_ClassIsNominal = instances.classAttribute().isNominal();
        if (this.m_ClassIsNominal) {
            this.m_ConfusionMatrix = new double[this.m_NumClasses][this.m_NumClasses];
            this.m_ClassNames = new String[this.m_NumClasses];
            for (int i = 0; i < this.m_NumClasses; ++i) {
                this.m_ClassNames[i] = instances.classAttribute().value(i);
            }
        }
        this.m_CostMatrix = costMatrix;
        if (this.m_CostMatrix != null) {
            if (!this.m_ClassIsNominal) {
                throw new Exception("Class has to be nominal if cost matrix given!");
            }
            if (this.m_CostMatrix.size() != this.m_NumClasses) {
                throw new Exception("Cost matrix not compatible with data!");
            }
        }
        this.m_ClassPriors = new double[this.m_NumClasses];
        this.setPriors(instances);
        this.m_MarginCounts = new double[k_MarginResolution + 1];
    }

    public double areaUnderROC(int n) {
        if (this.m_Predictions == null) {
            return Instance.missingValue();
        }
        ThresholdCurve thresholdCurve = new ThresholdCurve();
        Instances instances = thresholdCurve.getCurve(this.m_Predictions, n);
        return ThresholdCurve.getROCArea(instances);
    }

    public double[][] confusionMatrix() {
        double[][] dArray = new double[this.m_ConfusionMatrix.length][0];
        for (int i = 0; i < this.m_ConfusionMatrix.length; ++i) {
            dArray[i] = new double[this.m_ConfusionMatrix[i].length];
            System.arraycopy(this.m_ConfusionMatrix[i], 0, dArray[i], 0, this.m_ConfusionMatrix[i].length);
        }
        return dArray;
    }

    public void crossValidateModel(Classifier classifier, Instances instances, int n, Random random) throws Exception {
        instances = new Instances(instances);
        instances.randomize(random);
        if (instances.classAttribute().isNominal()) {
            instances.stratify(n);
        }
        for (int i = 0; i < n; ++i) {
            Instances instances2 = instances.trainCV(n, i, random);
            this.setPriors(instances2);
            Classifier classifier2 = Classifier.makeCopy(classifier);
            classifier2.buildClassifier(instances2);
            Instances instances3 = instances.testCV(n, i);
            this.evaluateModel(classifier2, instances3);
        }
        this.m_NumFolds = n;
    }

    public void crossValidateModel(String string, Instances instances, int n, String[] stringArray, Random random) throws Exception {
        this.crossValidateModel(Classifier.forName(string, stringArray), instances, n, random);
    }

    public static String evaluateModel(String string, String[] stringArray) throws Exception {
        Classifier classifier;
        try {
            classifier = (Classifier)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new Exception("Can't find class with name " + string + '.');
        }
        return Evaluation.evaluateModel(classifier, stringArray);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                throw new Exception("The first argument must be the class name of a classifier");
            }
            String string = stringArray[0];
            stringArray[0] = "";
            System.out.println(Evaluation.evaluateModel(string, stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    public static String evaluateModel(Classifier classifier, String[] stringArray) throws Exception {
        Object object;
        String string;
        String string2;
        String string3;
        Object object2;
        Instances instances = null;
        Instances instances2 = null;
        Instances instances3 = null;
        int n = 1;
        int n2 = 10;
        int n3 = -1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        StringBuffer stringBuffer = new StringBuffer();
        ConverterUtils.DataSource dataSource = null;
        ConverterUtils.DataSource dataSource2 = null;
        ObjectInputStream objectInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        CostMatrix costMatrix = null;
        StringBuffer stringBuffer2 = null;
        Range range = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        String string4 = "";
        String[] stringArray2 = null;
        Classifier classifier2 = null;
        boolean bl10 = false;
        int n4 = -1;
        String string5 = "";
        int n5 = -1;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        if (Utils.getFlag("h", stringArray) || Utils.getFlag("help", stringArray)) {
            throw new Exception("\nHelp requested." + Evaluation.makeOptionString(classifier));
        }
        try {
            String string6;
            String string7;
            string4 = Utils.getOption("xml", stringArray);
            if (!string4.equals("")) {
                stringArray = new XMLOptions(string4).toArray();
            }
            stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i];
            }
            if (Utils.getOption('l', stringArray2).toLowerCase().endsWith(".xml")) {
                XMLClassifier xMLClassifier = new XMLClassifier();
                object2 = (Classifier)xMLClassifier.read(Utils.getOption('l', stringArray));
                stringArray2 = new String[stringArray.length + ((Classifier)object2).getOptions().length];
                System.arraycopy(((Classifier)object2).getOptions(), 0, stringArray2, 0, ((Classifier)object2).getOptions().length);
                System.arraycopy(stringArray, 0, stringArray2, ((Classifier)object2).getOptions().length, stringArray.length);
                stringArray = stringArray2;
            }
            bl = Utils.getFlag("no-cv", stringArray);
            String string8 = Utils.getOption('c', stringArray);
            if (string8.length() != 0) {
                n3 = string8.equals("first") ? 1 : (string8.equals("last") ? -1 : Integer.parseInt(string8));
            }
            String string9 = Utils.getOption('t', stringArray);
            string3 = Utils.getOption('l', stringArray);
            string2 = Utils.getOption('d', stringArray);
            String string10 = Utils.getOption('T', stringArray);
            if (string9.length() == 0) {
                if (string3.length() == 0) {
                    throw new Exception("No training file and no object input file given.");
                }
                if (string10.length() == 0) {
                    throw new Exception("No training file and no test file given.");
                }
            } else if (!(string3.length() == 0 || classifier instanceof UpdateableClassifier && string10.length() != 0)) {
                throw new Exception("Classifier not incremental, or no test file provided: can't use both train and model file.");
            }
            try {
                if (string9.length() != 0) {
                    bl12 = true;
                    dataSource = new ConverterUtils.DataSource(string9);
                }
                if (string10.length() != 0) {
                    bl13 = true;
                    dataSource2 = new ConverterUtils.DataSource(string10);
                }
                if (string3.length() != 0) {
                    InputStream inputStream = new FileInputStream(string3);
                    if (string3.endsWith(".gz")) {
                        inputStream = new GZIPInputStream(inputStream);
                    }
                    if (!string3.endsWith(".koml") || !KOML.isPresent()) {
                        objectInputStream = new ObjectInputStream(inputStream);
                        bufferedInputStream = null;
                    } else {
                        objectInputStream = null;
                        bufferedInputStream = new BufferedInputStream(inputStream);
                    }
                }
            }
            catch (Exception exception) {
                throw new Exception("Can't open file " + exception.getMessage() + '.');
            }
            if (bl13) {
                instances3 = instances2 = dataSource2.getStructure();
                if (n3 != -1) {
                    instances2.setClassIndex(n3 - 1);
                } else if (instances2.classIndex() == -1 || string8.length() != 0) {
                    instances2.setClassIndex(instances2.numAttributes() - 1);
                }
                n4 = instances2.classIndex();
            }
            if (bl12) {
                instances3 = instances = dataSource.getStructure();
                if (n3 != -1) {
                    instances.setClassIndex(n3 - 1);
                } else if (instances.classIndex() == -1 || string8.length() != 0) {
                    instances.setClassIndex(instances.numAttributes() - 1);
                }
                n4 = instances.classIndex();
                if (bl13 && !instances2.equalHeaders(instances)) {
                    throw new IllegalArgumentException("Train and test file not compatible!");
                }
            }
            if (instances3 == null) {
                throw new Exception("No actual dataset provided to use as template");
            }
            String string11 = Utils.getOption('s', stringArray);
            if (string11.length() != 0) {
                n = Integer.parseInt(string11);
            }
            if ((string7 = Utils.getOption('x', stringArray)).length() != 0) {
                n2 = Integer.parseInt(string7);
            }
            costMatrix = Evaluation.handleCostOption(Utils.getOption('m', stringArray), instances3.numClasses());
            bl8 = Utils.getFlag('i', stringArray);
            bl2 = Utils.getFlag('o', stringArray);
            bl4 = !Utils.getFlag('v', stringArray);
            bl6 = Utils.getFlag('k', stringArray);
            bl5 = Utils.getFlag('r', stringArray);
            bl7 = Utils.getFlag('g', stringArray);
            string = Utils.getOption('z', stringArray);
            bl9 = string.length() != 0;
            bl10 = Utils.getFlag("distribution", stringArray);
            string5 = Utils.getOption("split-percentage", stringArray);
            if (string5.length() != 0) {
                if (string7.length() != 0) {
                    throw new Exception("Percentage split cannot be used in conjunction with cross-validation ('-x').");
                }
                n5 = Integer.parseInt(string5);
                if (n5 <= 0 || n5 >= 100) {
                    throw new Exception("Percentage split value needs be >0 and <100.");
                }
            } else {
                n5 = -1;
            }
            if ((bl11 = Utils.getFlag("preserve-order", stringArray)) && n5 == -1) {
                throw new Exception("Percentage split ('-percentage-split') is missing.");
            }
            if (n5 > 0) {
                bl13 = true;
            }
            try {
                string6 = Utils.getOption('p', stringArray);
            }
            catch (Exception exception) {
                throw new Exception(exception.getMessage() + "\nNOTE: the -p option has changed. " + "It now expects a parameter specifying a range of attributes " + "to list with the predictions. Use '-p 0' for none.");
            }
            if (string6.length() != 0) {
                bl3 = true;
                if (!string6.equals("0")) {
                    range = new Range(string6);
                }
            }
            if (!bl3 && bl10) {
                throw new Exception("Cannot print distribution without '-p' option!");
            }
            if (!bl12 && bl6) {
                throw new Exception("Cannot print complexity statistics ('-k') without training file ('-t')!");
            }
            if (string3.length() != 0) {
                Utils.checkForRemainingOptions(stringArray);
            } else if (classifier instanceof OptionHandler) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].length() == 0) continue;
                    if (stringBuffer2 == null) {
                        stringBuffer2 = new StringBuffer();
                    }
                    if (stringArray[i].indexOf(32) != -1) {
                        stringBuffer2.append('\"' + stringArray[i] + "\" ");
                        continue;
                    }
                    stringBuffer2.append(stringArray[i] + " ");
                }
                classifier.setOptions(stringArray);
            }
            Utils.checkForRemainingOptions(stringArray);
        }
        catch (Exception exception) {
            throw new Exception("\nWeka exception: " + exception.getMessage() + Evaluation.makeOptionString(classifier));
        }
        Evaluation evaluation = new Evaluation(new Instances(instances3, 0), costMatrix);
        object2 = new Evaluation(new Instances(instances3, 0), costMatrix);
        if (!bl12) {
            ((Evaluation)object2).useNoPriors();
        }
        if (string3.length() != 0) {
            if (objectInputStream != null) {
                classifier = (Classifier)objectInputStream.readObject();
                objectInputStream.close();
            } else {
                classifier = (Classifier)KOML.read(bufferedInputStream);
                bufferedInputStream.close();
            }
        }
        Classifier classifier3 = Classifier.makeCopy(classifier);
        if (classifier instanceof UpdateableClassifier && bl13 && costMatrix == null && bl12) {
            evaluation.setPriors(instances);
            ((Evaluation)object2).setPriors(instances);
            l = System.currentTimeMillis();
            if (string3.length() == 0) {
                classifier.buildClassifier(instances);
            }
            while (dataSource.hasMoreElements()) {
                object = dataSource.nextElement(instances);
                evaluation.updatePriors((Instance)object);
                ((Evaluation)object2).updatePriors((Instance)object);
                ((UpdateableClassifier)((Object)classifier)).updateClassifier((Instance)object);
            }
            l2 = System.currentTimeMillis() - l;
        } else if (string3.length() == 0) {
            Instances instances4 = dataSource.getDataSet(n4);
            evaluation.setPriors(instances4);
            ((Evaluation)object2).setPriors(instances4);
            l = System.currentTimeMillis();
            classifier.buildClassifier(instances4);
            l2 = System.currentTimeMillis() - l;
        }
        if (bl3) {
            classifier2 = Classifier.makeCopy(classifier);
        }
        if (string2.length() != 0) {
            OutputStream outputStream;
            object = new FileOutputStream(string2);
            if (!(string2.endsWith(".xml") || string2.endsWith(".koml") && KOML.isPresent())) {
                if (string2.endsWith(".gz")) {
                    object = new GZIPOutputStream((OutputStream)object);
                }
                outputStream = new ObjectOutputStream((OutputStream)object);
                ((ObjectOutputStream)outputStream).writeObject(classifier);
                ((ObjectOutputStream)outputStream).flush();
                ((ObjectOutputStream)outputStream).close();
            } else {
                outputStream = new BufferedOutputStream((OutputStream)object);
                if (string2.endsWith(".xml")) {
                    XMLClassifier xMLClassifier = new XMLClassifier();
                    xMLClassifier.write(outputStream, (Object)classifier);
                } else if (string2.endsWith(".koml")) {
                    KOML.write(outputStream, (Object)classifier);
                }
                ((FilterOutputStream)outputStream).close();
            }
        }
        if (classifier instanceof Drawable && bl7) {
            return ((Drawable)((Object)classifier)).graph();
        }
        if (classifier instanceof Sourcable && bl9) {
            return Evaluation.wekaStaticWrapper((Sourcable)((Object)classifier), string);
        }
        if (!bl2 && !bl5) {
            if (classifier instanceof OptionHandler && stringBuffer2 != null) {
                stringBuffer.append("\nOptions: " + stringBuffer2);
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n" + classifier.toString() + "\n");
        }
        if (!bl5 && costMatrix != null) {
            stringBuffer.append("\n=== Evaluation Cost Matrix ===\n\n");
            stringBuffer.append(costMatrix.toString());
        }
        if (n5 > 0) {
            object = dataSource.getDataSet(n4);
            if (!bl11) {
                ((Instances)object).randomize(new Random(n));
            }
            int n6 = ((Instances)object).numInstances() * n5 / 100;
            int n7 = ((Instances)object).numInstances() - n6;
            Instances instances5 = new Instances((Instances)object, 0, n6);
            Instances instances6 = new Instances((Instances)object, n6, n7);
            dataSource = new ConverterUtils.DataSource(instances5);
            dataSource2 = new ConverterUtils.DataSource(instances6);
            instances = dataSource.getDataSet(n4);
            instances2 = dataSource2.getDataSet(n4);
            evaluation.setPriors(instances);
            ((Evaluation)object2).setPriors(instances);
            classifier = Classifier.makeCopy(classifier3);
            classifier.buildClassifier(instances);
            if (bl3) {
                classifier2 = Classifier.makeCopy(classifier);
            }
        }
        if (bl3) {
            object = dataSource2;
            if (object == null) {
                object = dataSource;
            }
            return Evaluation.printClassifications(classifier2, new Instances(instances3, 0), (ConverterUtils.DataSource)object, n4 + 1, range, bl10);
        }
        if (bl4 && bl12) {
            if (classifier instanceof UpdateableClassifier && bl13 && costMatrix == null) {
                dataSource.reset();
                instances = dataSource.getStructure(n4);
                l3 = System.currentTimeMillis();
                while (dataSource.hasMoreElements()) {
                    object = dataSource.nextElement(instances);
                    evaluation.evaluateModelOnce(classifier, (Instance)object);
                }
                l4 = System.currentTimeMillis() - l3;
            } else {
                l3 = System.currentTimeMillis();
                evaluation.evaluateModel(classifier, dataSource.getDataSet(n4));
                l4 = System.currentTimeMillis() - l3;
            }
            if (bl5) {
                return evaluation.toCumulativeMarginDistributionString();
            }
            stringBuffer.append("\nTime taken to build model: " + Utils.doubleToString((double)l2 / 1000.0, 2) + " seconds");
            if (n5 > 0) {
                stringBuffer.append("\nTime taken to test model on training split: ");
            } else {
                stringBuffer.append("\nTime taken to test model on training data: ");
            }
            stringBuffer.append(Utils.doubleToString((double)l4 / 1000.0, 2) + " seconds");
            if (n5 > 0) {
                stringBuffer.append(evaluation.toSummaryString("\n\n=== Error on training split ===\n", bl6));
            } else {
                stringBuffer.append(evaluation.toSummaryString("\n\n=== Error on training data ===\n", bl6));
            }
            if (instances3.classAttribute().isNominal()) {
                if (bl8) {
                    stringBuffer.append("\n\n" + evaluation.toClassDetailsString());
                }
                stringBuffer.append("\n\n" + evaluation.toMatrixString());
            }
        }
        if (dataSource2 != null) {
            while (dataSource2.hasMoreElements()) {
                object = dataSource2.nextElement(instances2);
                ((Evaluation)object2).evaluateModelOnceAndRecordPrediction(classifier, (Instance)object);
            }
            if (n5 > 0) {
                stringBuffer.append("\n\n" + ((Evaluation)object2).toSummaryString("=== Error on test split ===\n", bl6));
            } else {
                stringBuffer.append("\n\n" + ((Evaluation)object2).toSummaryString("=== Error on test data ===\n", bl6));
            }
        } else if (dataSource != null && !bl) {
            object = new Random(n);
            classifier = Classifier.makeCopy(classifier3);
            ((Evaluation)object2).crossValidateModel(classifier, dataSource.getDataSet(n4), n2, (Random)object);
            if (instances3.classAttribute().isNumeric()) {
                stringBuffer.append("\n\n\n" + ((Evaluation)object2).toSummaryString("=== Cross-validation ===\n", bl6));
            } else {
                stringBuffer.append("\n\n\n" + ((Evaluation)object2).toSummaryString("=== Stratified cross-validation ===\n", bl6));
            }
        }
        if (instances3.classAttribute().isNominal()) {
            if (bl8) {
                stringBuffer.append("\n\n" + ((Evaluation)object2).toClassDetailsString());
            }
            stringBuffer.append("\n\n" + ((Evaluation)object2).toMatrixString());
        }
        return stringBuffer.toString();
    }

    protected static CostMatrix handleCostOption(String string, int n) throws Exception {
        if (string != null && string.length() != 0) {
            System.out.println("NOTE: The behaviour of the -m option has changed between WEKA 3.0 and WEKA 3.1. -m now carries out cost-sensitive *evaluation* only. For cost-sensitive *prediction*, use one of the cost-sensitive metaschemes such as weka.classifiers.meta.CostSensitiveClassifier or weka.classifiers.meta.MetaCost");
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(string));
            }
            catch (Exception exception) {
                throw new Exception("Can't open file " + exception.getMessage() + '.');
            }
            try {
                return new CostMatrix(bufferedReader);
            }
            catch (Exception exception) {
                try {
                    try {
                        ((Reader)bufferedReader).close();
                        bufferedReader = new BufferedReader(new FileReader(string));
                    }
                    catch (Exception exception2) {
                        throw new Exception("Can't open file " + exception2.getMessage() + '.');
                    }
                    CostMatrix costMatrix = new CostMatrix(n);
                    costMatrix.readOldFormat(bufferedReader);
                    return costMatrix;
                }
                catch (Exception exception3) {
                    throw exception;
                }
            }
        }
        return null;
    }

    public double[] evaluateModel(Classifier classifier, Instances instances) throws Exception {
        double[] dArray = new double[instances.numInstances()];
        for (int i = 0; i < instances.numInstances(); ++i) {
            dArray[i] = this.evaluateModelOnceAndRecordPrediction(classifier, instances.instance(i));
        }
        return dArray;
    }

    public double evaluateModelOnceAndRecordPrediction(Classifier classifier, Instance instance) throws Exception {
        Instance instance2 = (Instance)instance.copy();
        double d = 0.0;
        instance2.setDataset(instance.dataset());
        instance2.setClassMissing();
        if (this.m_ClassIsNominal) {
            double[] dArray;
            if (this.m_Predictions == null) {
                this.m_Predictions = new FastVector();
            }
            if ((dArray = classifier.distributionForInstance(instance2))[(int)(d = (double)Utils.maxIndex(dArray))] <= 0.0) {
                d = Instance.missingValue();
            }
            this.updateStatsForClassifier(dArray, instance);
            this.m_Predictions.addElement(new NominalPrediction(instance.classValue(), dArray, instance.weight()));
        } else {
            d = classifier.classifyInstance(instance2);
            this.updateStatsForPredictor(d, instance);
        }
        return d;
    }

    public double evaluateModelOnce(Classifier classifier, Instance instance) throws Exception {
        Instance instance2 = (Instance)instance.copy();
        double d = 0.0;
        instance2.setDataset(instance.dataset());
        instance2.setClassMissing();
        if (this.m_ClassIsNominal) {
            double[] dArray = classifier.distributionForInstance(instance2);
            if (dArray[(int)(d = (double)Utils.maxIndex(dArray))] <= 0.0) {
                d = Instance.missingValue();
            }
            this.updateStatsForClassifier(dArray, instance);
        } else {
            d = classifier.classifyInstance(instance2);
            this.updateStatsForPredictor(d, instance);
        }
        return d;
    }

    public double evaluateModelOnce(double[] dArray, Instance instance) throws Exception {
        double d;
        if (this.m_ClassIsNominal) {
            d = Utils.maxIndex(dArray);
            if (dArray[(int)d] <= 0.0) {
                d = Instance.missingValue();
            }
            this.updateStatsForClassifier(dArray, instance);
        } else {
            d = dArray[0];
            this.updateStatsForPredictor(d, instance);
        }
        return d;
    }

    public double evaluateModelOnceAndRecordPrediction(double[] dArray, Instance instance) throws Exception {
        double d;
        if (this.m_ClassIsNominal) {
            if (this.m_Predictions == null) {
                this.m_Predictions = new FastVector();
            }
            if (dArray[(int)(d = (double)Utils.maxIndex(dArray))] <= 0.0) {
                d = Instance.missingValue();
            }
            this.updateStatsForClassifier(dArray, instance);
            this.m_Predictions.addElement(new NominalPrediction(instance.classValue(), dArray, instance.weight()));
        } else {
            d = dArray[0];
            this.updateStatsForPredictor(d, instance);
        }
        return d;
    }

    public void evaluateModelOnce(double d, Instance instance) throws Exception {
        if (this.m_ClassIsNominal) {
            this.updateStatsForClassifier(this.makeDistribution(d), instance);
        } else {
            this.updateStatsForPredictor(d, instance);
        }
    }

    public FastVector predictions() {
        return this.m_Predictions;
    }

    protected static String wekaStaticWrapper(Sourcable sourcable, String string) throws Exception {
        String string2 = sourcable.toSource(string);
        return "package weka.classifiers;\n\nimport weka.core.Attribute;\nimport weka.core.Instance;\nimport weka.core.Instances;\nimport weka.classifiers.Classifier;\n\npublic class WekaWrapper extends Classifier {\n\n  public void buildClassifier(Instances i) throws Exception {\n  }\n\n  public double classifyInstance(Instance i) throws Exception {\n\n    Object [] s = new Object [i.numAttributes()];\n    for (int j = 0; j < s.length; j++) {\n      if (!i.isMissing(j)) {\n        if (i.attribute(j).type() == Attribute.NOMINAL) {\n          s[j] = i.attribute(j).value((int) i.value(j));\n        } else if (i.attribute(j).type() == Attribute.NUMERIC) {\n          s[j] = new Double(i.value(j));\n        }\n      }\n    }\n    return " + string + ".classify(s);\n" + "  }\n\n" + "}\n\n" + string2;
    }

    public final double numInstances() {
        return this.m_WithClass;
    }

    public final double incorrect() {
        return this.m_Incorrect;
    }

    public final double pctIncorrect() {
        return 100.0 * this.m_Incorrect / this.m_WithClass;
    }

    public final double totalCost() {
        return this.m_TotalCost;
    }

    public final double avgCost() {
        return this.m_TotalCost / this.m_WithClass;
    }

    public final double correct() {
        return this.m_Correct;
    }

    public final double pctCorrect() {
        return 100.0 * this.m_Correct / this.m_WithClass;
    }

    public final double unclassified() {
        return this.m_Unclassified;
    }

    public final double pctUnclassified() {
        return 100.0 * this.m_Unclassified / this.m_WithClass;
    }

    public final double errorRate() {
        if (!this.m_ClassIsNominal) {
            return Math.sqrt(this.m_SumSqrErr / this.m_WithClass);
        }
        if (this.m_CostMatrix == null) {
            return this.m_Incorrect / this.m_WithClass;
        }
        return this.avgCost();
    }

    public final double kappa() {
        double[] dArray = new double[this.m_ConfusionMatrix.length];
        double[] dArray2 = new double[this.m_ConfusionMatrix.length];
        double d = 0.0;
        for (int i = 0; i < this.m_ConfusionMatrix.length; ++i) {
            for (int j = 0; j < this.m_ConfusionMatrix.length; ++j) {
                int n = i;
                dArray[n] = dArray[n] + this.m_ConfusionMatrix[i][j];
                int n2 = j;
                dArray2[n2] = dArray2[n2] + this.m_ConfusionMatrix[i][j];
                d += this.m_ConfusionMatrix[i][j];
            }
        }
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.m_ConfusionMatrix.length; ++i) {
            d3 += dArray[i] * dArray2[i];
            d2 += this.m_ConfusionMatrix[i][i];
        }
        d3 /= d * d;
        d2 /= d;
        if (d3 < 1.0) {
            return (d2 - d3) / (1.0 - d3);
        }
        return 1.0;
    }

    public final double correlationCoefficient() throws Exception {
        if (this.m_ClassIsNominal) {
            throw new Exception("Can't compute correlation coefficient: class is nominal!");
        }
        double d = 0.0;
        double d2 = this.m_SumSqrClass - this.m_SumClass * this.m_SumClass / this.m_WithClass;
        double d3 = this.m_SumSqrPredicted - this.m_SumPredicted * this.m_SumPredicted / this.m_WithClass;
        double d4 = this.m_SumClassPredicted - this.m_SumClass * this.m_SumPredicted / this.m_WithClass;
        d = d2 * d3 <= 0.0 ? 0.0 : d4 / Math.sqrt(d2 * d3);
        return d;
    }

    public final double meanAbsoluteError() {
        return this.m_SumAbsErr / this.m_WithClass;
    }

    public final double meanPriorAbsoluteError() {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return this.m_SumPriorAbsErr / this.m_WithClass;
    }

    public final double relativeAbsoluteError() throws Exception {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return 100.0 * this.meanAbsoluteError() / this.meanPriorAbsoluteError();
    }

    public final double rootMeanSquaredError() {
        return Math.sqrt(this.m_SumSqrErr / this.m_WithClass);
    }

    public final double rootMeanPriorSquaredError() {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return Math.sqrt(this.m_SumPriorSqrErr / this.m_WithClass);
    }

    public final double rootRelativeSquaredError() {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return 100.0 * this.rootMeanSquaredError() / this.rootMeanPriorSquaredError();
    }

    public final double priorEntropy() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute entropy of class prior: class numeric!");
        }
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        double d = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            d -= this.m_ClassPriors[i] / this.m_ClassPriorsSum * Utils.log2(this.m_ClassPriors[i] / this.m_ClassPriorsSum);
        }
        return d;
    }

    public final double KBInformation() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute K&B Info score: class numeric!");
        }
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return this.m_SumKBInfo;
    }

    public final double KBMeanInformation() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute K&B Info score: class numeric!");
        }
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return this.m_SumKBInfo / this.m_WithClass;
    }

    public final double KBRelativeInformation() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute K&B Info score: class numeric!");
        }
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return 100.0 * this.KBInformation() / this.priorEntropy();
    }

    public final double SFPriorEntropy() {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return this.m_SumPriorEntropy;
    }

    public final double SFMeanPriorEntropy() {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return this.m_SumPriorEntropy / this.m_WithClass;
    }

    public final double SFSchemeEntropy() {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return this.m_SumSchemeEntropy;
    }

    public final double SFMeanSchemeEntropy() {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return this.m_SumSchemeEntropy / this.m_WithClass;
    }

    public final double SFEntropyGain() {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return this.m_SumPriorEntropy - this.m_SumSchemeEntropy;
    }

    public final double SFMeanEntropyGain() {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return (this.m_SumPriorEntropy - this.m_SumSchemeEntropy) / this.m_WithClass;
    }

    public String toCumulativeMarginDistributionString() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Class must be nominal for margin distributions");
        }
        String string = "";
        double d = 0.0;
        for (int i = 0; i <= k_MarginResolution; ++i) {
            if (this.m_MarginCounts[i] != 0.0) {
                double d2 = (double)i * 2.0 / (double)k_MarginResolution - 1.0;
                string = string + Utils.doubleToString(d2, 7, 3) + ' ' + Utils.doubleToString((d += this.m_MarginCounts[i]) * 100.0 / this.m_WithClass, 7, 3) + '\n';
                continue;
            }
            if (i != 0) continue;
            string = Utils.doubleToString(-1.0, 7, 3) + ' ' + Utils.doubleToString(0.0, 7, 3) + '\n';
        }
        return string;
    }

    public String toSummaryString() {
        return this.toSummaryString("", false);
    }

    public String toSummaryString(boolean bl) {
        return this.toSummaryString("=== Summary ===\n", bl);
    }

    public String toSummaryString(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl && this.m_NoPriors) {
            bl = false;
            System.err.println("Priors disabled, cannot print complexity statistics!");
        }
        stringBuffer.append(string + "\n");
        try {
            if (this.m_WithClass > 0.0) {
                if (this.m_ClassIsNominal) {
                    stringBuffer.append("Correctly Classified Instances     ");
                    stringBuffer.append(Utils.doubleToString(this.correct(), 12, 4) + "     " + Utils.doubleToString(this.pctCorrect(), 12, 4) + " %\n");
                    stringBuffer.append("Incorrectly Classified Instances   ");
                    stringBuffer.append(Utils.doubleToString(this.incorrect(), 12, 4) + "     " + Utils.doubleToString(this.pctIncorrect(), 12, 4) + " %\n");
                    stringBuffer.append("Kappa statistic                    ");
                    stringBuffer.append(Utils.doubleToString(this.kappa(), 12, 4) + "\n");
                    if (this.m_CostMatrix != null) {
                        stringBuffer.append("Total Cost                         ");
                        stringBuffer.append(Utils.doubleToString(this.totalCost(), 12, 4) + "\n");
                        stringBuffer.append("Average Cost                       ");
                        stringBuffer.append(Utils.doubleToString(this.avgCost(), 12, 4) + "\n");
                    }
                    if (bl) {
                        stringBuffer.append("K&B Relative Info Score            ");
                        stringBuffer.append(Utils.doubleToString(this.KBRelativeInformation(), 12, 4) + " %\n");
                        stringBuffer.append("K&B Information Score              ");
                        stringBuffer.append(Utils.doubleToString(this.KBInformation(), 12, 4) + " bits");
                        stringBuffer.append(Utils.doubleToString(this.KBMeanInformation(), 12, 4) + " bits/instance\n");
                    }
                } else {
                    stringBuffer.append("Correlation coefficient            ");
                    stringBuffer.append(Utils.doubleToString(this.correlationCoefficient(), 12, 4) + "\n");
                }
                if (bl) {
                    stringBuffer.append("Class complexity | order 0         ");
                    stringBuffer.append(Utils.doubleToString(this.SFPriorEntropy(), 12, 4) + " bits");
                    stringBuffer.append(Utils.doubleToString(this.SFMeanPriorEntropy(), 12, 4) + " bits/instance\n");
                    stringBuffer.append("Class complexity | scheme          ");
                    stringBuffer.append(Utils.doubleToString(this.SFSchemeEntropy(), 12, 4) + " bits");
                    stringBuffer.append(Utils.doubleToString(this.SFMeanSchemeEntropy(), 12, 4) + " bits/instance\n");
                    stringBuffer.append("Complexity improvement     (Sf)    ");
                    stringBuffer.append(Utils.doubleToString(this.SFEntropyGain(), 12, 4) + " bits");
                    stringBuffer.append(Utils.doubleToString(this.SFMeanEntropyGain(), 12, 4) + " bits/instance\n");
                }
                stringBuffer.append("Mean absolute error                ");
                stringBuffer.append(Utils.doubleToString(this.meanAbsoluteError(), 12, 4) + "\n");
                stringBuffer.append("Root mean squared error            ");
                stringBuffer.append(Utils.doubleToString(this.rootMeanSquaredError(), 12, 4) + "\n");
                if (!this.m_NoPriors) {
                    stringBuffer.append("Relative absolute error            ");
                    stringBuffer.append(Utils.doubleToString(this.relativeAbsoluteError(), 12, 4) + " %\n");
                    stringBuffer.append("Root relative squared error        ");
                    stringBuffer.append(Utils.doubleToString(this.rootRelativeSquaredError(), 12, 4) + " %\n");
                }
            }
            if (Utils.gr(this.unclassified(), 0.0)) {
                stringBuffer.append("UnClassified Instances             ");
                stringBuffer.append(Utils.doubleToString(this.unclassified(), 12, 4) + "     " + Utils.doubleToString(this.pctUnclassified(), 12, 4) + " %\n");
            }
            stringBuffer.append("Total Number of Instances          ");
            stringBuffer.append(Utils.doubleToString(this.m_WithClass, 12, 4) + "\n");
            if (this.m_MissingClass > 0.0) {
                stringBuffer.append("Ignored Class Unknown Instances            ");
                stringBuffer.append(Utils.doubleToString(this.m_MissingClass, 12, 4) + "\n");
            }
        }
        catch (Exception exception) {
            System.err.println("Arggh - Must be a bug in Evaluation class");
        }
        return stringBuffer.toString();
    }

    public String toMatrixString() throws Exception {
        return this.toMatrixString("=== Confusion Matrix ===\n");
    }

    public String toMatrixString(String string) throws Exception {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        boolean bl = false;
        if (!this.m_ClassIsNominal) {
            throw new Exception("Evaluation: No confusion matrix possible!");
        }
        double d = 0.0;
        for (n2 = 0; n2 < this.m_NumClasses; ++n2) {
            for (n = 0; n < this.m_NumClasses; ++n) {
                double d2 = this.m_ConfusionMatrix[n2][n];
                if (d2 < 0.0) {
                    d2 *= -10.0;
                }
                if (d2 > d) {
                    d = d2;
                }
                double d3 = d2 - Math.rint(d2);
                if (bl || !(Math.log(d3) / Math.log(10.0) >= -2.0)) continue;
                bl = true;
            }
        }
        int n3 = 1 + Math.max((int)(Math.log(d) / Math.log(10.0) + (double)(bl ? 3 : 0)), (int)(Math.log(this.m_NumClasses) / Math.log(cArray.length)));
        stringBuffer.append(string).append("\n");
        for (n2 = 0; n2 < this.m_NumClasses; ++n2) {
            if (bl) {
                stringBuffer.append(" ").append(this.num2ShortID(n2, cArray, n3 - 3)).append("   ");
                continue;
            }
            stringBuffer.append(" ").append(this.num2ShortID(n2, cArray, n3));
        }
        stringBuffer.append("   <-- classified as\n");
        for (n2 = 0; n2 < this.m_NumClasses; ++n2) {
            for (n = 0; n < this.m_NumClasses; ++n) {
                stringBuffer.append(" ").append(Utils.doubleToString(this.m_ConfusionMatrix[n2][n], n3, bl ? 2 : 0));
            }
            stringBuffer.append(" | ").append(this.num2ShortID(n2, cArray, n3)).append(" = ").append(this.m_ClassNames[n2]).append("\n");
        }
        return stringBuffer.toString();
    }

    public String toClassDetailsString() throws Exception {
        return this.toClassDetailsString("=== Detailed Accuracy By Class ===\n");
    }

    public String toClassDetailsString(String string) throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Evaluation: No confusion matrix possible!");
        }
        StringBuffer stringBuffer = new StringBuffer(string + "\nTP Rate   FP Rate" + "   Precision   Recall" + "  F-Measure   ROC Area  Class\n");
        for (int i = 0; i < this.m_NumClasses; ++i) {
            stringBuffer.append(Utils.doubleToString(this.truePositiveRate(i), 7, 3)).append("   ");
            stringBuffer.append(Utils.doubleToString(this.falsePositiveRate(i), 7, 3)).append("    ");
            stringBuffer.append(Utils.doubleToString(this.precision(i), 7, 3)).append("   ");
            stringBuffer.append(Utils.doubleToString(this.recall(i), 7, 3)).append("   ");
            stringBuffer.append(Utils.doubleToString(this.fMeasure(i), 7, 3)).append("    ");
            double d = this.areaUnderROC(i);
            if (Instance.isMissingValue(d)) {
                stringBuffer.append("  ?    ").append("    ");
            } else {
                stringBuffer.append(Utils.doubleToString(d, 7, 3)).append("    ");
            }
            stringBuffer.append(this.m_ClassNames[i]).append('\n');
        }
        return stringBuffer.toString();
    }

    public double numTruePositives(int n) {
        double d = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i != n) continue;
            d += this.m_ConfusionMatrix[n][i];
        }
        return d;
    }

    public double truePositiveRate(int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == n) {
                d += this.m_ConfusionMatrix[n][i];
            }
            d2 += this.m_ConfusionMatrix[n][i];
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        return d / d2;
    }

    public double numTrueNegatives(int n) {
        double d = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == n) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j == n) continue;
                d += this.m_ConfusionMatrix[i][j];
            }
        }
        return d;
    }

    public double trueNegativeRate(int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == n) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j != n) {
                    d += this.m_ConfusionMatrix[i][j];
                }
                d2 += this.m_ConfusionMatrix[i][j];
            }
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        return d / d2;
    }

    public double numFalsePositives(int n) {
        double d = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == n) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j != n) continue;
                d += this.m_ConfusionMatrix[i][j];
            }
        }
        return d;
    }

    public double falsePositiveRate(int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == n) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j == n) {
                    d += this.m_ConfusionMatrix[i][j];
                }
                d2 += this.m_ConfusionMatrix[i][j];
            }
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        return d / d2;
    }

    public double numFalseNegatives(int n) {
        double d = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i != n) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j == n) continue;
                d += this.m_ConfusionMatrix[i][j];
            }
        }
        return d;
    }

    public double falseNegativeRate(int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i != n) continue;
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (j != n) {
                    d += this.m_ConfusionMatrix[i][j];
                }
                d2 += this.m_ConfusionMatrix[i][j];
            }
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        return d / d2;
    }

    public double recall(int n) {
        return this.truePositiveRate(n);
    }

    public double precision(int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == n) {
                d += this.m_ConfusionMatrix[i][n];
            }
            d2 += this.m_ConfusionMatrix[i][n];
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        return d / d2;
    }

    public double fMeasure(int n) {
        double d;
        double d2 = this.precision(n);
        if (d2 + (d = this.recall(n)) == 0.0) {
            return 0.0;
        }
        return 2.0 * d2 * d / (d2 + d);
    }

    public void setPriors(Instances instances) throws Exception {
        this.m_NoPriors = false;
        if (!this.m_ClassIsNominal) {
            this.m_NumTrainClassVals = 0;
            this.m_TrainClassVals = null;
            this.m_TrainClassWeights = null;
            this.m_PriorErrorEstimator = null;
            this.m_ErrorEstimator = null;
            for (int i = 0; i < instances.numInstances(); ++i) {
                Instance instance = instances.instance(i);
                if (instance.classIsMissing()) continue;
                this.addNumericTrainClass(instance.classValue(), instance.weight());
            }
        } else {
            int n;
            for (n = 0; n < this.m_NumClasses; ++n) {
                this.m_ClassPriors[n] = 1.0;
            }
            this.m_ClassPriorsSum = this.m_NumClasses;
            for (n = 0; n < instances.numInstances(); ++n) {
                if (instances.instance(n).classIsMissing()) continue;
                int n2 = (int)instances.instance(n).classValue();
                this.m_ClassPriors[n2] = this.m_ClassPriors[n2] + instances.instance(n).weight();
                this.m_ClassPriorsSum += instances.instance(n).weight();
            }
        }
    }

    public double[] getClassPriors() {
        return this.m_ClassPriors;
    }

    public void updatePriors(Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            if (!this.m_ClassIsNominal) {
                if (!instance.classIsMissing()) {
                    this.addNumericTrainClass(instance.classValue(), instance.weight());
                }
            } else {
                int n = (int)instance.classValue();
                this.m_ClassPriors[n] = this.m_ClassPriors[n] + instance.weight();
                this.m_ClassPriorsSum += instance.weight();
            }
        }
    }

    public void useNoPriors() {
        this.m_NoPriors = true;
    }

    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        Evaluation evaluation = (Evaluation)object;
        if (this.m_ClassIsNominal != evaluation.m_ClassIsNominal) {
            return false;
        }
        if (this.m_NumClasses != evaluation.m_NumClasses) {
            return false;
        }
        if (this.m_Incorrect != evaluation.m_Incorrect) {
            return false;
        }
        if (this.m_Correct != evaluation.m_Correct) {
            return false;
        }
        if (this.m_Unclassified != evaluation.m_Unclassified) {
            return false;
        }
        if (this.m_MissingClass != evaluation.m_MissingClass) {
            return false;
        }
        if (this.m_WithClass != evaluation.m_WithClass) {
            return false;
        }
        if (this.m_SumErr != evaluation.m_SumErr) {
            return false;
        }
        if (this.m_SumAbsErr != evaluation.m_SumAbsErr) {
            return false;
        }
        if (this.m_SumSqrErr != evaluation.m_SumSqrErr) {
            return false;
        }
        if (this.m_SumClass != evaluation.m_SumClass) {
            return false;
        }
        if (this.m_SumSqrClass != evaluation.m_SumSqrClass) {
            return false;
        }
        if (this.m_SumPredicted != evaluation.m_SumPredicted) {
            return false;
        }
        if (this.m_SumSqrPredicted != evaluation.m_SumSqrPredicted) {
            return false;
        }
        if (this.m_SumClassPredicted != evaluation.m_SumClassPredicted) {
            return false;
        }
        if (this.m_ClassIsNominal) {
            for (int i = 0; i < this.m_NumClasses; ++i) {
                for (int j = 0; j < this.m_NumClasses; ++j) {
                    if (this.m_ConfusionMatrix[i][j] == evaluation.m_ConfusionMatrix[i][j]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected static String printClassifications(Classifier classifier, Instances instances, ConverterUtils.DataSource dataSource, int n, Range range) throws Exception {
        return Evaluation.printClassifications(classifier, instances, dataSource, n, range, false);
    }

    protected static String printClassifications(Classifier classifier, Instances instances, ConverterUtils.DataSource dataSource, int n, Range range, boolean bl) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (dataSource != null) {
            int n2;
            Instances instances2 = dataSource.getStructure();
            if (n != -1) {
                instances2.setClassIndex(n - 1);
            } else if (instances2.classIndex() == -1) {
                instances2.setClassIndex(instances2.numAttributes() - 1);
            }
            if (instances2.classAttribute().isNominal()) {
                if (bl) {
                    stringBuffer.append(" inst#     actual  predicted error distribution");
                } else {
                    stringBuffer.append(" inst#     actual  predicted error prediction");
                }
            } else {
                stringBuffer.append(" inst#     actual  predicted      error");
            }
            if (range != null) {
                range.setUpper(instances2.numAttributes() - 1);
                stringBuffer.append(" (");
                n2 = 1;
                for (int i = 0; i < instances2.numAttributes(); ++i) {
                    if (i == instances2.classIndex() || !range.isInRange(i)) continue;
                    if (n2 == 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(instances2.attribute(i).name());
                    n2 = 0;
                }
                stringBuffer.append(")");
            }
            stringBuffer.append("\n");
            n2 = 0;
            while (dataSource.hasMoreElements()) {
                Instance instance = dataSource.nextElement(instances2);
                stringBuffer.append(Evaluation.predictionText(classifier, instance, n2, range, bl));
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    protected static String predictionText(Classifier classifier, Instance instance, int n, Range range, boolean bl) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 10;
        int n3 = 3;
        Instance instance2 = (Instance)instance.copy();
        instance2.setDataset(instance.dataset());
        double d = classifier.classifyInstance(instance2);
        stringBuffer.append(Utils.padLeft("" + (n + 1), 6));
        if (instance.dataset().classAttribute().isNumeric()) {
            if (instance.classIsMissing()) {
                stringBuffer.append(" " + Utils.padLeft("?", n2));
            } else {
                stringBuffer.append(" " + Utils.doubleToString(instance.classValue(), n2, n3));
            }
            if (Instance.isMissingValue(d)) {
                stringBuffer.append(" " + Utils.padLeft("?", n2));
            } else {
                stringBuffer.append(" " + Utils.doubleToString(d, n2, n3));
            }
            if (Instance.isMissingValue(d) || instance.classIsMissing()) {
                stringBuffer.append(" " + Utils.padLeft("?", n2));
            } else {
                stringBuffer.append(" " + Utils.doubleToString(d - instance.classValue(), n2, n3));
            }
        } else {
            stringBuffer.append(" " + Utils.padLeft((int)instance.classValue() + 1 + ":" + instance.toString(instance.classIndex()), n2));
            if (Instance.isMissingValue(d)) {
                stringBuffer.append(" " + Utils.padLeft("?", n2));
            } else {
                stringBuffer.append(" " + Utils.padLeft((int)d + 1 + ":" + instance.dataset().classAttribute().value((int)d), n2));
            }
            if ((int)d + 1 != (int)instance.classValue() + 1) {
                stringBuffer.append("   +  ");
            } else {
                stringBuffer.append("      ");
            }
            if (bl) {
                if (Instance.isMissingValue(d)) {
                    stringBuffer.append(" ?");
                } else {
                    stringBuffer.append(" ");
                    double[] dArray = classifier.distributionForInstance(instance2);
                    for (int i = 0; i < dArray.length; ++i) {
                        if (i > 0) {
                            stringBuffer.append(",");
                        }
                        if (i == (int)d) {
                            stringBuffer.append("*");
                        }
                        stringBuffer.append(Utils.doubleToString(dArray[i], n3));
                    }
                }
            } else if (Instance.isMissingValue(d)) {
                stringBuffer.append(" ?");
            } else {
                stringBuffer.append(" " + Utils.doubleToString(classifier.distributionForInstance(instance2)[(int)d], n3));
            }
        }
        stringBuffer.append(" " + Evaluation.attributeValuesString(instance2, range) + "\n");
        return stringBuffer.toString();
    }

    protected static String attributeValuesString(Instance instance, Range range) {
        StringBuffer stringBuffer = new StringBuffer();
        if (range != null) {
            boolean bl = true;
            range.setUpper(instance.numAttributes() - 1);
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (!range.isInRange(i) || i == instance.classIndex()) continue;
                if (bl) {
                    stringBuffer.append("(");
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(instance.toString(i));
                bl = false;
            }
            if (!bl) {
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    protected static String makeOptionString(Classifier classifier) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\n\nGeneral options:\n\n");
        stringBuffer.append("-t <name of training file>\n");
        stringBuffer.append("\tSets training file.\n");
        stringBuffer.append("-T <name of test file>\n");
        stringBuffer.append("\tSets test file. If missing, a cross-validation");
        stringBuffer.append(" will be performed on the training data.\n");
        stringBuffer.append("-c <class index>\n");
        stringBuffer.append("\tSets index of class attribute (default: last).\n");
        stringBuffer.append("-x <number of folds>\n");
        stringBuffer.append("\tSets number of folds for cross-validation (default: 10).\n");
        stringBuffer.append("-no-cv\n");
        stringBuffer.append("\tDo not perform any cross validation.\n");
        stringBuffer.append("-split-percentage <percentage>\n");
        stringBuffer.append("\tSets the percentage for the train/test set split, e.g., 66.\n");
        stringBuffer.append("-preserve-order\n");
        stringBuffer.append("\tPreserves the order in the percentage split.\n");
        stringBuffer.append("-s <random number seed>\n");
        stringBuffer.append("\tSets random number seed for cross-validation or percentage split\n");
        stringBuffer.append("\t(default: 1).\n");
        stringBuffer.append("-m <name of file with cost matrix>\n");
        stringBuffer.append("\tSets file with cost matrix.\n");
        stringBuffer.append("-l <name of input file>\n");
        stringBuffer.append("\tSets model input file. In case the filename ends with '.xml',\n");
        stringBuffer.append("\tthe options are loaded from the XML file.\n");
        stringBuffer.append("-d <name of output file>\n");
        stringBuffer.append("\tSets model output file. In case the filename ends with '.xml',\n");
        stringBuffer.append("\tonly the options are saved to the XML file, not the model.\n");
        stringBuffer.append("-v\n");
        stringBuffer.append("\tOutputs no statistics for training data.\n");
        stringBuffer.append("-o\n");
        stringBuffer.append("\tOutputs statistics only, not the classifier.\n");
        stringBuffer.append("-i\n");
        stringBuffer.append("\tOutputs detailed information-retrieval");
        stringBuffer.append(" statistics for each class.\n");
        stringBuffer.append("-k\n");
        stringBuffer.append("\tOutputs information-theoretic statistics.\n");
        stringBuffer.append("-p <attribute range>\n");
        stringBuffer.append("\tOnly outputs predictions for test instances (or the train\n\tinstances if no test instances provided), along with attributes\n\t(0 for none).\n");
        stringBuffer.append("-distribution\n");
        stringBuffer.append("\tOutputs the distribution instead of only the prediction\n");
        stringBuffer.append("\tin conjunction with the '-p' option (only nominal classes).\n");
        stringBuffer.append("-r\n");
        stringBuffer.append("\tOnly outputs cumulative margin distribution.\n");
        if (classifier instanceof Sourcable) {
            stringBuffer.append("-z <class name>\n");
            stringBuffer.append("\tOnly outputs the source representation of the classifier, giving it the supplied name.\n");
        }
        if (classifier instanceof Drawable) {
            stringBuffer.append("-g\n");
            stringBuffer.append("\tOnly outputs the graph representation of the classifier.\n");
        }
        stringBuffer.append("-xml filename | xml-string\n");
        stringBuffer.append("\tRetrieves the options from the XML-data instead of the command line.\n");
        if (classifier instanceof OptionHandler) {
            stringBuffer.append("\nOptions specific to " + classifier.getClass().getName() + ":\n\n");
            Enumeration enumeration = classifier.listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                stringBuffer.append(option.synopsis() + '\n');
                stringBuffer.append(option.description() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    protected String num2ShortID(int n, char[] cArray, int n2) {
        int n3;
        char[] cArray2 = new char[n2];
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            cArray2[n3] = cArray[n % cArray.length];
            if ((n = n / cArray.length - 1) < 0) break;
        }
        --n3;
        while (n3 >= 0) {
            cArray2[n3] = 32;
            --n3;
        }
        return new String(cArray2);
    }

    protected double[] makeDistribution(double d) {
        double[] dArray = new double[this.m_NumClasses];
        if (Instance.isMissingValue(d)) {
            return dArray;
        }
        if (this.m_ClassIsNominal) {
            dArray[(int)d] = 1.0;
        } else {
            dArray[0] = d;
        }
        return dArray;
    }

    protected void updateStatsForClassifier(double[] dArray, Instance instance) throws Exception {
        int n = (int)instance.classValue();
        if (!instance.classIsMissing()) {
            double d;
            this.updateMargins(dArray, n, instance.weight());
            int n2 = -1;
            double d2 = 0.0;
            for (int i = 0; i < this.m_NumClasses; ++i) {
                if (!(dArray[i] > d2)) continue;
                n2 = i;
                d2 = dArray[i];
            }
            this.m_WithClass += instance.weight();
            if (this.m_CostMatrix != null) {
                this.m_TotalCost = n2 < 0 ? (this.m_TotalCost += instance.weight() * this.m_CostMatrix.getMaxCost(n, instance)) : (this.m_TotalCost += instance.weight() * this.m_CostMatrix.getElement(n, n2, instance));
            }
            if (n2 < 0) {
                this.m_Unclassified += instance.weight();
                return;
            }
            double d3 = Math.max(Double.MIN_VALUE, dArray[n]);
            this.m_SumKBInfo = d3 >= (d = Math.max(Double.MIN_VALUE, this.m_ClassPriors[n] / this.m_ClassPriorsSum)) ? (this.m_SumKBInfo += (Utils.log2(d3) - Utils.log2(d)) * instance.weight()) : (this.m_SumKBInfo -= (Utils.log2(1.0 - d3) - Utils.log2(1.0 - d)) * instance.weight());
            this.m_SumSchemeEntropy -= Utils.log2(d3) * instance.weight();
            this.m_SumPriorEntropy -= Utils.log2(d) * instance.weight();
            this.updateNumericScores(dArray, this.makeDistribution(instance.classValue()), instance.weight());
            double[] dArray2 = this.m_ConfusionMatrix[n];
            int n3 = n2;
            dArray2[n3] = dArray2[n3] + instance.weight();
            if (n2 != n) {
                this.m_Incorrect += instance.weight();
            } else {
                this.m_Correct += instance.weight();
            }
        } else {
            this.m_MissingClass += instance.weight();
        }
    }

    protected void updateStatsForPredictor(double d, Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            this.m_WithClass += instance.weight();
            if (Instance.isMissingValue(d)) {
                this.m_Unclassified += instance.weight();
                return;
            }
            this.m_SumClass += instance.weight() * instance.classValue();
            this.m_SumSqrClass += instance.weight() * instance.classValue() * instance.classValue();
            this.m_SumClassPredicted += instance.weight() * instance.classValue() * d;
            this.m_SumPredicted += instance.weight() * d;
            this.m_SumSqrPredicted += instance.weight() * d * d;
            if (this.m_ErrorEstimator == null) {
                this.setNumericPriorsFromBuffer();
            }
            double d2 = Math.max(this.m_ErrorEstimator.getProbability(d - instance.classValue()), Double.MIN_VALUE);
            double d3 = Math.max(this.m_PriorErrorEstimator.getProbability(instance.classValue()), Double.MIN_VALUE);
            this.m_SumSchemeEntropy -= Utils.log2(d2) * instance.weight();
            this.m_SumPriorEntropy -= Utils.log2(d3) * instance.weight();
            this.m_ErrorEstimator.addValue(d - instance.classValue(), instance.weight());
            this.updateNumericScores(this.makeDistribution(d), this.makeDistribution(instance.classValue()), instance.weight());
        } else {
            this.m_MissingClass += instance.weight();
        }
    }

    protected void updateMargins(double[] dArray, int n, double d) {
        int n2;
        double d2 = dArray[n];
        double d3 = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            if (i == n || !(dArray[i] > d3)) continue;
            d3 = dArray[i];
        }
        double d4 = d2 - d3;
        int n3 = n2 = (int)((d4 + 1.0) / 2.0 * (double)k_MarginResolution);
        this.m_MarginCounts[n3] = this.m_MarginCounts[n3] + d;
    }

    protected void updateNumericScores(double[] dArray, double[] dArray2, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < this.m_NumClasses; ++i) {
            double d7 = dArray[i] - dArray2[i];
            d2 += d7;
            d3 += Math.abs(d7);
            d4 += d7 * d7;
            d7 = this.m_ClassPriors[i] / this.m_ClassPriorsSum - dArray2[i];
            d5 += Math.abs(d7);
            d6 += d7 * d7;
        }
        this.m_SumErr += d * d2 / (double)this.m_NumClasses;
        this.m_SumAbsErr += d * d3 / (double)this.m_NumClasses;
        this.m_SumSqrErr += d * d4 / (double)this.m_NumClasses;
        this.m_SumPriorAbsErr += d * d5 / (double)this.m_NumClasses;
        this.m_SumPriorSqrErr += d * d6 / (double)this.m_NumClasses;
    }

    protected void addNumericTrainClass(double d, double d2) {
        if (this.m_TrainClassVals == null) {
            this.m_TrainClassVals = new double[100];
            this.m_TrainClassWeights = new double[100];
        }
        if (this.m_NumTrainClassVals == this.m_TrainClassVals.length) {
            double[] dArray = new double[this.m_TrainClassVals.length * 2];
            System.arraycopy(this.m_TrainClassVals, 0, dArray, 0, this.m_TrainClassVals.length);
            this.m_TrainClassVals = dArray;
            dArray = new double[this.m_TrainClassWeights.length * 2];
            System.arraycopy(this.m_TrainClassWeights, 0, dArray, 0, this.m_TrainClassWeights.length);
            this.m_TrainClassWeights = dArray;
        }
        this.m_TrainClassVals[this.m_NumTrainClassVals] = d;
        this.m_TrainClassWeights[this.m_NumTrainClassVals] = d2;
        ++this.m_NumTrainClassVals;
    }

    protected void setNumericPriorsFromBuffer() {
        double d = 0.01;
        if (this.m_NumTrainClassVals > 1) {
            double[] dArray = new double[this.m_NumTrainClassVals];
            System.arraycopy(this.m_TrainClassVals, 0, dArray, 0, this.m_NumTrainClassVals);
            int[] nArray = Utils.sort(dArray);
            double d2 = dArray[nArray[0]];
            double d3 = 0.0;
            int n = 0;
            for (int i = 1; i < dArray.length; ++i) {
                double d4 = dArray[nArray[i]];
                if (d4 == d2) continue;
                d3 += d4 - d2;
                d2 = d4;
                ++n;
            }
            if (n > 0) {
                d = d3 / (double)n;
            }
        }
        this.m_PriorErrorEstimator = new KernelEstimator(d);
        this.m_ErrorEstimator = new KernelEstimator(d);
        this.m_ClassPriorsSum = 0.0;
        this.m_ClassPriors[0] = 0.0;
        for (int i = 0; i < this.m_NumTrainClassVals; ++i) {
            this.m_ClassPriors[0] = this.m_ClassPriors[0] + this.m_TrainClassVals[i] * this.m_TrainClassWeights[i];
            this.m_ClassPriorsSum += this.m_TrainClassWeights[i];
            this.m_PriorErrorEstimator.addValue(this.m_TrainClassVals[i], this.m_TrainClassWeights[i]);
        }
    }
}

