/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Color;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;

public class ExtLogPen
implements EMFConstants {
    private int penStyle;
    private int width;
    private int brushStyle;
    private Color color;
    private int hatch;
    private int[] style;

    public ExtLogPen(int penStyle, int width, int brushStyle, Color color, int hatch, int[] style) {
        this.penStyle = penStyle;
        this.width = width;
        this.brushStyle = brushStyle;
        this.color = color;
        this.hatch = hatch;
        this.style = style;
    }

    public ExtLogPen(EMFInputStream emf) throws IOException {
        this.penStyle = emf.readDWORD();
        this.width = emf.readDWORD();
        this.brushStyle = emf.readUINT();
        this.color = emf.readCOLORREF();
        this.hatch = emf.readULONG();
        int nStyle = emf.readDWORD();
        if (nStyle == 0) {
            emf.readDWORD();
        }
        this.style = emf.readDWORD(nStyle);
    }

    public void write(EMFOutputStream emf) throws IOException {
        emf.writeDWORD(this.penStyle);
        emf.writeDWORD(this.width);
        emf.writeUINT(this.brushStyle);
        emf.writeCOLORREF(this.color);
        emf.writeULONG(this.hatch);
        emf.writeDWORD(this.style.length);
        if (this.style.length == 0) {
            emf.writeDWORD(0);
        }
        emf.writeDWORD(this.style);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("  ExtLogPen\n");
        s.append("    penStyle: " + Integer.toHexString(this.penStyle) + "\n");
        s.append("    width: " + this.width + "\n");
        s.append("    brushStyle: " + this.brushStyle + "\n");
        s.append("    color: " + this.color + "\n");
        s.append("    hatch: " + this.hatch + "\n");
        for (int i = 0; i < this.style.length; ++i) {
            s.append("      style[" + i + "]: " + this.style[i] + "\n");
        }
        return s.toString();
    }
}

