<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="/">
		<HTML>
			<HEAD>
				<TITLE>
					<xsl:value-of select="Referat/Meta/Referatstitel"/>
				</TITLE>
				<style type="text/css">
					.litRoot {	margin-left: 	0px; 
									font-weight:	bold;}
					.litSub { margin-left: 20px; }
					.litSubSub{ margin-left: 40px;}
					.litVerweis {	text-transform:	uppercase;
										font-weight: 		bold;}
					.litVerweisText {	text-transform:	uppercase;}
										 
					a:link {	color:black;
								text-decoration: none;
								}
					a:visited { 	color:grey;
									text-decoration: none;}					
				</style>
			</HEAD>
			<BODY>
				<xsl:apply-templates select="Referat/Meta"/>
				<xsl:call-template name="Trennung"/>
				<xsl:call-template name="Inhaltsverzeichnis"/>
				<xsl:call-template name="Trennung"/>
				<xsl:apply-templates select="Referat/Kapitel"/>
				<xsl:call-template name="Trennung"/>
				<xsl:apply-templates select="Referat/Literaturverzeichnis"/>
				<xsl:call-template name="Trennung"/>
				<xsl:call-template name="Abbildungsverzeichnis"/>
			</BODY>
		</HTML>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="Meta">
		<xsl:for-each select="Autor">
			<b>
				<xsl:text>Name : </xsl:text>
			</b>
			<xsl:value-of select="Nachname"/>, <xsl:value-of select="Vorname"/>
			<b>
				<xsl:text> Matrikelnummer : </xsl:text>
			</b>
			<xsl:value-of select="Matrikelnummer"/>
			<b>
				<xsl:text> Email : </xsl:text>
			</b>
			<xsl:value-of select="Email"/>
			<br/>
		</xsl:for-each>
		<b>
			<xsl:text>Datum : </xsl:text>
		</b>
		<xsl:value-of select="Datum"/>
		<br/>
		<h2>
			<xsl:value-of select="Proseminartitel"/>
		</h2>
		<br/>
		<h3>
			<xsl:value-of select="Referatstitel"/>
		</h3>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="Kapitel">
		<p>
			<xsl:apply-templates/>
		</p>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template name="Trennung">
		<br/>
		<table width="100%">
			<tbody>
				<tr>
					<th bgcolor="#000000" height="1"/>
				</tr>
			</tbody>
		</table>
		<br/>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template name="Inhaltsverzeichnis">
		<p>
			<h3>Inhaltsverzeichnis</h3>
		</p>
		<xsl:for-each select="//Kapitel">
			<xsl:choose>
				<xsl:when test="../../Referat">
					<div class="litRoot">
						<a>
							<xsl:attribute name="href">#"<xsl:value-of select="Überschrift/text()"/>"</xsl:attribute>
							<xsl:number level="multiple" format="1.1.a. "/>
							<xsl:value-of select="Überschrift/text()"/>
						</a>
					</div>
				</xsl:when>
				<xsl:when test="../../../Referat">
					<div class="litSub">
						<a>
							<xsl:attribute name="href">#"<xsl:value-of select="Überschrift/text()"/>"</xsl:attribute>
							<xsl:number level="multiple" format="1.1.a. "/>
							<xsl:value-of select="Überschrift/text()"/>
						</a>
					</div>
				</xsl:when>
				<xsl:when test="../../../../Referat">
					<div class="litSubSub">
						<a>
							<xsl:attribute name="href">#"<xsl:value-of select="Überschrift/text()"/>"</xsl:attribute>
							<xsl:number level="multiple" format="1.1.a. "/>
							<xsl:value-of select="Überschrift/text()"/>
						</a>
					</div>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		<div class="litRoot">
			<a href="#Literaturverzeichnis">A. Literaturverzeichnis</a>
		</div>
		<div class="litRoot">
			<a href="#Abbildungsverzeichnis">B. Abbildungsverzeichnis</a>
		</div>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="Überschrift">
		<a>
			<xsl:attribute name="name">"<xsl:value-of select="./text()"/>"</xsl:attribute>
		</a>
		<xsl:choose>
			<xsl:when test="../../../Referat">
				<h3>
					<xsl:number level="multiple" count="//Kapitel" format="1.1.a. "/>
					<xsl:value-of select="./text()"/>
				</h3>
			</xsl:when>
			<xsl:when test="../../../../Referat">
				<h4>
					<xsl:number level="multiple" count="//Kapitel" format="1.1.a. "/>
					<xsl:value-of select="./text()"/>
				</h4>
			</xsl:when>
			<xsl:when test="../../../../../Referat">
				<h5>
					<xsl:number level="multiple" count="//Kapitel" format="1.1.a. "/>
					<xsl:value-of select="./text()"/>
				</h5>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="Literaturverzeichnis">
		<h3>
			<a name="Literaturverzeichnis">A. Literaturverzeichnis</a>
		</h3>
		<xsl:for-each select="Quelle">
			<xsl:sort data-type="text" order="ascending" select="Autor/Nachname"/>
			<xsl:sort data-type="text" order="ascending" select="Autor/Vorname"/>
			<xsl:sort data-type="number" order="ascending" select="Jahr"/>
			<xsl:sort data-type="text" order="ascending" select="Titel"/>
			<span class="litVerweis">
				<a>
					<xsl:attribute name="name"><xsl:call-template name="QuellNamenGenerator"/></xsl:attribute>
					<xsl:call-template name="QuellNamenGenerator"/>
				</a>
			</span>
			<xsl:value-of select="Autor/Nachname"/>, <xsl:value-of select="Autor/Vorname"/>
			<xsl:for-each select="Co-Autor">
				<xsl:text>; </xsl:text>
				<xsl:value-of select="Nachname"/>, <xsl:value-of select="Vorname"/>
			</xsl:for-each>
			<xsl:text>: </xsl:text>
			<xsl:value-of select="Titel"/>.
			<xsl:value-of select="Jahr"/>
			<br/>
		</xsl:for-each>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template name="QuellNamenGenerator">
		<xsl:choose>
			<xsl:when test="Co-Autor">
				<xsl:text>[</xsl:text>
				<xsl:value-of select="substring(Autor/Nachname,1,2)"/>
				<xsl:value-of select="substring(Co-Autor/Nachname,1,2)"/>
				<xsl:value-of select="substring(Jahr,3,4)"/>
				<xsl:text>]</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>[</xsl:text>
				<xsl:value-of select="substring(Autor/Nachname,1,4)"/>
				<xsl:value-of select="substring(Jahr,3,4)"/>
				<xsl:text>]</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="Quellenverweis">
		<xsl:variable name="quell_ref_tmp" select="./@quell_ref"/>
		<xsl:for-each select="/Referat/Literaturverzeichnis/Quelle">
			<xsl:if test="$quell_ref_tmp =@quell_id">
				<span class="litVerweisText">
					<a>
						<xsl:attribute name="href">#<xsl:call-template name="QuellNamenGenerator"/></xsl:attribute>
						<xsl:call-template name="QuellNamenGenerator"/>
					</a>
				</span>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="Fußnotenverweis">
		<xsl:variable name="fuß_ref_tmp" select="./@fuß_ref"/>
		<xsl:for-each select="//Fußnotenverweis">
			<xsl:if test="($fuß_ref_tmp)=(@fuß_ref)">
				<sup>
					<a>
						<xsl:attribute name="href">#<xsl:value-of select="$fuß_ref_tmp"/></xsl:attribute>
						<xsl:number level="single" value="position()" count="//Fußnotenverweis/@fuß_ref"/>
					</a>
				</sup>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="Fußnote">
		<xsl:variable name="fuß_tmp" select="."/>
		<xsl:call-template name="Fußnotenseperator"/>
		<xsl:for-each select="//Fußnote">
			<xsl:variable name="fuß_nr_tmp" select="position()"/>
			<xsl:if test="($fuß_tmp/@fuß_id)=(@fuß_id)">
				<xsl:for-each select="//Fußnotenverweis">
					<xsl:variable name="fuß_vw_nr_tmp" select="position()"/>
					<xsl:if test="($fuß_vw_nr_tmp)=($fuß_nr_tmp)">
						<xsl:variable name="fuß_tmp2" select="."/>
						<xsl:for-each select="//Fußnote">
							<xsl:variable name="fuß_nr_tmp2">
								<xsl:number/>
							</xsl:variable>
							<xsl:if test="($fuß_tmp2/@fuß_ref)=(@fuß_id)">
								<sup>
									<a>
										<xsl:attribute name="name"><xsl:value-of select="@fuß_id"/></xsl:attribute>
										<xsl:value-of select="$fuß_vw_nr_tmp"/>
									</a>
								</sup>
								<xsl:value-of select="."/>
							</xsl:if>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template name="Fußnotenseperator">
		<xsl:variable name="fuß_sep_tmp" select="."/>
		<xsl:for-each select="//Text">
			<xsl:for-each select="Fußnote">
				<xsl:if test="(.)=($fuß_sep_tmp)">
					<xsl:if test="position()=1">
						<br/>
						<table width="30%">
							<tbody>
								<tr>
									<th bgcolor="grey" height="1"/>
								</tr>
							</tbody>
						</table>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="Bild">
		<br/>
		<br/>
		<div>
			<img>
				<xsl:attribute name="src"><xsl:value-of select="@Quelle"/></xsl:attribute>
				<xsl:attribute name="alt"><xsl:value-of select="@Alt"/></xsl:attribute>
				<xsl:attribute name="heigth"><xsl:value-of select="@Höhe"/></xsl:attribute>
				<xsl:attribute name="width"><xsl:value-of select="@Breite"/></xsl:attribute>
			</img>
			<xsl:variable name="bild_tmp" select="."/>
			<xsl:for-each select="//Bild">
				<xsl:if test="(.)=($bild_tmp)">
					<br/>
					<b>Abb.<xsl:number level="single" value="position()" format="1: "/>
					</b>
					<xsl:value-of select="."/>
					<br/>
				</xsl:if>
			</xsl:for-each>
		</div>
		<br/>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template name="Abbildungsverzeichnis">
		<h3>
			<a name="Abbildungsverzeichnis">B. Abbildungsverzeichnis</a>
		</h3>
		<xsl:for-each select="//Bild">
			<div>
				<img>
					<xsl:attribute name="src"><xsl:value-of select="@Quelle"/></xsl:attribute>
					<xsl:attribute name="alt"><xsl:value-of select="@Alt"/></xsl:attribute>
					<xsl:attribute name="heigth"><xsl:value-of select="@Höhe"/></xsl:attribute>
					<xsl:attribute name="width"><xsl:value-of select="@Breite"/></xsl:attribute>
				</img>
				<br/>
				<b>Abb.<xsl:number level="single" value="position()" format="1: "/>
				</b>
				<xsl:value-of select="."/>
			</div>
			<br/>
		</xsl:for-each>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="Text">
		<p>
			<xsl:attribute name="align"><xsl:value-of select="@Ausrichtung"/></xsl:attribute>
			<div>
				<xsl:apply-templates/>
			</div>
		</p>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="Aufzählung">
		<xsl:choose>
			<xsl:when test="@art='punkt'">
				<ul>
					<xsl:apply-templates/>
				</ul>
			</xsl:when>
			<xsl:when test="@art='zahl'">
				<ol>
					<xsl:apply-templates/>
				</ol>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="Eintrag">
		<li>
			<xsl:apply-templates/>
		</li>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="Tabelle">
		<xsl:element name="table">
			<xsl:attribute name="border"><xsl:value-of select="@border"/></xsl:attribute>
			<thead>
				<xsl:if test="Kopfzeile">
					<tr>
						<xsl:for-each select="Kopfzeile/Kopfspalte">
							<th>
								<xsl:value-of select="."/>
							</th>
						</xsl:for-each>
					</tr>
				</xsl:if>
			</thead>
			<tbody>
				<xsl:for-each select="Zeile">
					<tr>
						<xsl:for-each select="Spalte">
							<td>
								<xsl:value-of select="."/>
							</td>
						</xsl:for-each>
					</tr>
				</xsl:for-each>
			</tbody>
		</xsl:element>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="Zeilenumbruch">
		<br>
			<xsl:apply-templates/>
		</br>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="Definition">
		<i>
			<xsl:apply-templates/>
		</i>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="Begriff">
		<b>
			<xsl:apply-templates/>
		</b>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="Zitat">
		<xsl:text>"</xsl:text>
		<i>
			<xsl:apply-templates/>
		</i>
		<xsl:text>"</xsl:text>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
</xsl:stylesheet>
