<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:variable name="heading1">22pt</xsl:variable>
	<xsl:variable name="heading2">18pt</xsl:variable>
	<xsl:variable name="heading3">16pt</xsl:variable>
	<!-- Chapter X-->
	<xsl:variable name="heading4">15pt</xsl:variable>
	<!-- Chapter A.X-->
	<xsl:variable name="heading5">14pt</xsl:variable>
	<!-- Chapter A.a.X-->
	<xsl:variable name="heading6">13pt</xsl:variable>
	<!-- other Chapters-->
	<xsl:variable name="text-size">12pt</xsl:variable>
	<xsl:variable name="footnote-size">10pt</xsl:variable>
	<xsl:variable name="used-fonts">'Times New Roman',serif</xsl:variable>
	<xsl:variable name="non-prop-fonts">Courier</xsl:variable>
	<xsl:variable name="code-background-color">LightGray</xsl:variable>
	<xsl:variable name="dfn-background-color">LightGray</xsl:variable>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="/">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4Page" page-height="297mm" page-width="210mm" margin-left="0mm" margin-right="0mm" margin-top="10mm" margin-bottom="10mm">
					<fo:region-body margin-top="10mm" margin-bottom="10mm" margin-left="20mm" margin-right="20mm"/>
					<fo:region-before extent="0mm" background-color="#FFFFFF"/>
					<fo:region-after extent="10mm" background-color="#FFFFFF"/>
					<fo:region-start extent="0mm" background-color="#FFFFFF"/>
					<fo:region-end extent="0mm" background-color="#FFFFFF"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<xsl:call-template name="page_front"/>
			<xsl:call-template name="page_toc"/>
			<xsl:call-template name="page_content"/>
			<xsl:call-template name="page_bib"/>
		</fo:root>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<!-- PAGES -->
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template name="page_front">
		<fo:page-sequence master-reference="A4Page">
			<fo:flow flow-name="xsl-region-body">
				<xsl:apply-templates select="paper/meta"/>
			</fo:flow>
		</fo:page-sequence>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template name="page_toc">
		<fo:page-sequence master-reference="A4Page" initial-page-number="1">
			<fo:static-content flow-name="xsl-region-after">
				<fo:block>
					<xsl:text> </xsl:text>
				</fo:block>
				<fo:block text-align="center">
					<fo:page-number/>
				</fo:block>
			</fo:static-content>
			<fo:flow flow-name="xsl-region-body">
				<xsl:call-template name="toc"/>
			</fo:flow>
		</fo:page-sequence>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template name="page_content">
		<fo:page-sequence master-reference="A4Page">
			<fo:static-content flow-name="xsl-region-after">
				<fo:block>
					<xsl:text> </xsl:text>
				</fo:block>
				<fo:block text-align="center">
					<fo:page-number/>
				</fo:block>
			</fo:static-content>
			<fo:static-content flow-name="xsl-footnote-separator">
				<fo:block text-align-last="justify">
					<fo:leader leader-length="50%" rule-thickness="0.7pt" leader-pattern="rule"/>
				</fo:block>
			</fo:static-content>
			<fo:flow flow-name="xsl-region-body">
				<xsl:apply-templates select="paper/content"/>
			</fo:flow>
		</fo:page-sequence>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template name="page_bib">
		<fo:page-sequence master-reference="A4Page">
			<fo:static-content flow-name="xsl-region-after">
				<fo:block>
					<xsl:text> </xsl:text>
				</fo:block>
				<fo:block text-align="center">
					<fo:page-number/>
				</fo:block>
			</fo:static-content>
			<fo:flow flow-name="xsl-region-body">
				<xsl:apply-templates select="paper/bibliography"/>
			</fo:flow>
		</fo:page-sequence>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<!-- PAGE-CONTENTS -->
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="meta">
		<fo:block font-family="{$used-fonts}" text-align="center" line-height="10mm">
			<fo:block line-height="15mm">
				<xsl:text> </xsl:text>
			</fo:block>
			<fo:block font-size="30">
				<xsl:value-of select="title"/>
			</fo:block>
			<fo:block line-height="6mm">
				<xsl:text> </xsl:text>
			</fo:block>
			<xsl:if test="subtitle">
				<fo:block font-size="24">
					<xsl:value-of select="subtitle"/>
				</fo:block>
			</xsl:if>
			<fo:block line-height="60mm">
				<xsl:text> </xsl:text>
			</fo:block>
			<fo:block font-size="19">
				<xsl:value-of select="coursetitle"/>
			</fo:block>
			<fo:block font-size="16">
				<xsl:value-of select="receiver/firstname"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="receiver/surname"/>
			</fo:block>
			<fo:block font-size="16">
				<xsl:value-of select="receiver/institution/department"/>
			</fo:block>
			<fo:block font-size="16">
				<xsl:value-of select="receiver/institution/title"/>
			</fo:block>
			<fo:block line-height="40mm">
				<xsl:text> </xsl:text>
			</fo:block>
			<fo:block>vorgelegt von</fo:block>
			<xsl:for-each select="authors/author">
				<fo:block font-size="16">
					<xsl:value-of select="firstname"/>
					<xsl:if test="firstname[2]">
						<xsl:text> </xsl:text>
						<xsl:value-of select="firstname[2]"/>
					</xsl:if>
					<xsl:text> </xsl:text>
					<xsl:value-of select="surname"/>
				</fo:block>
				<fo:block font-size="14">
					<xsl:text>Matrikelnummer: </xsl:text>
					<xsl:value-of select="matriculation-number"/>
				</fo:block>
				<fo:block font-size="14">
					<xsl:text>Email: </xsl:text>
					<xsl:value-of select="email"/>
				</fo:block>
			</xsl:for-each>
			<fo:block line-height="20mm">
				<xsl:text> </xsl:text>
			</fo:block>
			<fo:block>
				<xsl:value-of select="date"/>
			</fo:block>
		</fo:block>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template name="toc">
		<fo:block font-family="{$used-fonts}" line-height="10mm">
			<fo:block font-size="20pt">Inhaltsverzeichnis</fo:block>
			<fo:block line-height="10mm">
				<xsl:text> </xsl:text>
			</fo:block>
			<xsl:for-each select="//section">
				<xsl:variable name="ref-id">
					<xsl:value-of select="caption"/>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="../../../paper">
						<fo:block margin-left="0cm" font-size="{$heading3}" font-weight="bold" text-align-last="justify">
							<xsl:number level="multiple" format="1.1.1. "/>
							<xsl:value-of select="caption/text()"/>
							<fo:inline>
								<xsl:text>  </xsl:text>
							</fo:inline>
							<fo:leader leader-alignment="reference-area" leader-pattern="dots" rule-style="dotted" rule-thickness="1pt" leader-pattern-width="8pt"/>
							<fo:inline>
								<xsl:text>  </xsl:text>
							</fo:inline>
							<fo:page-number-citation ref-id="{$ref-id}"/>
						</fo:block>
					</xsl:when>
					<xsl:when test="../../../../paper">
						<fo:block margin-left="0.6cm" font-size="{$heading4}" text-align-last="justify">
							<xsl:number level="multiple" format="1.1.1. "/>
							<xsl:value-of select="caption/text()"/>
							<fo:inline>
								<xsl:text>  </xsl:text>
							</fo:inline>
							<fo:leader leader-alignment="reference-area" leader-pattern="dots" rule-style="dotted" rule-thickness="1pt" leader-pattern-width="8pt"/>
							<fo:inline>
								<xsl:text>  </xsl:text>
							</fo:inline>
							<fo:page-number-citation ref-id="{$ref-id}"/>
						</fo:block>
					</xsl:when>
					<xsl:when test="../../../../../paper">
						<fo:block margin-left="1.6cm" font-size="{$heading5}" text-align-last="justify">
							<xsl:number level="multiple" format="1.1.1. "/>
							<xsl:value-of select="caption/text()"/>
							<fo:inline>
								<xsl:text>  </xsl:text>
							</fo:inline>
							<fo:leader leader-alignment="reference-area" leader-pattern="dots" rule-style="dotted" rule-thickness="1pt" leader-pattern-width="8pt"/>
							<fo:inline>
								<xsl:text>  </xsl:text>
							</fo:inline>
							<fo:page-number-citation ref-id="{$ref-id}"/>
						</fo:block>
					</xsl:when>
					<xsl:otherwise>
						<fo:block margin-left="1.5cm" font-size="{$heading6}">
							<xsl:number level="multiple" format="1.1.1. "/>
							<xsl:value-of select="caption/text()"/>
							<fo:inline>
								<xsl:text>  </xsl:text>
							</fo:inline>
							<fo:leader leader-alignment="reference-area" leader-pattern="dots" rule-style="dotted" rule-thickness="1pt" leader-pattern-width="8pt"/>
							<fo:inline>
								<xsl:text>  </xsl:text>
							</fo:inline>
							<fo:page-number-citation ref-id="{$ref-id}"/>
						</fo:block>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
			<fo:block margin-left="0cm" font-size="{$heading3}" font-weight="bold" text-align-last="justify">
				<fo:inline>Literaturverzeichnis</fo:inline>
				<fo:inline>
					<xsl:text>  </xsl:text>
				</fo:inline>
				<fo:leader leader-alignment="reference-area" leader-pattern="dots" rule-style="dotted" rule-thickness="1pt" leader-pattern-width="8pt"/>
				<fo:inline>
					<xsl:text>  </xsl:text>
				</fo:inline>
				<fo:page-number-citation ref-id="toc"/>
			</fo:block>
		</fo:block>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="caption">
		<xsl:variable name="cap_id">
			<xsl:value-of select="."/>
		</xsl:variable>
		<fo:block font-family="{$used-fonts}">
			<xsl:choose>
				<xsl:when test="../../../../paper">
					<fo:block font-size="{$heading3}" font-weight="bold" keep-with-next="always" id="{$cap_id}">
						<xsl:number level="multiple" count="//section" format="1.1.1. "/>
						<xsl:value-of select="./text()"/>
						<xsl:call-template name="block-seperator"/>
					</fo:block>
				</xsl:when>
				<xsl:when test="../../../../../paper">
					<fo:block font-size="{$heading4}" font-weight="bold" keep-with-next="always" id="{$cap_id}">
						<xsl:number level="multiple" count="//section" format="1.1.1. "/>
						<xsl:value-of select="./text()"/>
						<xsl:call-template name="block-seperator"/>
					</fo:block>
				</xsl:when>
				<xsl:when test="../../../../../../paper">
					<fo:block font-size="{$heading5}" font-weight="bold" keep-with-next="always" id="{$cap_id}">
						<xsl:number level="multiple" count="//section" format="1.1.1. "/>
						<xsl:value-of select="./text()"/>
						<xsl:call-template name="block-seperator"/>
					</fo:block>
				</xsl:when>
				<xsl:otherwise>
					<fo:block font-size="{$heading6}" font-weight="bold" keep-with-next="always" id="{$cap_id}">
						<xsl:number level="multiple" count="//section" format="1.1.1. "/>
						<xsl:value-of select="./text()"/>
						<xsl:call-template name="block-seperator"/>
					</fo:block>
				</xsl:otherwise>
			</xsl:choose>
		</fo:block>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="content">
		<fo:block font-size="{$text-size}" line-height="6mm" text-align="justify" hyphenate="true" hyphenation-character="-" hyphenation-push-character-count="2" hyphenation-remain-character-count="3" country="DE" language="de" font-family="{$used-fonts}" orphans="2" widows="2">
			<xsl:apply-templates/>
		</fo:block>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="p">
		<fo:block font-size="{$text-size}" line-height="6mm" text-align="justify" hyphenate="true" hyphenation-character="-" hyphenation-push-character-count="2" hyphenation-remain-character-count="3" country="DE" language="de" font-family="{$used-fonts}" orphans="2" widows="2">
			<xsl:apply-templates/>
		</fo:block>
		<xsl:call-template name="block-seperator"/>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="bibliography">
		<fo:block font-family="{$used-fonts}">
			<fo:block font-weight="bold" font-size="{$heading3}" id="toc">Literaturverzeichnis</fo:block>
			<xsl:call-template name="block-seperator"/>
			<xsl:call-template name="block-seperator"/>
			<fo:block>
				<fo:table>
					<fo:table-column column-number="1" column-width="12%"/>
					<fo:table-column column-number="2" column-width="88%"/>
					<fo:table-body>
						<xsl:for-each select="bibItem">
							<xsl:sort data-type="text" order="ascending" select="author/surname"/>
							<xsl:sort data-type="text" order="ascending" select="author/firstname"/>
							<xsl:sort data-type="text" order="ascending" select="author/firstname[2]"/>
							<xsl:sort data-type="number" order="ascending" select="year"/>
							<xsl:sort data-type="text" order="ascending" select="title"/>
							<fo:table-row>
								<fo:table-cell column-number="1">
									<fo:block text-transform="uppercase" font-weight="bold">
										<xsl:call-template name="bibNameGen"/>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell column-number="2">
									<fo:block>
										<xsl:for-each select="author">
											<xsl:variable name="author_nr">
												<xsl:number count="surname" value="position()"/>
											</xsl:variable>
											<xsl:choose>
												<xsl:when test="($author_nr)=1">
													<xsl:value-of select="surname"/>
													<xsl:text>, </xsl:text>
													<xsl:value-of select="firstname"/>
													<xsl:if test="firstname[2]">
														<xsl:text> </xsl:text>
														<xsl:value-of select="substring(firstname[2],1,1)"/>
														<xsl:text>.</xsl:text>
													</xsl:if>
												</xsl:when>
												<xsl:when test="($author_nr)>1">
													<xsl:text>; </xsl:text>
													<xsl:value-of select="firstname"/>
													<xsl:text> </xsl:text>
													<xsl:if test="firstname[2]">
														<xsl:value-of select="substring(firstname[2],1,1)"/>
														<xsl:text>. </xsl:text>
													</xsl:if>
													<xsl:value-of select="surname"/>
												</xsl:when>
											</xsl:choose>
										</xsl:for-each>
										<xsl:text>: </xsl:text>
										<fo:inline font-style="italic">
											<xsl:value-of select="title"/>.
										</fo:inline>
										<xsl:value-of select="year"/>
										<xsl:text>; </xsl:text>
										<xsl:value-of select="publisher"/>
										<xsl:choose>
											<xsl:when test="source/book">
												<xsl:if test="source/book/edition">
													<xsl:text>; </xsl:text>
													<xsl:value-of select="source/book/edition"/>
												</xsl:if>
												<xsl:if test="source/book/page">
													<xsl:text>; </xsl:text>
													<xsl:value-of select="source/book/page"/>
												</xsl:if>
											</xsl:when>
											<xsl:when test="source/web">
												<xsl:text>; </xsl:text>
												<xsl:value-of select="source/web/uri"/>
												<xsl:if test="source/web/date">
													<xsl:text>; </xsl:text>
													<xsl:value-of select="source/web/date"/>
												</xsl:if>
											</xsl:when>
											<xsl:when test="source/magazine">
												<xsl:text>; </xsl:text>
												<xsl:value-of select="source/magazine/title"/>
												<xsl:if test="source/magazine/month">
													<xsl:text>; </xsl:text>
													<xsl:value-of select="source/magazine/month"/>
												</xsl:if>
												<xsl:if test="source/magazine/page">
													<xsl:text>; </xsl:text>
													<xsl:value-of select="source/magazine/page"/>
												</xsl:if>
											</xsl:when>
										</xsl:choose>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</xsl:for-each>
					</fo:table-body>
				</fo:table>
			</fo:block>
		</fo:block>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template name="bibNameGen">
		<xsl:variable name="last_author">
			<xsl:value-of select="author[last()]"/>
		</xsl:variable>
		<fo:inline text-transform="uppercase">
			<xsl:variable name="nr_authors">
				<xsl:for-each select="author">
					<xsl:if test="(.)=($last_author)">
						<xsl:number select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="$nr_authors=1">
					<xsl:text>[</xsl:text>
					<xsl:value-of select="substring(author/surname,1,2)"/>
					<xsl:value-of select="substring(author/firstname,1,2)"/>
					<xsl:value-of select="substring(year,3,4)"/>
					<xsl:text>]</xsl:text>
				</xsl:when>
				<xsl:when test="$nr_authors=2">
					<xsl:text>[</xsl:text>
					<xsl:value-of select="substring(author/surname,1,2)"/>
					<xsl:value-of select="substring(author[2]/surname,1,2)"/>
					<xsl:value-of select="substring(year,3,4)"/>
					<xsl:text>]</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>[</xsl:text>
					<xsl:value-of select="substring(author/surname,1,1)"/>
					<xsl:value-of select="substring(author[2]/surname,1,1)"/>
					<xsl:value-of select="substring(author[3]/surname,1,1)"/>
					<xsl:text>+</xsl:text>
					<xsl:value-of select="substring(year,3,4)"/>
					<xsl:text>]</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</fo:inline>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template name="block-seperator">
		<fo:block line-height="5mm">
			<xsl:text> </xsl:text>
		</fo:block>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<!-- BLOCK-ELEMENTS -->
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="footnote|quote">
		<xsl:if test="@bibItem-ref">
			<fo:inline font-style="italic">
				<xsl:value-of select="."/>
			</fo:inline>
		</xsl:if>
		<xsl:variable name="foot_tmp" select="."/>
		<xsl:for-each select="//footnote|//quote">
			<xsl:variable name="foot_nr">
				<xsl:number value="position()"/>
			</xsl:variable>
			<xsl:if test="($foot_tmp)=(.)">
				<xsl:variable name="foot_txt">
					<xsl:choose>
						<xsl:when test="$foot_tmp/@bibItem-ref">
							<xsl:for-each select="//bibItem">
								<xsl:if test="($foot_tmp/@bibItem-ref)=(@bibItem-id)">
									<xsl:call-template name="bibNameGen"/>
								</xsl:if>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="."/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<fo:footnote>
					<fo:inline font-size="60%" baseline-shift="20%">
						<xsl:value-of select="$foot_nr"/>
					</fo:inline>
					<fo:footnote-body>
						<fo:block font-size="{$footnote-size}">
							<fo:inline font-size="60%" baseline-shift="super">
								<xsl:value-of select="$foot_nr"/>
							</fo:inline>
							<xsl:choose>
								<xsl:when test="(substring($foot_txt,1,1)='[')">
									<fo:inline text-transform="uppercase">
										<xsl:value-of select="$foot_txt"/>
									</fo:inline>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$foot_txt"/>
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:footnote-body>
				</fo:footnote>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="image">
		<xsl:call-template name="block-seperator"/>
		<fo:block keep-together="always">
			<fo:block>
				<fo:external-graphic>
					<xsl:attribute name="src"><xsl:value-of select="@src"/></xsl:attribute>
					<xsl:if test="@width">
						<xsl:attribute name="content-width"><xsl:value-of select="@width"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="@height">
						<xsl:attribute name="content-height"><xsl:value-of select="@height"/></xsl:attribute>
					</xsl:if>
				</fo:external-graphic>
			</fo:block>
			<fo:block line-height="3mm">
				<xsl:text> </xsl:text>
			</fo:block>
			<xsl:variable name="bild_tmp" select="."/>
			<xsl:for-each select="//image">
				<xsl:if test="(.)=($bild_tmp)">
					<fo:block>
						<fo:inline font-weight="bold">
						Abb.<xsl:number level="single" value="position()" format="1: "/>
						</fo:inline>
						<xsl:value-of select="legend"/>
					</fo:block>
				</xsl:if>
			</xsl:for-each>
		</fo:block>
		<xsl:call-template name="block-seperator"/>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="ul">
		<xsl:call-template name="block-seperator"/>
		<fo:block orphans="2" widows="2">
			<xsl:apply-templates/>
		</fo:block>
		<xsl:call-template name="block-seperator"/>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="ol">
		<xsl:call-template name="block-seperator"/>
		<fo:block orphans="2" widows="2">
			<xsl:apply-templates/>
		</fo:block>
		<xsl:call-template name="block-seperator"/>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="li">
		<xsl:if test="../../ul/li">
			<fo:block text-align="justify" font-size="{$text-size}" orphans="2" widows="2" keep-together="2">
				<fo:list-block provisional-distance-between-starts="5mm" end-indent="5mm" start-indent="5mm">
					<fo:list-item>
						<fo:list-item-label end-indent="label-end()">
							<fo:block>
								<xsl:text>-</xsl:text>
							</fo:block>
						</fo:list-item-label>
						<fo:list-item-body start-indent="body-start()">
							<fo:block font-size="{$text-size}" line-height="6mm" text-align="justify" hyphenate="true" hyphenation-character="!" hyphenation-push-character-count="2" hyphenation-remain-character-count="3" country="DE" language="de" font-family="{$used-fonts}" orphans="3" widows="3">
								<xsl:apply-templates/>
							</fo:block>
						</fo:list-item-body>
					</fo:list-item>
				</fo:list-block>
			</fo:block>
		</xsl:if>
		<xsl:if test="../../ol/li">
			<fo:block text-align="justify" font-size="{$text-size}" orphans="2" widows="2" keep-together="2">
				<fo:list-block provisional-distance-between-starts="5mm" end-indent="5mm" start-indent="5mm">
					<fo:list-item>
						<fo:list-item-label end-indent="label-end()">
							<fo:block>
								<xsl:number select="."/>.
				</fo:block>
						</fo:list-item-label>
						<fo:list-item-body start-indent="body-start()">
							<fo:block font-size="{$text-size}" line-height="6mm" text-align="justify" hyphenate="true" hyphenation-character="!" hyphenation-push-character-count="2" hyphenation-remain-character-count="3" country="DE" language="de" font-family="{$used-fonts}" orphans="2" widows="2">
								<xsl:apply-templates/>
							</fo:block>
						</fo:list-item-body>
					</fo:list-item>
				</fo:list-block>
			</fo:block>
		</xsl:if>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="table">
		<xsl:call-template name="block-seperator"/>
		<fo:block keep-together="always">
			<xsl:variable name="borderwidth">
				<xsl:choose>
					<xsl:when test="@border">
						<xsl:value-of select="@border"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>0</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="borderstyle">
				<xsl:choose>
					<xsl:when test="@border>0">
						<xsl:text>solid</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>none</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<fo:block text-align="center">
				<fo:table border-style="{$borderstyle}" border-width="0" table-layout="fixed" border-color="LightGray">
					<xsl:if test="tr/th">
						<fo:table-header>
							<fo:table-row border-style="{$borderstyle}" border-width="{$borderwidth}" border-color="black">
								<xsl:for-each select="tr/th">
									<fo:table-cell border-style="{$borderstyle}" border-width="{$borderwidth}" border-color="black">
										<fo:block font-weight="bold">
											<xsl:value-of select="."/>
										</fo:block>
									</fo:table-cell>
								</xsl:for-each>
							</fo:table-row>
						</fo:table-header>
					</xsl:if>
					<fo:table-body>
						<xsl:for-each select="tr">
							<xsl:if test="td">
								<fo:table-row border-style="{$borderstyle}" border-width="{$borderwidth}" border-color="gray">
									<xsl:for-each select="td">
										<fo:table-cell border-style="{$borderstyle}" border-width="{$borderwidth}" border-color="gray">
											<fo:block>
												<xsl:value-of select="."/>
											</fo:block>
										</fo:table-cell>
									</xsl:for-each>
								</fo:table-row>
							</xsl:if>
						</xsl:for-each>
					</fo:table-body>
				</fo:table>
			</fo:block>
			<fo:block line-height="3mm">
				<xsl:text> </xsl:text>
			</fo:block>
			<xsl:variable name="table_tmp" select="."/>
			<xsl:for-each select="//table">
				<xsl:if test="(.)=($table_tmp)">
					<fo:block>
						<fo:inline font-weight="bold">
						Tab.<xsl:number level="single" value="position()" format="1: "/>
						</fo:inline>
						<xsl:value-of select="legend"/>
					</fo:block>
				</xsl:if>
			</xsl:for-each>
		</fo:block>
		<xsl:call-template name="block-seperator"/>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="samp">
		<xsl:call-template name="block-seperator"/>
		<fo:block font-family="{$non-prop-fonts}" orphans="2" widows="2">
			<xsl:apply-templates/>
		</fo:block>
		<xsl:call-template name="block-seperator"/>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="code">
		<xsl:call-template name="block-seperator"/>
		<fo:block font-family="{$non-prop-fonts}" background-color="{$code-background-color}" white-space-collapse="false" white-space-treatment="preserve" linefeed-treatment="preserve" orphans="2" widows="2" hyphenate="false" text-align="left">
			<xsl:value-of select="."/>
		</fo:block>
		<xsl:call-template name="block-seperator"/>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="dfn">
		<xsl:call-template name="block-seperator"/>
		<xsl:variable name="dfn_tmp" select="."/>
		<xsl:variable name="dfn_number">
			<xsl:for-each select="//dfn">
				<xsl:if test="(.)=($dfn_tmp)">
					<xsl:number level="single" value="position()" format="1: "/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<fo:block background-color="{$dfn-background-color}" white-space-collapse="false" linefeed-treatment="preserve" white-space-treatment="preserve" orphans="2" widows="2" hyphenate="false" text-align="left">
			<fo:block start-indent="2mm" end-indent="2mm">
				<fo:inline font-weight="bold">Definition <fo:inline>
						<xsl:value-of select="$dfn_number"/>
					</fo:inline>
				</fo:inline>
				<fo:inline font-style="italic">
					<xsl:apply-templates/>
				</fo:inline>
			</fo:block>
		</fo:block>
		<xsl:call-template name="block-seperator"/>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<!-- INLINE-ELEMENTS -->
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="techterm">
		<fo:inline font-style="italic">
			<!-- font-weight="bold"-->
			<xsl:apply-templates/>
		</fo:inline>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="propname">
		<fo:inline font-style="italic">
			<xsl:apply-templates/>
		</fo:inline>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="trademark">
		<fo:inline font-style="italic">
			<xsl:apply-templates/>
		</fo:inline>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="kbd">
		<fo:inline font-family="{$non-prop-fonts}">
			<xsl:apply-templates/>
		</fo:inline>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="var">
		<fo:inline font-style="italic">
			<xsl:apply-templates/>
		</fo:inline>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
</xsl:stylesheet>
