<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="/">
		<HTML>
			<HEAD>
				<TITLE>
					<xsl:value-of select="paper/meta/title"/>
				</TITLE>
				<style type="text/css">
					.tocRoot {	margin-left: 	0px; 
									font-weight:	bold;}
					.tocSub { margin-left: 15px; }
					.tocSubSub{ margin-left: 45px;}
					.litVerweis {	text-transform:	uppercase;
										font-weight: 		bold;}
					.litVerweisText {	text-transform:	uppercase;}
					.footfield	{color:red;}
					.quotefield	{	text-transform:	uppercase; color:black; font-weight:bold;}
					a:link {	color:black;
								text-decoration: none;
								}
					a:visited { 	color:grey;
									text-decoration: none;}					
				</style>
			</HEAD>
			<BODY>
				<script type="text/javascript"><![CDATA[ 
			function changeContent(id,shtml) {
   if (document.getElementById || document.all) {
      var el = document.getElementById? document.getElementById(id): document.all[id];
      if ((el) && (typeof el.innerHTML != "undefined")) el.innerHTML = shtml;
   }
} ]]></script>
				<xsl:apply-templates select="paper/meta"/>
				<xsl:call-template name="seperator"/>
				<xsl:call-template name="toc"/>
				<xsl:call-template name="seperator"/>
				<xsl:apply-templates select="paper/content"/>
				<xsl:call-template name="seperator"/>
				<xsl:apply-templates select="paper/bibliography"/>
				<xsl:call-template name="seperator"/>
				<xsl:call-template name="tof"/>
			</BODY>
		</HTML>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="meta">
		<xsl:for-each select="authors/author">
			<b>
				<xsl:text>Name : </xsl:text>
			</b>
			<xsl:value-of select="surname"/>
			<xsl:text>,</xsl:text>
			<xsl:for-each select="firstname">
				<xsl:text> </xsl:text>
				<xsl:value-of select="."/>
			</xsl:for-each>
			<xsl:text> </xsl:text>
			<b>
				<xsl:text>Matrikelnummer : </xsl:text>
			</b>
			<xsl:value-of select="matriculation-number"/>
			<b>
				<xsl:text> Email : </xsl:text>
			</b>
			<xsl:value-of select="email"/>
			<br/>
		</xsl:for-each>
		<b>
			<xsl:text>Datum : </xsl:text>
		</b>
		<xsl:value-of select="date"/>
		<br/>
		<h2>
			<xsl:value-of select="coursetitle"/>
		</h2>
		<br/>
		<h3>
			<xsl:value-of select="title"/>
		</h3>
		<xsl:if test="subtitle">
			<h4>
				<xsl:value-of select="subtitle"/>
			</h4>
		</xsl:if>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="content">
		<p>
			<xsl:apply-templates/>
			
		</p>
		<br/>
		<br/>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template name="seperator">
		<br/>
		<table width="100%">
			<tbody>
				<tr>
					<th bgcolor="#000000" height="1"/>
				</tr>
			</tbody>
		</table>
		<br/>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template name="toc">
		<p>
			<h3>Inhaltsverzeichnis</h3>
		</p>
		<xsl:for-each select="//section">
			<xsl:choose>
				<xsl:when test="../../../paper">
					<div class="tocRoot">
						<a>
							<xsl:attribute name="href">#"<xsl:value-of select="caption/text()"/>"</xsl:attribute>
							<xsl:number level="multiple" format="1.1.a. "/>
							<xsl:value-of select="caption/text()"/>
						</a>
					</div>
				</xsl:when>
				<xsl:when test="../../../../paper">
					<div class="tocSub">
						<a>
							<xsl:attribute name="href">#"<xsl:value-of select="caption/text()"/>"</xsl:attribute>
							<xsl:number level="multiple" format="1.1.a. "/>
							<xsl:value-of select="caption/text()"/>
						</a>
					</div>
				</xsl:when>
				<xsl:otherwise>
					<div class="tocSubSub">
						<a>
							<xsl:attribute name="href">#"<xsl:value-of select="caption/text()"/>"</xsl:attribute>
							<xsl:number level="multiple" format="1.1.a. "/>
							<xsl:value-of select="caption/text()"/>
						</a>
					</div>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
		<div class="tocRoot">
			<a href="#Literaturverzeichnis">A. Literaturverzeichnis</a>
		</div>
		<div class="tocRoot">
			<a href="#Abbildungsverzeichnis">B. Abbildungsverzeichnis</a>
		</div>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="caption">
		<a>
			<xsl:attribute name="name">"<xsl:value-of select="./text()"/>"</xsl:attribute>
		</a>
		<xsl:choose>
			<xsl:when test="../../../../paper">
				<h3>
					<xsl:number level="multiple" count="//section" format="1.1.a. "/>
					<xsl:value-of select="./text()"/>
				</h3>
			</xsl:when>
			<xsl:when test="../../../../../paper">
				<h4>
					<xsl:number level="multiple" count="//section" format="1.1.a. "/>
					<xsl:value-of select="./text()"/>
				</h4>
			</xsl:when>
			<xsl:when test="../../../../../../paper">
				<h5>
					<xsl:number level="multiple" count="//section" format="1.1.a. "/>
					<xsl:value-of select="./text()"/>
				</h5>
			</xsl:when>
			<xsl:otherwise>
				<h6>
					<xsl:number level="multiple" count="//section" format="1.1.a. "/>
					<xsl:value-of select="./text()"/>
				</h6>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="bibliography">
		<h3>
			<a name="Literaturverzeichnis">A. Literaturverzeichnis</a>
		</h3>
		<xsl:for-each select="bibItem">
			<xsl:sort data-type="text" order="ascending" select="author/surname"/>
			<xsl:sort data-type="text" order="ascending" select="author/firstname"/>
			<xsl:sort data-type="text" order="ascending" select="author/firstname[2]"/>
			<xsl:sort data-type="number" order="ascending" select="year"/>
			<xsl:sort data-type="text" order="ascending" select="title"/>
			<span class="litVerweis">
				<a>
					<xsl:attribute name="name"><xsl:call-template name="bibNameGen"/></xsl:attribute>
					<xsl:call-template name="bibNameGen"/>
				</a>
			</span>
			<xsl:for-each select="author">
				<xsl:variable name="author_nr">
					<xsl:number count="surname" value="position()"/>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="($author_nr)=1">
						<xsl:value-of select="surname"/>
						<xsl:text>, </xsl:text>
						<xsl:value-of select="firstname"/>
						<xsl:if test="firstname[2]">
							<xsl:text> </xsl:text>
							<xsl:value-of select="substring(firstname[2],1,1)"/>
							<xsl:text>.</xsl:text>
						</xsl:if>
					</xsl:when>
					<xsl:when test="($author_nr)>1">
						<xsl:text>; </xsl:text>
						<xsl:value-of select="firstname"/>
						<xsl:if test="firstname[2]">
							<xsl:text> </xsl:text>
							<xsl:value-of select="substring(firstname[2],1,1)"/>
							<xsl:text>. </xsl:text>
						</xsl:if>
						<xsl:value-of select="surname"/>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
			<xsl:text>: </xsl:text>
			<xsl:value-of select="title"/>.
			<xsl:value-of select="year"/>
			<xsl:text>; </xsl:text>
			<xsl:value-of select="publisher"/>
			<br/>
		</xsl:for-each>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template name="bibNameGen">
		<xsl:choose>
			<xsl:when test="author[2]">
				<xsl:text>[</xsl:text>
				<xsl:value-of select="substring(author/surname,1,2)"/>
				<xsl:value-of select="substring(author[2]/surname,1,2)"/>
				<xsl:value-of select="substring(year,3,4)"/>
				<xsl:text>]</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>[</xsl:text>
				<xsl:value-of select="substring(author/surname,1,2)"/>
				<xsl:value-of select="substring(author/firstname,1,2)"/>
				<xsl:value-of select="substring(year,3,4)"/>
				<xsl:text>]</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="image">
		<br/>
		<div>
			<img>
				<xsl:attribute name="src"><xsl:value-of select="@src"/></xsl:attribute>
				<xsl:attribute name="alt"><xsl:value-of select="@alt"/></xsl:attribute>
				<xsl:attribute name="heigth"><xsl:value-of select="@height"/></xsl:attribute>
				<xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute>
			</img>
			<xsl:variable name="bild_tmp" select="."/>
			<xsl:for-each select="//image">
				<xsl:if test="(.)=($bild_tmp)">
					<br/>
					<i>
						<b>Abb.<xsl:number level="single" value="position()" format="1: "/>
						</b>
						<xsl:value-of select="legend"/>
					</i>
					<br/>
				</xsl:if>
			</xsl:for-each>
		</div>
		<br/>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template name="tof">
		<h3>
			<a name="Abbildungsverzeichnis">B. Abbildungsverzeichnis</a>
		</h3>
		<xsl:for-each select="//image">
			<div>
				<img>
					<xsl:attribute name="src"><xsl:value-of select="@src"/></xsl:attribute>
					<xsl:attribute name="alt"><xsl:value-of select="@alt"/></xsl:attribute>
					<xsl:attribute name="heigth"><xsl:value-of select="@height"/></xsl:attribute>
					<xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute>
				</img>
				<br/>
				<i>
					<b>Abb.<xsl:number level="single" value="position()" format="1: "/>
					</b>
				</i>
				<xsl:value-of select="legend"/>
			</div>
			<br/>
		</xsl:for-each>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="ul">
		<xsl:element name="ul">
			<xsl:if test="@type">
				<xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="ol">
		<xsl:element name="ol">
			<xsl:if test="@type">
				<xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="li">
		<li>
			<xsl:apply-templates/>
		</li>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="table">

		<xsl:element name="table">
			<xsl:attribute name="border"><xsl:value-of select="@border"/></xsl:attribute>
			<thead>
				<xsl:if test="tr/th">
					<tr>
						<xsl:for-each select="tr/th">
							<th>
								<xsl:value-of select="."/>
							</th>
						</xsl:for-each>
					</tr>
				</xsl:if>
			</thead>
			<tbody>
				<xsl:for-each select="tr">
					<tr>
						<xsl:for-each select="td">
							<td>
								<xsl:value-of select="."/>
							</td>
						</xsl:for-each>
					</tr>
				</xsl:for-each>
			</tbody>
		</xsl:element>
		<xsl:variable name="table_tmp" select="."/>
		<xsl:for-each select="//table">
			<xsl:if test="(.)=($table_tmp)">
				<i>
					<b>Tab.<xsl:number level="single" value="position()" format="1: "/>
					</b>
					<xsl:value-of select="legend"/>
				</i>
				<br/>
			</xsl:if>
		</xsl:for-each>
		<br/>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="techterm">
		<b>
			<xsl:apply-templates/>
		</b>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="propname">
		<i>
			<xsl:apply-templates/>
		</i>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="trademark">
		<i>
			<xsl:apply-templates/>
		</i>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="kbd">
		<i>
			<xsl:apply-templates/>
		</i>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="var">
		<i>
			<xsl:apply-templates/>
		</i>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="samp">
		<i>
			<xsl:apply-templates/>
		</i>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="code">
		<i>
			<xsl:apply-templates/>
		</i>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="dfn">
		<i>
			<xsl:apply-templates/>
		</i>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<xsl:template match="footnote|quote">
		<xsl:if test="@bibItem-ref">
			<i>
				<xsl:value-of select="."/>
			</i>
		</xsl:if>
		<xsl:variable name="foot_tmp" select="."/>
		<xsl:for-each select="//footnote|//quote">
			<xsl:variable name="foot_nr">
				<xsl:number value="position()"/>
			</xsl:variable>
			<xsl:if test="($foot_tmp)=(.)">
				<xsl:variable name="footfield">
					<xsl:text>footfield</xsl:text>
					<xsl:value-of select="$foot_nr"/>
				</xsl:variable>
				<xsl:variable name="foot_txt">
					<xsl:choose>
						<xsl:when test="$foot_tmp/@bibItem-ref">
							<xsl:for-each select="//bibItem">
								<xsl:if test="($foot_tmp/@bibItem-ref)=(@bibItem-id)">
									<xsl:call-template name="bibNameGen"/>
								</xsl:if>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="."/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:element name="a">
					<xsl:attribute name="href">javascript:;</xsl:attribute>
					<xsl:attribute name="onclick"><xsl:text>changeContent('</xsl:text><xsl:value-of select="$footfield"/><xsl:text>','</xsl:text><xsl:value-of select="$foot_txt"/><xsl:text>')</xsl:text></xsl:attribute>
					<xsl:attribute name="ondblclick"><xsl:attribute name="href">javascript:;</xsl:attribute><xsl:text>changeContent('</xsl:text><xsl:value-of select="$footfield"/><xsl:text>',' ')</xsl:text></xsl:attribute>
					<sup>
						<xsl:value-of select="$foot_nr"/>
					</sup>
				</xsl:element>
				<xsl:element name="span">
					<xsl:attribute name="id"><xsl:value-of select="$footfield"/></xsl:attribute>
					<xsl:choose>
						<xsl:when test="$foot_tmp/@bibItem-ref">
							<xsl:attribute name="class">quotefield</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="class">footfield</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
	<!-- xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx -->
</xsl:stylesheet>
